/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeReportHandler;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNodeReportHandler
implements EventPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(TestNodeReportHandler.class);
    private NodeReportHandler nodeReportHandler;
    private SCMNodeManager nodeManager;
    private String storagePath = GenericTestUtils.getRandomizedTempPath().concat("/" + UUID.randomUUID().toString());

    @Before
    public void resetEventCollector() throws IOException {
        OzoneConfiguration conf = new OzoneConfiguration();
        SCMStorageConfig storageConfig = (SCMStorageConfig)Mockito.mock(SCMStorageConfig.class);
        Mockito.when((Object)storageConfig.getClusterID()).thenReturn((Object)"cluster1");
        NetworkTopologyImpl clusterMap = new NetworkTopologyImpl((ConfigurationSource)conf);
        this.nodeManager = new SCMNodeManager(conf, storageConfig, (EventPublisher)new EventQueue(), (NetworkTopology)clusterMap);
        this.nodeReportHandler = new NodeReportHandler((NodeManager)this.nodeManager);
    }

    @Test
    public void testNodeReport() throws IOException {
        DatanodeDetails dn = MockDatanodeDetails.randomDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.StorageReportProto storageOne = TestUtils.createStorageReport(dn.getUuid(), this.storagePath, 100L, 10L, 90L, null);
        SCMNodeMetric nodeMetric = this.nodeManager.getNodeStat(dn);
        Assert.assertNull((Object)nodeMetric);
        this.nodeManager.register(dn, (StorageContainerDatanodeProtocolProtos.NodeReportProto)this.getNodeReport(dn, storageOne).getReport(), null);
        nodeMetric = this.nodeManager.getNodeStat(dn);
        Assert.assertTrue((nodeMetric.get().getCapacity().get() == 100L ? 1 : 0) != 0);
        Assert.assertTrue((nodeMetric.get().getRemaining().get() == 90L ? 1 : 0) != 0);
        Assert.assertTrue((nodeMetric.get().getScmUsed().get() == 10L ? 1 : 0) != 0);
        StorageContainerDatanodeProtocolProtos.StorageReportProto storageTwo = TestUtils.createStorageReport(dn.getUuid(), this.storagePath, 100L, 10L, 90L, null);
        this.nodeReportHandler.onMessage(this.getNodeReport(dn, storageOne, storageTwo), (EventPublisher)this);
        nodeMetric = this.nodeManager.getNodeStat(dn);
        Assert.assertTrue((nodeMetric.get().getCapacity().get() == 200L ? 1 : 0) != 0);
        Assert.assertTrue((nodeMetric.get().getRemaining().get() == 180L ? 1 : 0) != 0);
        Assert.assertTrue((nodeMetric.get().getScmUsed().get() == 20L ? 1 : 0) != 0);
    }

    private SCMDatanodeHeartbeatDispatcher.NodeReportFromDatanode getNodeReport(DatanodeDetails dn, StorageContainerDatanodeProtocolProtos.StorageReportProto ... reports) {
        StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReportProto = TestUtils.createNodeReport(reports);
        return new SCMDatanodeHeartbeatDispatcher.NodeReportFromDatanode(dn, nodeReportProto);
    }

    public <PAYLOAD, EVENT_TYPE extends Event<PAYLOAD>> void fireEvent(EVENT_TYPE event, PAYLOAD payload) {
        LOG.info("Event is published: {}", payload);
    }
}

