/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.HddsTestUtils;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.node.DeadNodeHandler;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeReportHandler;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.MockRatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDeadNodeHandler {
    private StorageContainerManager scm;
    private SCMNodeManager nodeManager;
    private ContainerManager containerManager;
    private NodeReportHandler nodeReportHandler;
    private SCMPipelineManager pipelineManager;
    private DeadNodeHandler deadNodeHandler;
    private EventPublisher publisher;
    private EventQueue eventQueue;
    private String storageDir;

    @Before
    public void setup() throws IOException, AuthenticationException {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.setTimeDuration("hdds.scm.wait.time.after.safemode.exit", 0L, TimeUnit.SECONDS);
        this.storageDir = GenericTestUtils.getTempPath((String)(TestDeadNodeHandler.class.getSimpleName() + UUID.randomUUID()));
        conf.set("ozone.metadata.dirs", this.storageDir);
        this.eventQueue = new EventQueue();
        this.scm = HddsTestUtils.getScm(conf);
        this.nodeManager = (SCMNodeManager)this.scm.getScmNodeManager();
        this.pipelineManager = (SCMPipelineManager)this.scm.getPipelineManager();
        MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider((NodeManager)this.nodeManager, this.pipelineManager.getStateManager(), (ConfigurationSource)conf);
        this.pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        this.containerManager = this.scm.getContainerManager();
        this.deadNodeHandler = new DeadNodeHandler((NodeManager)this.nodeManager, (PipelineManager)Mockito.mock(PipelineManager.class), this.containerManager);
        this.eventQueue.addHandler((Event)SCMEvents.DEAD_NODE, (EventHandler)this.deadNodeHandler);
        this.publisher = (EventPublisher)Mockito.mock(EventPublisher.class);
        this.nodeReportHandler = new NodeReportHandler((NodeManager)this.nodeManager);
    }

    @After
    public void teardown() {
        this.scm.stop();
        this.scm.join();
        FileUtil.fullyDelete((File)new File(this.storageDir));
    }

    @Test
    public void testOnMessage() throws Exception {
        DatanodeDetails datanode1 = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails datanode2 = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails datanode3 = MockDatanodeDetails.randomDatanodeDetails();
        String storagePath = GenericTestUtils.getRandomizedTempPath().concat("/" + datanode1.getUuidString());
        StorageContainerDatanodeProtocolProtos.StorageReportProto storageOne = TestUtils.createStorageReport(datanode1.getUuid(), storagePath, 100L, 10L, 90L, null);
        this.scm.exitSafeMode();
        this.nodeManager.register(datanode1, TestUtils.createNodeReport(storageOne), null);
        this.nodeManager.register(datanode2, TestUtils.createNodeReport(storageOne), null);
        this.nodeManager.register(datanode3, TestUtils.createNodeReport(storageOne), null);
        this.nodeManager.register(MockDatanodeDetails.randomDatanodeDetails(), TestUtils.createNodeReport(storageOne), null);
        this.nodeManager.register(MockDatanodeDetails.randomDatanodeDetails(), TestUtils.createNodeReport(storageOne), null);
        this.nodeManager.register(MockDatanodeDetails.randomDatanodeDetails(), TestUtils.createNodeReport(storageOne), null);
        this.nodeManager.register(MockDatanodeDetails.randomDatanodeDetails(), TestUtils.createNodeReport(storageOne), null);
        this.nodeManager.register(MockDatanodeDetails.randomDatanodeDetails(), TestUtils.createNodeReport(storageOne), null);
        this.nodeManager.register(MockDatanodeDetails.randomDatanodeDetails(), TestUtils.createNodeReport(storageOne), null);
        LambdaTestUtils.await((int)120000, (int)1000, () -> {
            this.pipelineManager.triggerPipelineCreation();
            return this.pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE).size() == 3;
        });
        TestUtils.openAllRatisPipelines((PipelineManager)this.pipelineManager);
        ContainerInfo container1 = TestUtils.allocateContainer(this.containerManager);
        ContainerInfo container2 = TestUtils.allocateContainer(this.containerManager);
        ContainerInfo container3 = TestUtils.allocateContainer(this.containerManager);
        ContainerInfo container4 = TestUtils.allocateContainer(this.containerManager);
        this.registerContainers(datanode1, container1, container2, container4);
        this.registerContainers(datanode2, container1, container2);
        this.registerContainers(datanode3, container3);
        this.registerReplicas(this.containerManager, container1, datanode1, datanode2);
        this.registerReplicas(this.containerManager, container2, datanode1, datanode2);
        this.registerReplicas(this.containerManager, container3, datanode3);
        this.registerReplicas(this.containerManager, container4, datanode1);
        TestUtils.closeContainer(this.containerManager, container1.containerID());
        TestUtils.closeContainer(this.containerManager, container2.containerID());
        TestUtils.quasiCloseContainer(this.containerManager, container3.containerID());
        this.deadNodeHandler.onMessage(datanode1, this.publisher);
        Set container1Replicas = this.containerManager.getContainerReplicas(new ContainerID(container1.getContainerID()));
        Assert.assertEquals((long)1L, (long)container1Replicas.size());
        Assert.assertEquals((Object)datanode2, (Object)((ContainerReplica)container1Replicas.iterator().next()).getDatanodeDetails());
        Set container2Replicas = this.containerManager.getContainerReplicas(new ContainerID(container2.getContainerID()));
        Assert.assertEquals((long)1L, (long)container2Replicas.size());
        Assert.assertEquals((Object)datanode2, (Object)((ContainerReplica)container2Replicas.iterator().next()).getDatanodeDetails());
        Set container3Replicas = this.containerManager.getContainerReplicas(new ContainerID(container3.getContainerID()));
        Assert.assertEquals((long)1L, (long)container3Replicas.size());
        Assert.assertEquals((Object)datanode3, (Object)((ContainerReplica)container3Replicas.iterator().next()).getDatanodeDetails());
    }

    private void registerReplicas(ContainerManager contManager, ContainerInfo container, DatanodeDetails ... datanodes) throws ContainerNotFoundException {
        for (DatanodeDetails datanode : datanodes) {
            contManager.updateContainerReplica(new ContainerID(container.getContainerID()), ContainerReplica.newBuilder().setContainerState(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN).setContainerID(container.containerID()).setDatanodeDetails(datanode).build());
        }
    }

    private void registerContainers(DatanodeDetails datanode, ContainerInfo ... containers) throws NodeNotFoundException {
        this.nodeManager.setContainers(datanode, Arrays.stream(containers).map(container -> new ContainerID(container.getContainerID())).collect(Collectors.toSet()));
    }

    private SCMDatanodeHeartbeatDispatcher.NodeReportFromDatanode getNodeReport(DatanodeDetails dn, StorageContainerDatanodeProtocolProtos.StorageReportProto ... reports) {
        StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReportProto = TestUtils.createNodeReport(reports);
        return new SCMDatanodeHeartbeatDispatcher.NodeReportFromDatanode(dn, nodeReportProto);
    }
}

