/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.SCMContainerManager;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementCapacity;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStoreImpl;
import org.apache.hadoop.hdds.scm.node.DeadNodeHandler;
import org.apache.hadoop.hdds.scm.node.NewNodeHandler;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.node.StaleNodeHandler;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineManager;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.ozone.container.common.SCMTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class TestContainerPlacement {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private SCMMetadataStore scmMetadataStore;

    @Before
    public void createDbStore() throws IOException {
        this.scmMetadataStore = new SCMMetadataStoreImpl(this.getConf());
    }

    @After
    public void destroyDBStore() throws Exception {
        this.scmMetadataStore.getStore().close();
    }

    OzoneConfiguration getConf() {
        return new OzoneConfiguration();
    }

    SCMNodeManager createNodeManager(OzoneConfiguration config) throws IOException {
        EventQueue eventQueue = new EventQueue();
        eventQueue.addHandler((Event)SCMEvents.NEW_NODE, (EventHandler)Mockito.mock(NewNodeHandler.class));
        eventQueue.addHandler((Event)SCMEvents.STALE_NODE, (EventHandler)Mockito.mock(StaleNodeHandler.class));
        eventQueue.addHandler((Event)SCMEvents.DEAD_NODE, (EventHandler)Mockito.mock(DeadNodeHandler.class));
        SCMStorageConfig storageConfig = (SCMStorageConfig)Mockito.mock(SCMStorageConfig.class);
        Mockito.when((Object)storageConfig.getClusterID()).thenReturn((Object)"cluster1");
        SCMNodeManager nodeManager = new SCMNodeManager(config, storageConfig, (EventPublisher)eventQueue, null);
        return nodeManager;
    }

    SCMContainerManager createContainerManager(ConfigurationSource config, NodeManager scmNodeManager) throws IOException {
        EventQueue eventQueue = new EventQueue();
        SCMPipelineManager pipelineManager = new SCMPipelineManager(config, scmNodeManager, this.scmMetadataStore.getPipelineTable(), (EventPublisher)eventQueue);
        return new SCMContainerManager(config, this.scmMetadataStore.getContainerTable(), (BatchOperationHandler)this.scmMetadataStore.getStore(), (PipelineManager)pipelineManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testContainerPlacementCapacity() throws IOException, InterruptedException, TimeoutException {
        OzoneConfiguration conf = this.getConf();
        int nodeCount = 4;
        long capacity = 0x280000000L;
        long used = 0x80000000L;
        long remaining = 0x200000000L;
        File testDir = PathUtils.getTestDir(TestContainerPlacement.class);
        conf.set("ozone.metadata.dirs", testDir.getAbsolutePath());
        conf.setClass("ozone.scm.container.placement.impl", SCMContainerPlacementCapacity.class, PlacementPolicy.class);
        SCMNodeManager nodeManager = this.createNodeManager(conf);
        SCMContainerManager containerManager = this.createContainerManager((ConfigurationSource)conf, (NodeManager)nodeManager);
        List<DatanodeDetails> datanodes = TestUtils.getListOfRegisteredDatanodeDetails(nodeManager, 4);
        XceiverClientManager xceiverClientManager = null;
        try {
            for (DatanodeDetails datanodeDetails : datanodes) {
                nodeManager.processHeartbeat(datanodeDetails);
            }
            Thread.sleep(4000L);
            Assert.assertEquals((long)4L, (long)nodeManager.getNodeCount(HddsProtos.NodeState.HEALTHY));
            Assert.assertEquals((long)0xA00000000L, (long)nodeManager.getStats().getCapacity().get());
            Assert.assertEquals((long)0x200000000L, (long)nodeManager.getStats().getScmUsed().get());
            Assert.assertEquals((long)0x800000000L, (long)nodeManager.getStats().getRemaining().get());
            xceiverClientManager = new XceiverClientManager((ConfigurationSource)conf);
            ContainerInfo container = containerManager.allocateContainer(SCMTestUtils.getReplicationType((ConfigurationSource)conf), SCMTestUtils.getReplicationFactor((ConfigurationSource)conf), "ozone");
            Assert.assertEquals((long)SCMTestUtils.getReplicationFactor((ConfigurationSource)conf).getNumber(), (long)containerManager.getContainerReplicas(container.containerID()).size());
        }
        finally {
            IOUtils.closeQuietly((Closeable)containerManager);
            IOUtils.closeQuietly((Closeable)nodeManager);
            if (xceiverClientManager != null) {
                xceiverClientManager.close();
            }
            FileUtil.fullyDelete((File)testDir);
        }
    }
}

