/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.metadata;

import java.util.UUID;
import org.apache.hadoop.hdds.scm.metadata.PipelineIDCodec;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.junit.Assert;
import org.junit.Test;

public class TestPipelineIDCodec {
    @Test
    public void testPersistingZeroAsUUID() throws Exception {
        long leastSigBits = 0L;
        long mostSigBits = 0L;
        byte[] expected = new byte[]{this.b(0), this.b(0), this.b(0), this.b(0), this.b(0), this.b(0), this.b(0), this.b(0), this.b(0), this.b(0), this.b(0), this.b(0), this.b(0), this.b(0), this.b(0), this.b(0)};
        this.checkPersisting(leastSigBits, mostSigBits, expected);
    }

    @Test
    public void testPersistingFFAsUUID() throws Exception {
        long leastSigBits = -1L;
        long mostSigBits = -1L;
        byte[] expected = new byte[]{this.b(255), this.b(255), this.b(255), this.b(255), this.b(255), this.b(255), this.b(255), this.b(255), this.b(255), this.b(255), this.b(255), this.b(255), this.b(255), this.b(255), this.b(255), this.b(255)};
        this.checkPersisting(leastSigBits, mostSigBits, expected);
    }

    @Test
    public void testPersistingARandomUUID() throws Exception {
        for (int i = 0; i < 100; ++i) {
            UUID uuid = UUID.randomUUID();
            long mask = 255L;
            byte[] expected = new byte[]{this.b((int)(uuid.getMostSignificantBits() >> 56 & mask)), this.b((int)(uuid.getMostSignificantBits() >> 48 & mask)), this.b((int)(uuid.getMostSignificantBits() >> 40 & mask)), this.b((int)(uuid.getMostSignificantBits() >> 32 & mask)), this.b((int)(uuid.getMostSignificantBits() >> 24 & mask)), this.b((int)(uuid.getMostSignificantBits() >> 16 & mask)), this.b((int)(uuid.getMostSignificantBits() >> 8 & mask)), this.b((int)(uuid.getMostSignificantBits() & mask)), this.b((int)(uuid.getLeastSignificantBits() >> 56 & mask)), this.b((int)(uuid.getLeastSignificantBits() >> 48 & mask)), this.b((int)(uuid.getLeastSignificantBits() >> 40 & mask)), this.b((int)(uuid.getLeastSignificantBits() >> 32 & mask)), this.b((int)(uuid.getLeastSignificantBits() >> 24 & mask)), this.b((int)(uuid.getLeastSignificantBits() >> 16 & mask)), this.b((int)(uuid.getLeastSignificantBits() >> 8 & mask)), this.b((int)(uuid.getLeastSignificantBits() & mask))};
            this.checkPersisting(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits(), expected);
        }
    }

    @Test
    public void testConvertAndReadBackZeroAsUUID() throws Exception {
        long mostSigBits = 0L;
        long leastSigBits = 0L;
        UUID uuid = new UUID(mostSigBits, leastSigBits);
        PipelineID pid = PipelineID.valueOf((UUID)uuid);
        byte[] encoded = new PipelineIDCodec().toPersistedFormat(pid);
        PipelineID decoded = new PipelineIDCodec().fromPersistedFormat(encoded);
        Assert.assertEquals((Object)pid, (Object)decoded);
    }

    @Test
    public void testConvertAndReadBackFFAsUUID() throws Exception {
        long mostSigBits = -1L;
        long leastSigBits = -1L;
        UUID uuid = new UUID(mostSigBits, leastSigBits);
        PipelineID pid = PipelineID.valueOf((UUID)uuid);
        byte[] encoded = new PipelineIDCodec().toPersistedFormat(pid);
        PipelineID decoded = new PipelineIDCodec().fromPersistedFormat(encoded);
        Assert.assertEquals((Object)pid, (Object)decoded);
    }

    @Test
    public void testConvertAndReadBackRandomUUID() throws Exception {
        UUID uuid = UUID.randomUUID();
        PipelineID pid = PipelineID.valueOf((UUID)uuid);
        byte[] encoded = new PipelineIDCodec().toPersistedFormat(pid);
        PipelineID decoded = new PipelineIDCodec().fromPersistedFormat(encoded);
        Assert.assertEquals((Object)pid, (Object)decoded);
    }

    private void checkPersisting(long mostSigBits, long leastSigBits, byte[] expected) throws Exception {
        UUID uuid = new UUID(mostSigBits, leastSigBits);
        PipelineID pid = PipelineID.valueOf((UUID)uuid);
        byte[] encoded = new PipelineIDCodec().toPersistedFormat(pid);
        Assert.assertArrayEquals((byte[])expected, (byte[])encoded);
    }

    private byte b(int i) {
        return (byte)(i & 0xFF);
    }
}

