/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.states;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.states.ContainerAttribute;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestContainerAttribute {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testInsert() throws SCMException {
        ContainerAttribute containerAttribute = new ContainerAttribute();
        ContainerID id = new ContainerID(42L);
        containerAttribute.insert((Object)1, id);
        Assert.assertEquals((long)1L, (long)containerAttribute.getCollection((Object)1).size());
        Assert.assertTrue((boolean)containerAttribute.getCollection((Object)1).contains(id));
        ContainerID newId = new ContainerID(42L);
        containerAttribute.insert((Object)1, newId);
        Assert.assertEquals((long)1L, (long)containerAttribute.getCollection((Object)1).size());
        Assert.assertTrue((boolean)containerAttribute.getCollection((Object)1).contains(newId));
    }

    @Test
    public void testHasKey() throws SCMException {
        int x;
        ContainerAttribute containerAttribute = new ContainerAttribute();
        for (x = 1; x < 42; ++x) {
            containerAttribute.insert((Object)1, new ContainerID((long)x));
        }
        Assert.assertTrue((boolean)containerAttribute.hasKey((Object)1));
        for (x = 1; x < 42; ++x) {
            Assert.assertTrue((boolean)containerAttribute.hasContainerID((Object)1, x));
        }
        Assert.assertFalse((boolean)containerAttribute.hasContainerID((Object)1, new ContainerID(42L)));
    }

    @Test
    public void testClearSet() throws SCMException {
        List<String> keyslist = Arrays.asList("Key1", "Key2", "Key3");
        ContainerAttribute containerAttribute = new ContainerAttribute();
        for (String k : keyslist) {
            for (int x = 1; x < 101; ++x) {
                containerAttribute.insert((Object)k, new ContainerID((long)x));
            }
        }
        for (String k : keyslist) {
            Assert.assertEquals((long)100L, (long)containerAttribute.getCollection((Object)k).size());
        }
        containerAttribute.clearSet((Object)"Key1");
        Assert.assertEquals((long)0L, (long)containerAttribute.getCollection((Object)"Key1").size());
    }

    @Test
    public void testRemove() throws SCMException {
        int x;
        List<String> keyslist = Arrays.asList("Key1", "Key2", "Key3");
        ContainerAttribute containerAttribute = new ContainerAttribute();
        for (String k : keyslist) {
            for (int x2 = 1; x2 < 101; ++x2) {
                containerAttribute.insert((Object)k, new ContainerID((long)x2));
            }
        }
        for (x = 1; x < 101; x += 2) {
            containerAttribute.remove((Object)"Key1", new ContainerID((long)x));
        }
        for (x = 1; x < 101; x += 2) {
            Assert.assertFalse((boolean)containerAttribute.hasContainerID((Object)"Key1", new ContainerID((long)x)));
        }
        Assert.assertEquals((long)100L, (long)containerAttribute.getCollection((Object)"Key2").size());
        Assert.assertEquals((long)100L, (long)containerAttribute.getCollection((Object)"Key3").size());
        Assert.assertEquals((long)50L, (long)containerAttribute.getCollection((Object)"Key1").size());
    }

    @Test
    public void tesUpdate() throws SCMException {
        String key1 = "Key1";
        String key2 = "Key2";
        String key3 = "Key3";
        ContainerAttribute containerAttribute = new ContainerAttribute();
        ContainerID id = new ContainerID(42L);
        containerAttribute.insert((Object)key1, id);
        Assert.assertTrue((boolean)containerAttribute.hasContainerID((Object)key1, id));
        Assert.assertFalse((boolean)containerAttribute.hasContainerID((Object)key2, id));
        containerAttribute.update((Object)key1, (Object)key2, id);
        Assert.assertFalse((boolean)containerAttribute.hasContainerID((Object)key1, id));
        Assert.assertTrue((boolean)containerAttribute.hasContainerID((Object)key2, id));
        this.thrown.expect(SCMException.class);
        containerAttribute.update((Object)key3, (Object)key1, id);
    }
}

