/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementRandom;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestSCMContainerPlacementRandom {
    @Test
    public void chooseDatanodes() throws SCMException {
        OzoneConfiguration conf = new OzoneConfiguration();
        ArrayList<DatanodeDetails> datanodes = new ArrayList<DatanodeDetails>();
        for (int i = 0; i < 5; ++i) {
            datanodes.add(MockDatanodeDetails.randomDatanodeDetails());
        }
        NodeManager mockNodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)mockNodeManager.getNodes(HddsProtos.NodeState.HEALTHY)).thenReturn(new ArrayList(datanodes));
        Mockito.when((Object)mockNodeManager.getNodeStat((DatanodeDetails)Matchers.anyObject())).thenReturn((Object)new SCMNodeMetric(100L, 0L, 100L));
        Mockito.when((Object)mockNodeManager.getNodeStat((DatanodeDetails)datanodes.get(2))).thenReturn((Object)new SCMNodeMetric(100L, 90L, 10L));
        SCMContainerPlacementRandom scmContainerPlacementRandom = new SCMContainerPlacementRandom(mockNodeManager, (ConfigurationSource)conf, null, true, null);
        ArrayList existingNodes = new ArrayList();
        existingNodes.add(datanodes.get(0));
        existingNodes.add(datanodes.get(1));
        for (int i = 0; i < 100; ++i) {
            List datanodeDetails = scmContainerPlacementRandom.chooseDatanodes(existingNodes, null, 1, 15L);
            Assert.assertEquals((long)1L, (long)datanodeDetails.size());
            DatanodeDetails datanode0Details = (DatanodeDetails)datanodeDetails.get(0);
            Assert.assertNotEquals((String)"Datanode 0 should not been selected: excluded by parameter", datanodes.get(0), (Object)datanode0Details);
            Assert.assertNotEquals((String)"Datanode 1 should not been selected: excluded by parameter", datanodes.get(1), (Object)datanode0Details);
            Assert.assertNotEquals((String)"Datanode 2 should not been selected: not enough space there", datanodes.get(2), (Object)datanode0Details);
        }
    }

    @Test
    public void testPlacementPolicySatisified() {
        OzoneConfiguration conf = new OzoneConfiguration();
        ArrayList<DatanodeDetails> datanodes = new ArrayList<DatanodeDetails>();
        for (int i = 0; i < 3; ++i) {
            datanodes.add(MockDatanodeDetails.randomDatanodeDetails());
        }
        NodeManager mockNodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        SCMContainerPlacementRandom scmContainerPlacementRandom = new SCMContainerPlacementRandom(mockNodeManager, (ConfigurationSource)conf, null, true, null);
        ContainerPlacementStatus status = scmContainerPlacementRandom.validateContainerPlacement(datanodes, 3);
        TestCase.assertTrue((boolean)status.isPolicySatisfied());
        TestCase.assertEquals((int)0, (int)status.misReplicationCount());
        status = scmContainerPlacementRandom.validateContainerPlacement(new ArrayList(), 3);
        Assert.assertFalse((boolean)status.isPolicySatisfied());
        TestCase.assertEquals((float)1.0f, (float)status.misReplicationCount(), (float)3.0f);
        datanodes = new ArrayList();
        datanodes.add(MockDatanodeDetails.randomDatanodeDetails());
        status = scmContainerPlacementRandom.validateContainerPlacement(datanodes, 3);
        TestCase.assertTrue((boolean)status.isPolicySatisfied());
        TestCase.assertEquals((float)0.0f, (float)status.misReplicationCount(), (float)3.0f);
    }
}

