/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementRackAware;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetConstants;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.net.NodeSchema;
import org.apache.hadoop.hdds.scm.net.NodeSchemaManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestSCMContainerPlacementRackAware {
    private NetworkTopology cluster;
    private ConfigurationSource conf;
    private NodeManager nodeManager;
    private Integer datanodeCount;
    private List<DatanodeDetails> datanodes = new ArrayList<DatanodeDetails>();
    private SCMContainerPlacementRackAware policy;
    private SCMContainerPlacementRackAware policyNoFallback;
    private static final long STORAGE_CAPACITY = 100L;
    private SCMContainerPlacementMetrics metrics;
    private static final int NODE_PER_RACK = 5;

    public TestSCMContainerPlacementRackAware(Integer count) {
        this.datanodeCount = count;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> setupDatanodes() {
        return Arrays.asList({3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}, {13}, {14}, {15});
    }

    @Before
    public void setup() {
        this.conf = new OzoneConfiguration();
        NodeSchema[] schemas = new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.LEAF_SCHEMA};
        NodeSchemaManager.getInstance().init(schemas, true);
        this.cluster = new NetworkTopologyImpl(NodeSchemaManager.getInstance());
        String rack = "/rack";
        String hostname = "node";
        for (int i = 0; i < this.datanodeCount; ++i) {
            DatanodeDetails node = MockDatanodeDetails.createDatanodeDetails((String)(hostname + i), (String)(rack + i / 5));
            this.datanodes.add(node);
            this.cluster.add((Node)node);
        }
        this.nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)this.nodeManager.getClusterNetworkTopologyMap()).thenReturn((Object)this.cluster);
        Mockito.when((Object)this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY)).thenReturn(new ArrayList<DatanodeDetails>(this.datanodes));
        Mockito.when((Object)this.nodeManager.getNodeStat((DatanodeDetails)org.mockito.Matchers.anyObject())).thenReturn((Object)new SCMNodeMetric(100L, 0L, 100L));
        if (this.datanodeCount > 4) {
            Mockito.when((Object)this.nodeManager.getNodeStat(this.datanodes.get(2))).thenReturn((Object)new SCMNodeMetric(100L, 90L, 10L));
            Mockito.when((Object)this.nodeManager.getNodeStat(this.datanodes.get(3))).thenReturn((Object)new SCMNodeMetric(100L, 80L, 20L));
            Mockito.when((Object)this.nodeManager.getNodeStat(this.datanodes.get(4))).thenReturn((Object)new SCMNodeMetric(100L, 70L, 30L));
        } else if (this.datanodeCount > 3) {
            Mockito.when((Object)this.nodeManager.getNodeStat(this.datanodes.get(2))).thenReturn((Object)new SCMNodeMetric(100L, 90L, 10L));
            Mockito.when((Object)this.nodeManager.getNodeStat(this.datanodes.get(3))).thenReturn((Object)new SCMNodeMetric(100L, 80L, 20L));
        } else if (this.datanodeCount > 2) {
            Mockito.when((Object)this.nodeManager.getNodeStat(this.datanodes.get(2))).thenReturn((Object)new SCMNodeMetric(100L, 84L, 16L));
        }
        this.metrics = SCMContainerPlacementMetrics.create();
        this.policy = new SCMContainerPlacementRackAware(this.nodeManager, this.conf, this.cluster, true, this.metrics);
        this.policyNoFallback = new SCMContainerPlacementRackAware(this.nodeManager, this.conf, this.cluster, false, this.metrics);
    }

    @Test
    public void chooseNodeWithNoExcludedNodes() throws SCMException {
        int nodeNum = 1;
        List datanodeDetails = this.policy.chooseDatanodes(null, null, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        nodeNum = 2;
        datanodeDetails = this.policy.chooseDatanodes(null, null, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assert.assertTrue((this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(1)) || this.datanodeCount % 5 == 1 ? 1 : 0) != 0);
        nodeNum = 3;
        datanodeDetails = this.policy.chooseDatanodes(null, null, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assume.assumeTrue((this.datanodeCount > 5 && this.datanodeCount % 5 > 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(1)));
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(2)));
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(1), (Node)datanodeDetails.get(2)));
        nodeNum = 4;
        datanodeDetails = this.policy.chooseDatanodes(null, null, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assume.assumeTrue((this.datanodeCount > 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(1)));
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(2)));
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(1), (Node)datanodeDetails.get(2)));
    }

    @Test
    public void chooseNodeWithExcludedNodes() throws SCMException {
        Assume.assumeTrue((this.datanodeCount > 5 ? 1 : 0) != 0);
        int nodeNum = 1;
        ArrayList<DatanodeDetails> excludedNodes = new ArrayList<DatanodeDetails>();
        excludedNodes.add(this.datanodes.get(0));
        excludedNodes.add(this.datanodes.get(1));
        List datanodeDetails = this.policy.chooseDatanodes(excludedNodes, null, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)excludedNodes.get(0)));
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)excludedNodes.get(1)));
        nodeNum = 2;
        excludedNodes.clear();
        excludedNodes.add(this.datanodes.get(0));
        datanodeDetails = this.policy.chooseDatanodes(excludedNodes, null, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assert.assertTrue((this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)excludedNodes.get(0)) || this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)excludedNodes.get(1)) ? 1 : 0) != 0);
        nodeNum = 1;
        excludedNodes.clear();
        excludedNodes.add(this.datanodes.get(0));
        excludedNodes.add(this.datanodes.get(5));
        datanodeDetails = this.policy.chooseDatanodes(excludedNodes, null, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assert.assertTrue((this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)excludedNodes.get(0)) || this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)excludedNodes.get(1)) ? 1 : 0) != 0);
    }

    @Test
    public void testFallback() throws SCMException {
        Assume.assumeTrue((this.datanodeCount > 10 && this.datanodeCount % 5 > 1 ? 1 : 0) != 0);
        int nodeNum = 5;
        List datanodeDetails = this.policy.chooseDatanodes(null, null, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assert.assertTrue((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(1)));
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(2)));
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(1), (Node)datanodeDetails.get(2)));
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(3)));
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(2), (Node)datanodeDetails.get(3)));
        long totalRequest = this.metrics.getDatanodeRequestCount();
        long successCount = this.metrics.getDatanodeChooseSuccessCount();
        long tryCount = this.metrics.getDatanodeChooseAttemptCount();
        long compromiseCount = this.metrics.getDatanodeChooseFallbackCount();
        Assert.assertEquals((long)totalRequest, (long)nodeNum);
        Assert.assertEquals((long)successCount, (long)nodeNum);
        Assert.assertTrue((tryCount > (long)nodeNum ? 1 : 0) != 0);
        Assert.assertTrue((compromiseCount >= 1L ? 1 : 0) != 0);
    }

    @Test
    public void testNoFallback() throws SCMException {
        Assume.assumeTrue((this.datanodeCount > 10 && this.datanodeCount <= 15 ? 1 : 0) != 0);
        int nodeNum = 5;
        try {
            this.policyNoFallback.chooseDatanodes(null, null, nodeNum, 15L);
            Assert.fail((String)"Fallback prohibited, this call should fail");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"SCMException", (Object)e.getClass().getSimpleName());
        }
        long totalRequest = this.metrics.getDatanodeRequestCount();
        long successCount = this.metrics.getDatanodeChooseSuccessCount();
        long tryCount = this.metrics.getDatanodeChooseAttemptCount();
        long compromiseCount = this.metrics.getDatanodeChooseFallbackCount();
        Assert.assertEquals((long)totalRequest, (long)nodeNum);
        MatcherAssert.assertThat((String)"Not enough success count", (Object)successCount, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
        MatcherAssert.assertThat((String)"Not enough try count", (Object)tryCount, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((long)compromiseCount, (long)0L);
    }

    @Test
    public void chooseNodeWithFavoredNodes() throws SCMException {
        int nodeNum = 1;
        ArrayList<DatanodeDetails> excludedNodes = new ArrayList<DatanodeDetails>();
        ArrayList<DatanodeDetails> favoredNodes = new ArrayList<DatanodeDetails>();
        favoredNodes.add(this.datanodes.get(0));
        List datanodeDetails = this.policy.chooseDatanodes(excludedNodes, favoredNodes, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assert.assertEquals((Object)((DatanodeDetails)datanodeDetails.get(0)).getNetworkFullPath(), (Object)((DatanodeDetails)favoredNodes.get(0)).getNetworkFullPath());
        excludedNodes.clear();
        favoredNodes.clear();
        excludedNodes.add(this.datanodes.get(0));
        favoredNodes.add(this.datanodes.get(2));
        datanodeDetails = this.policy.chooseDatanodes(excludedNodes, favoredNodes, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assert.assertEquals((Object)((DatanodeDetails)datanodeDetails.get(0)).getNetworkFullPath(), (Object)((DatanodeDetails)favoredNodes.get(0)).getNetworkFullPath());
        excludedNodes.clear();
        favoredNodes.clear();
        excludedNodes.add(this.datanodes.get(0));
        favoredNodes.add(this.datanodes.get(0));
        datanodeDetails = this.policy.chooseDatanodes(excludedNodes, favoredNodes, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assert.assertFalse((boolean)((DatanodeDetails)datanodeDetails.get(0)).getNetworkFullPath().equals(((DatanodeDetails)favoredNodes.get(0)).getNetworkFullPath()));
    }

    @Test
    public void testNoInfiniteLoop() throws SCMException {
        int nodeNum = 1;
        try {
            this.policy.chooseDatanodes(null, null, nodeNum, 115L);
            Assert.fail((String)"Storage requested exceeds capacity, this call should fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getClass().getSimpleName().equals("SCMException"));
        }
        long totalRequest = this.metrics.getDatanodeRequestCount();
        long successCount = this.metrics.getDatanodeChooseSuccessCount();
        long tryCount = this.metrics.getDatanodeChooseAttemptCount();
        long compromiseCount = this.metrics.getDatanodeChooseFallbackCount();
        Assert.assertEquals((long)totalRequest, (long)nodeNum);
        Assert.assertEquals((long)successCount, (long)0L);
        MatcherAssert.assertThat((String)"Not enough try", (Object)tryCount, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(nodeNum)));
        Assert.assertEquals((long)compromiseCount, (long)0L);
    }

    @Test
    public void testDatanodeWithDefaultNetworkLocation() throws SCMException {
        String hostname = "node";
        ArrayList<DatanodeDetails> dataList = new ArrayList<DatanodeDetails>();
        NetworkTopologyImpl clusterMap = new NetworkTopologyImpl(NodeSchemaManager.getInstance());
        for (int i = 0; i < 15; ++i) {
            DatanodeDetails node = MockDatanodeDetails.createDatanodeDetails((String)(hostname + i), null);
            dataList.add(node);
            clusterMap.add((Node)node);
        }
        Assert.assertEquals((long)dataList.size(), (long)StringUtils.countMatches((CharSequence)clusterMap.toString(), (CharSequence)"/default-rack"));
        int nodeNum = 3;
        SCMContainerPlacementRackAware newPolicy = new SCMContainerPlacementRackAware(this.nodeManager, this.conf, (NetworkTopology)clusterMap, true, this.metrics);
        List datanodeDetails = newPolicy.chooseDatanodes(null, null, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assert.assertTrue((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(1)));
        Assert.assertTrue((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(2)));
        Assert.assertTrue((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(1), (Node)datanodeDetails.get(2)));
    }

    @Test
    public void testvalidateContainerPlacement() {
        Assume.assumeTrue((this.datanodeCount == 15 ? 1 : 0) != 0);
        ArrayList<DatanodeDetails> dns = new ArrayList<DatanodeDetails>();
        dns.add(this.datanodes.get(0));
        dns.add(this.datanodes.get(1));
        dns.add(this.datanodes.get(2));
        ContainerPlacementStatus stat = this.policy.validateContainerPlacement(dns, 3);
        Assert.assertFalse((boolean)stat.isPolicySatisfied());
        Assert.assertEquals((long)1L, (long)stat.misReplicationCount());
        dns = new ArrayList();
        dns.add(this.datanodes.get(0));
        dns.add(this.datanodes.get(1));
        dns.add(this.datanodes.get(5));
        stat = this.policy.validateContainerPlacement(dns, 3);
        Assert.assertTrue((boolean)stat.isPolicySatisfied());
        Assert.assertEquals((long)0L, (long)stat.misReplicationCount());
        dns = new ArrayList();
        dns.add(this.datanodes.get(0));
        stat = this.policy.validateContainerPlacement(dns, 3);
        Assert.assertFalse((boolean)stat.isPolicySatisfied());
        Assert.assertEquals((long)1L, (long)stat.misReplicationCount());
        dns = new ArrayList();
        dns.add(this.datanodes.get(0));
        stat = this.policy.validateContainerPlacement(dns, 1);
        Assert.assertTrue((boolean)stat.isPolicySatisfied());
        Assert.assertEquals((long)0L, (long)stat.misReplicationCount());
    }

    @Test
    public void testvalidateContainerPlacementSingleRackCluster() {
        Assume.assumeTrue((this.datanodeCount == 5 ? 1 : 0) != 0);
        ArrayList<DatanodeDetails> dns = new ArrayList<DatanodeDetails>();
        dns.add(this.datanodes.get(0));
        dns.add(this.datanodes.get(1));
        dns.add(this.datanodes.get(2));
        ContainerPlacementStatus stat = this.policy.validateContainerPlacement(dns, 3);
        Assert.assertTrue((boolean)stat.isPolicySatisfied());
        Assert.assertEquals((long)0L, (long)stat.misReplicationCount());
        dns = new ArrayList();
        dns.add(this.datanodes.get(0));
        stat = this.policy.validateContainerPlacement(dns, 3);
        Assert.assertTrue((boolean)stat.isPolicySatisfied());
        Assert.assertEquals((long)0L, (long)stat.misReplicationCount());
        dns = new ArrayList();
        dns.add(this.datanodes.get(0));
        stat = this.policy.validateContainerPlacement(dns, 1);
        Assert.assertTrue((boolean)stat.isPolicySatisfied());
        Assert.assertEquals((long)0L, (long)stat.misReplicationCount());
    }
}

