/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementCapacity;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestSCMContainerPlacementCapacity {
    @Test
    public void chooseDatanodes() throws SCMException {
        OzoneConfiguration conf = new OzoneConfiguration();
        ArrayList<DatanodeDetails> datanodes = new ArrayList<DatanodeDetails>();
        for (int i = 0; i < 7; ++i) {
            datanodes.add(MockDatanodeDetails.randomDatanodeDetails());
        }
        NodeManager mockNodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)mockNodeManager.getNodes(HddsProtos.NodeState.HEALTHY)).thenReturn(new ArrayList(datanodes));
        Mockito.when((Object)mockNodeManager.getNodeStat((DatanodeDetails)Matchers.anyObject())).thenReturn((Object)new SCMNodeMetric(100L, 0L, 100L));
        Mockito.when((Object)mockNodeManager.getNodeStat((DatanodeDetails)datanodes.get(2))).thenReturn((Object)new SCMNodeMetric(100L, 90L, 10L));
        Mockito.when((Object)mockNodeManager.getNodeStat((DatanodeDetails)datanodes.get(3))).thenReturn((Object)new SCMNodeMetric(100L, 80L, 20L));
        Mockito.when((Object)mockNodeManager.getNodeStat((DatanodeDetails)datanodes.get(4))).thenReturn((Object)new SCMNodeMetric(100L, 70L, 30L));
        SCMContainerPlacementCapacity scmContainerPlacementRandom = new SCMContainerPlacementCapacity(mockNodeManager, (ConfigurationSource)conf, null, true, null);
        ArrayList existingNodes = new ArrayList();
        existingNodes.add(datanodes.get(0));
        existingNodes.add(datanodes.get(1));
        HashMap<DatanodeDetails, Integer> selectedCount = new HashMap<DatanodeDetails, Integer>();
        for (DatanodeDetails datanode : datanodes) {
            selectedCount.put(datanode, 0);
        }
        for (int i = 0; i < 1000; ++i) {
            List datanodeDetails = scmContainerPlacementRandom.chooseDatanodes(existingNodes, null, 1, 15L);
            Assert.assertEquals((long)1L, (long)datanodeDetails.size());
            DatanodeDetails datanode0Details = (DatanodeDetails)datanodeDetails.get(0);
            Assert.assertNotEquals((String)"Datanode 0 should not been selected: excluded by parameter", datanodes.get(0), (Object)datanode0Details);
            Assert.assertNotEquals((String)"Datanode 1 should not been selected: excluded by parameter", datanodes.get(1), (Object)datanode0Details);
            Assert.assertNotEquals((String)"Datanode 2 should not been selected: not enough space there", datanodes.get(2), (Object)datanode0Details);
            selectedCount.put(datanode0Details, (Integer)selectedCount.get(datanode0Details) + 1);
        }
        Assert.assertTrue(((Integer)selectedCount.get(datanodes.get(3)) > (Integer)selectedCount.get(datanodes.get(6)) ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)selectedCount.get(datanodes.get(4)) > (Integer)selectedCount.get(datanodes.get(6)) ? 1 : 0) != 0);
    }
}

