/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import junit.framework.TestCase;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementStatusDefault;
import org.junit.Assert;
import org.junit.Test;

public class TestContainerPlacementStatusDefault {
    @Test
    public void testPlacementSatisfiedCorrectly() {
        ContainerPlacementStatusDefault stat = new ContainerPlacementStatusDefault(1, 1, 1);
        TestCase.assertTrue((boolean)stat.isPolicySatisfied());
        TestCase.assertEquals((int)0, (int)stat.misReplicationCount());
        stat = new ContainerPlacementStatusDefault(1, 2, 1);
        TestCase.assertTrue((boolean)stat.isPolicySatisfied());
        TestCase.assertEquals((int)0, (int)stat.misReplicationCount());
        stat = new ContainerPlacementStatusDefault(2, 2, 3);
        TestCase.assertTrue((boolean)stat.isPolicySatisfied());
        TestCase.assertEquals((int)0, (int)stat.misReplicationCount());
        stat = new ContainerPlacementStatusDefault(3, 2, 3);
        TestCase.assertTrue((boolean)stat.isPolicySatisfied());
        TestCase.assertEquals((int)0, (int)stat.misReplicationCount());
    }

    @Test
    public void testPlacementNotSatisfied() {
        ContainerPlacementStatusDefault stat = new ContainerPlacementStatusDefault(1, 2, 2);
        Assert.assertFalse((boolean)stat.isPolicySatisfied());
        TestCase.assertEquals((int)1, (int)stat.misReplicationCount());
        stat = new ContainerPlacementStatusDefault(0, 2, 1);
        Assert.assertFalse((boolean)stat.isPolicySatisfied());
        TestCase.assertEquals((int)2, (int)stat.misReplicationCount());
        stat = new ContainerPlacementStatusDefault(2, 3, 3);
        Assert.assertFalse((boolean)stat.isPolicySatisfied());
        TestCase.assertEquals((int)1, (int)stat.misReplicationCount());
    }
}

