/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicyFactory;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementStatusDefault;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementRackAware;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementRandom;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetConstants;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.net.NodeSchema;
import org.apache.hadoop.hdds.scm.net.NodeSchemaManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestContainerPlacementFactory {
    private NetworkTopology cluster;
    private List<DatanodeDetails> datanodes = new ArrayList<DatanodeDetails>();
    private final long storageCapacity = 100L;
    private OzoneConfiguration conf;
    private NodeManager nodeManager;

    @Before
    public void setup() {
        this.conf = new OzoneConfiguration();
    }

    @Test
    public void testRackAwarePolicy() throws IOException {
        this.conf.set("ozone.scm.container.placement.impl", SCMContainerPlacementRackAware.class.getName());
        NodeSchema[] schemas = new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.LEAF_SCHEMA};
        NodeSchemaManager.getInstance().init(schemas, true);
        this.cluster = new NetworkTopologyImpl(NodeSchemaManager.getInstance());
        String rack = "/rack";
        String hostname = "node";
        for (int i = 0; i < 15; ++i) {
            DatanodeDetails node = MockDatanodeDetails.createDatanodeDetails((String)(hostname + i), (String)(rack + i / 5));
            this.datanodes.add(node);
            this.cluster.add((Node)node);
        }
        this.nodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY)).thenReturn(new ArrayList<DatanodeDetails>(this.datanodes));
        Mockito.when((Object)this.nodeManager.getNodeStat((DatanodeDetails)Matchers.anyObject())).thenReturn((Object)new SCMNodeMetric(100L, 0L, 100L));
        Mockito.when((Object)this.nodeManager.getNodeStat(this.datanodes.get(2))).thenReturn((Object)new SCMNodeMetric(100L, 90L, 10L));
        Mockito.when((Object)this.nodeManager.getNodeStat(this.datanodes.get(3))).thenReturn((Object)new SCMNodeMetric(100L, 80L, 20L));
        Mockito.when((Object)this.nodeManager.getNodeStat(this.datanodes.get(4))).thenReturn((Object)new SCMNodeMetric(100L, 70L, 30L));
        PlacementPolicy policy = ContainerPlacementPolicyFactory.getPolicy((ConfigurationSource)this.conf, (NodeManager)this.nodeManager, (NetworkTopology)this.cluster, (boolean)true, (SCMContainerPlacementMetrics)SCMContainerPlacementMetrics.create());
        int nodeNum = 3;
        List datanodeDetails = policy.chooseDatanodes(null, null, nodeNum, 15L);
        Assert.assertEquals((long)nodeNum, (long)datanodeDetails.size());
        Assert.assertTrue((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(1)));
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(0), (Node)datanodeDetails.get(2)));
        Assert.assertFalse((boolean)this.cluster.isSameParent((Node)datanodeDetails.get(1), (Node)datanodeDetails.get(2)));
    }

    @Test
    public void testDefaultPolicy() throws IOException {
        PlacementPolicy policy = ContainerPlacementPolicyFactory.getPolicy((ConfigurationSource)this.conf, null, null, (boolean)true, null);
        Assert.assertSame(SCMContainerPlacementRandom.class, policy.getClass());
    }

    @Test(expected=SCMException.class)
    public void testConstuctorNotFound() throws SCMException {
        this.conf.set("ozone.scm.container.placement.impl", DummyImpl.class.getName());
        ContainerPlacementPolicyFactory.getPolicy((ConfigurationSource)this.conf, null, null, (boolean)true, null);
    }

    @Test(expected=RuntimeException.class)
    public void testClassNotImplemented() throws SCMException {
        this.conf.set("ozone.scm.container.placement.impl", "org.apache.hadoop.hdds.scm.container.placement.algorithm.HelloWorld");
        ContainerPlacementPolicyFactory.getPolicy((ConfigurationSource)this.conf, null, null, (boolean)true, null);
    }

    public static class DummyImpl
    implements PlacementPolicy {
        public List<DatanodeDetails> chooseDatanodes(List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long sizeRequired) {
            return null;
        }

        public ContainerPlacementStatus validateContainerPlacement(List<DatanodeDetails> dns, int replicas) {
            return new ContainerPlacementStatusDefault(1, 1, 1);
        }
    }
}

