/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerStateManager;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestUnknownContainerReport {
    private NodeManager nodeManager;
    private ContainerManager containerManager;
    private ContainerStateManager containerStateManager;
    private EventPublisher publisher;

    @Before
    public void setup() throws IOException {
        OzoneConfiguration conf = new OzoneConfiguration();
        this.nodeManager = new MockNodeManager(true, 10);
        this.containerManager = (ContainerManager)Mockito.mock(ContainerManager.class);
        this.containerStateManager = new ContainerStateManager((ConfigurationSource)conf);
        this.publisher = (EventPublisher)Mockito.mock(EventPublisher.class);
        Mockito.when((Object)this.containerManager.getContainer((ContainerID)Mockito.any(ContainerID.class))).thenThrow(new Throwable[]{new ContainerNotFoundException()});
    }

    @After
    public void tearDown() throws IOException {
        this.containerStateManager.close();
    }

    @Test
    public void testUnknownContainerNotDeleted() throws IOException {
        OzoneConfiguration conf = new OzoneConfiguration();
        this.sendContainerReport(conf);
        ((EventPublisher)Mockito.verify((Object)this.publisher, (VerificationMode)Mockito.times((int)0))).fireEvent((Event)Mockito.eq((Object)SCMEvents.DATANODE_COMMAND), Mockito.any(CommandForDatanode.class));
    }

    @Test
    public void testUnknownContainerDeleted() throws IOException {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("hdds.scm.unknown-container.action", "DELETE");
        this.sendContainerReport(conf);
        ((EventPublisher)Mockito.verify((Object)this.publisher, (VerificationMode)Mockito.times((int)1))).fireEvent((Event)Mockito.eq((Object)SCMEvents.DATANODE_COMMAND), Mockito.any(CommandForDatanode.class));
    }

    private void sendContainerReport(OzoneConfiguration conf) {
        ContainerReportHandler reportHandler = new ContainerReportHandler(this.nodeManager, this.containerManager, conf);
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        Iterator nodeIterator = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY).iterator();
        DatanodeDetails datanode = (DatanodeDetails)nodeIterator.next();
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = TestUnknownContainerReport.getContainerReportsProto(container.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanode.getUuidString());
        SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode containerReportFromDatanode = new SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode(datanode, containerReport);
        reportHandler.onMessage(containerReportFromDatanode, this.publisher);
    }

    private static StorageContainerDatanodeProtocolProtos.ContainerReportsProto getContainerReportsProto(ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state, String originNodeId) {
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto.Builder crBuilder = StorageContainerDatanodeProtocolProtos.ContainerReportsProto.newBuilder();
        StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto = StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.newBuilder().setContainerID(containerId.getId()).setState(state).setOriginNodeId(originNodeId).setFinalhash("e16cc9d6024365750ed8dbd194ea46d2").setSize(0x140000000L).setUsed(2000000000L).setKeyCount(100000000L).setReadCount(100000000L).setWriteCount(100000000L).setReadBytes(2000000000L).setWriteBytes(2000000000L).setBlockCommitSequenceId(10000L).setDeleteTransactionId(0L).build();
        return crBuilder.addReports(replicaProto).build();
    }
}

