/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.container.ContainerException;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.container.SCMContainerManager;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStoreImpl;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineManager;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.ozone.container.common.SCMTestUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestSCMContainerManager {
    private static SCMContainerManager containerManager;
    private static MockNodeManager nodeManager;
    private static SCMPipelineManager pipelineManager;
    private static File testDir;
    private static XceiverClientManager xceiverClientManager;
    private static Random random;
    private static HddsProtos.ReplicationFactor replicationFactor;
    private static HddsProtos.ReplicationType replicationType;
    private static final long TIMEOUT = 10000L;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void setUp() throws Exception {
        boolean folderExisted;
        OzoneConfiguration conf = SCMTestUtils.getConf();
        testDir = GenericTestUtils.getTestDir((String)TestSCMContainerManager.class.getSimpleName());
        conf.set("ozone.metadata.dirs", testDir.getAbsolutePath());
        boolean bl = folderExisted = testDir.exists() || testDir.mkdirs();
        if (!folderExisted) {
            throw new IOException("Unable to create test directory path");
        }
        nodeManager = new MockNodeManager(true, 10);
        SCMMetadataStoreImpl scmMetadataStore = new SCMMetadataStoreImpl(conf);
        pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)new EventQueue());
        pipelineManager.allowPipelineCreation();
        containerManager = new SCMContainerManager((ConfigurationSource)conf, scmMetadataStore.getContainerTable(), (BatchOperationHandler)scmMetadataStore.getStore(), (PipelineManager)pipelineManager);
        xceiverClientManager = new XceiverClientManager((ConfigurationSource)conf);
        replicationFactor = SCMTestUtils.getReplicationFactor((ConfigurationSource)conf);
        replicationType = SCMTestUtils.getReplicationType((ConfigurationSource)conf);
        random = new Random();
    }

    @AfterClass
    public static void cleanup() throws IOException {
        if (containerManager != null) {
            containerManager.close();
        }
        if (pipelineManager != null) {
            pipelineManager.close();
        }
        FileUtil.fullyDelete((File)testDir);
    }

    @Before
    public void clearSafeMode() {
        nodeManager.setSafemode(false);
    }

    @Test
    public void testallocateContainer() throws Exception {
        ContainerInfo containerInfo = containerManager.allocateContainer(replicationType, replicationFactor, "ozone");
        Assert.assertNotNull((Object)containerInfo);
    }

    @Test
    public void testallocateContainerDistributesAllocation() throws Exception {
        TreeSet<UUID> pipelineList = new TreeSet<UUID>();
        for (int x = 0; x < 30; ++x) {
            ContainerInfo containerInfo = containerManager.allocateContainer(replicationType, replicationFactor, "ozone");
            Assert.assertNotNull((Object)containerInfo);
            Assert.assertNotNull((Object)containerInfo.getPipelineID());
            pipelineList.add(pipelineManager.getPipeline(containerInfo.getPipelineID()).getFirstNode().getUuid());
        }
        Assert.assertTrue((pipelineList.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAllocateContainerInParallel() throws Exception {
        int threadCount = 20;
        ArrayList<ExecutorService> executors = new ArrayList<ExecutorService>(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            executors.add(Executors.newSingleThreadExecutor());
        }
        ArrayList futureList = new ArrayList(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            CompletableFuture future = new CompletableFuture();
            CompletableFuture.supplyAsync(() -> {
                try {
                    ContainerInfo containerInfo = containerManager.allocateContainer(replicationType, replicationFactor, "ozone");
                    Assert.assertNotNull((Object)containerInfo);
                    Assert.assertNotNull((Object)containerInfo.getPipelineID());
                    future.complete(containerInfo);
                    return containerInfo;
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                    return future;
                }
            }, (Executor)executors.get(i));
            futureList.add(future);
        }
        try {
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[futureList.size()])).get();
        }
        catch (Exception e) {
            Assert.fail((String)"testAllocateBlockInParallel failed");
        }
    }

    @Test
    public void testGetContainer() throws IOException {
        ContainerInfo containerInfo = containerManager.allocateContainer(replicationType, replicationFactor, "ozone");
        Assert.assertNotNull((Object)containerInfo);
        Pipeline pipeline = pipelineManager.getPipeline(containerInfo.getPipelineID());
        Assert.assertNotNull((Object)pipeline);
        Assert.assertEquals((Object)containerInfo, (Object)containerManager.getContainer(containerInfo.containerID()));
    }

    @Test
    public void testGetContainerWithPipeline() throws Exception {
        ContainerInfo contInfo = containerManager.allocateContainer(replicationType, replicationFactor, "ozone");
        Iterator nodes = pipelineManager.getPipeline(contInfo.getPipelineID()).getNodes().iterator();
        DatanodeDetails dn1 = (DatanodeDetails)nodes.next();
        containerManager.updateContainerState(contInfo.containerID(), HddsProtos.LifeCycleEvent.FINALIZE);
        containerManager.updateContainerState(contInfo.containerID(), HddsProtos.LifeCycleEvent.CLOSE);
        ContainerInfo finalContInfo = contInfo;
        Assert.assertEquals((long)0L, (long)containerManager.getContainerReplicas(finalContInfo.containerID()).size());
        containerManager.updateContainerReplica(contInfo.containerID(), ContainerReplica.newBuilder().setContainerID(contInfo.containerID()).setContainerState(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED).setDatanodeDetails(dn1).build());
        Assert.assertEquals((long)1L, (long)containerManager.getContainerReplicas(finalContInfo.containerID()).size());
        contInfo = containerManager.getContainer(contInfo.containerID());
        Assert.assertEquals((Object)HddsProtos.LifeCycleState.CLOSED, (Object)contInfo.getState());
        Set replicaNodes = containerManager.getContainerReplicas(contInfo.containerID()).stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toSet());
        Assert.assertTrue((boolean)replicaNodes.contains(dn1));
    }

    @Test
    public void testGetContainerReplicaWithParallelUpdate() throws Exception {
        this.testGetContainerWithPipeline();
        Optional id = containerManager.getContainerIDs().stream().findFirst();
        Assert.assertTrue((boolean)id.isPresent());
        ContainerID cId = (ContainerID)id.get();
        Optional replica = containerManager.getContainerReplicas(cId).stream().findFirst();
        Assert.assertTrue((boolean)replica.isPresent());
        ContainerReplica cReplica = (ContainerReplica)replica.get();
        AtomicBoolean runUpdaterThread = new AtomicBoolean(true);
        Thread updaterThread = new Thread(() -> {
            while (runUpdaterThread.get()) {
                try {
                    containerManager.removeContainerReplica(cId, cReplica);
                    containerManager.updateContainerReplica(cId, cReplica);
                }
                catch (ContainerException e) {
                    Assert.fail((String)("Container Exception: " + e.getMessage()));
                }
            }
        });
        updaterThread.setDaemon(true);
        updaterThread.start();
        IntStream.range(0, 100).forEach(i -> {
            try {
                Assert.assertNotNull(containerManager.getContainerReplicas(cId).stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toSet()));
            }
            catch (ContainerNotFoundException e) {
                Assert.fail((String)("Missing Container " + id));
            }
        });
        runUpdaterThread.set(false);
    }

    @Test
    public void testgetNoneExistentContainer() {
        try {
            containerManager.getContainer(ContainerID.valueof((long)(random.nextInt() & Integer.MAX_VALUE)));
            Assert.fail();
        }
        catch (ContainerNotFoundException containerNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testCloseContainer() throws IOException {
        ContainerID id = this.createContainer().containerID();
        containerManager.updateContainerState(id, HddsProtos.LifeCycleEvent.FINALIZE);
        containerManager.updateContainerState(id, HddsProtos.LifeCycleEvent.CLOSE);
        ContainerInfo closedContainer = containerManager.getContainer(id);
        Assert.assertEquals((Object)HddsProtos.LifeCycleState.CLOSED, (Object)closedContainer.getState());
    }

    private ContainerInfo createContainer() throws IOException {
        nodeManager.setSafemode(false);
        return containerManager.allocateContainer(replicationType, replicationFactor, "ozone");
    }
}

