/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.container.CloseContainerEventHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerStateManager;
import org.apache.hadoop.hdds.scm.container.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementStatusDefault;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.ozone.lock.LockManager;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestReplicationManager {
    private ReplicationManager replicationManager;
    private ContainerStateManager containerStateManager;
    private PlacementPolicy containerPlacementPolicy;
    private EventQueue eventQueue;
    private DatanodeCommandHandler datanodeCommandHandler;
    private SCMNodeManager scmNodeManager;

    @Before
    public void setup() throws IOException, InterruptedException {
        OzoneConfiguration conf = new OzoneConfiguration();
        ContainerManager containerManager = (ContainerManager)Mockito.mock(ContainerManager.class);
        this.eventQueue = new EventQueue();
        this.containerStateManager = new ContainerStateManager((ConfigurationSource)conf);
        this.datanodeCommandHandler = new DatanodeCommandHandler();
        this.eventQueue.addHandler(SCMEvents.DATANODE_COMMAND, (EventHandler)this.datanodeCommandHandler);
        Mockito.when((Object)containerManager.getContainerIDs()).thenAnswer(invocation -> this.containerStateManager.getAllContainerIDs());
        Mockito.when((Object)containerManager.getContainer((ContainerID)Mockito.any(ContainerID.class))).thenAnswer(invocation -> this.containerStateManager.getContainer((ContainerID)invocation.getArguments()[0]));
        Mockito.when((Object)containerManager.getContainerReplicas((ContainerID)Mockito.any(ContainerID.class))).thenAnswer(invocation -> this.containerStateManager.getContainerReplicas((ContainerID)invocation.getArguments()[0]));
        this.containerPlacementPolicy = (PlacementPolicy)Mockito.mock(PlacementPolicy.class);
        Mockito.when((Object)this.containerPlacementPolicy.chooseDatanodes(Mockito.anyListOf(DatanodeDetails.class), Mockito.anyListOf(DatanodeDetails.class), Mockito.anyInt(), Mockito.anyLong())).thenAnswer(invocation -> {
            int count = (Integer)invocation.getArguments()[2];
            return IntStream.range(0, count).mapToObj(i -> MockDatanodeDetails.randomDatanodeDetails()).collect(Collectors.toList());
        });
        Mockito.when((Object)this.containerPlacementPolicy.validateContainerPlacement(Mockito.anyListOf(DatanodeDetails.class), Mockito.anyInt())).thenAnswer(invocation -> new ContainerPlacementStatusDefault(2, 2, 3));
        this.scmNodeManager = (SCMNodeManager)Mockito.mock(SCMNodeManager.class);
        Mockito.when((Object)this.scmNodeManager.getNodeState((DatanodeDetails)Mockito.any(DatanodeDetails.class))).thenReturn((Object)HddsProtos.NodeState.HEALTHY);
        this.replicationManager = new ReplicationManager(new ReplicationManager.ReplicationManagerConfiguration(), containerManager, this.containerPlacementPolicy, (EventPublisher)this.eventQueue, new LockManager((ConfigurationSource)conf), (NodeManager)this.scmNodeManager);
        this.replicationManager.start();
        Thread.sleep(100L);
    }

    @Test
    public void testReplicationManagerRestart() throws InterruptedException {
        Assert.assertTrue((boolean)this.replicationManager.isRunning());
        this.replicationManager.stop();
        Thread.sleep(500L);
        Assert.assertFalse((boolean)this.replicationManager.isRunning());
        this.replicationManager.start();
        Assert.assertTrue((boolean)this.replicationManager.isRunning());
    }

    @Test
    public void testOpenContainer() throws SCMException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.OPEN);
        this.containerStateManager.loadContainer(container);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.datanodeCommandHandler.getInvocation());
    }

    @Test
    public void testClosingContainer() throws SCMException, ContainerNotFoundException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSING);
        ContainerID id = container.containerID();
        this.containerStateManager.loadContainer(container);
        Set<ContainerReplica> replicas = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING, MockDatanodeDetails.randomDatanodeDetails(), MockDatanodeDetails.randomDatanodeDetails());
        DatanodeDetails datanode = MockDatanodeDetails.randomDatanodeDetails();
        replicas.addAll(TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN, datanode));
        for (ContainerReplica replica : replicas) {
            this.containerStateManager.updateContainerReplica(id, replica);
        }
        int currentCloseCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentCloseCommandCount + 3), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand));
        for (ContainerReplica replica : TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING, datanode)) {
            this.containerStateManager.updateContainerReplica(id, replica);
        }
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentCloseCommandCount + 6), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand));
    }

    @Test
    public void testQuasiClosedContainerWithTwoOpenReplica() throws SCMException, ContainerNotFoundException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.QUASI_CLOSED);
        ContainerID id = container.containerID();
        UUID originNodeId = UUID.randomUUID();
        ContainerReplica replicaOne = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaTwo = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        DatanodeDetails datanodeDetails = MockDatanodeDetails.randomDatanodeDetails();
        ContainerReplica replicaThree = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN, 1000L, datanodeDetails.getUuid(), datanodeDetails);
        this.containerStateManager.loadContainer(container);
        this.containerStateManager.updateContainerReplica(id, replicaOne);
        this.containerStateManager.updateContainerReplica(id, replicaTwo);
        this.containerStateManager.updateContainerReplica(id, replicaThree);
        int currentCloseCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentCloseCommandCount + 2), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand));
        Assert.assertTrue((boolean)this.datanodeCommandHandler.received(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand, replicaTwo.getDatanodeDetails()));
        Assert.assertTrue((boolean)this.datanodeCommandHandler.received(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand, replicaThree.getDatanodeDetails()));
    }

    @Test
    public void testHealthyQuasiClosedContainer() throws SCMException, ContainerNotFoundException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.QUASI_CLOSED);
        ContainerID id = container.containerID();
        UUID originNodeId = UUID.randomUUID();
        ContainerReplica replicaOne = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaTwo = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaThree = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        this.containerStateManager.loadContainer(container);
        this.containerStateManager.updateContainerReplica(id, replicaOne);
        this.containerStateManager.updateContainerReplica(id, replicaTwo);
        this.containerStateManager.updateContainerReplica(id, replicaThree);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.datanodeCommandHandler.getInvocation());
    }

    @Test
    public void testQuasiClosedContainerWithUnhealthyReplica() throws SCMException, ContainerNotFoundException, InterruptedException, ContainerReplicaNotFoundException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.QUASI_CLOSED);
        ContainerID id = container.containerID();
        UUID originNodeId = UUID.randomUUID();
        ContainerReplica replicaOne = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaTwo = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaThree = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        this.containerStateManager.loadContainer(container);
        this.containerStateManager.updateContainerReplica(id, replicaOne);
        this.containerStateManager.updateContainerReplica(id, replicaTwo);
        this.containerStateManager.updateContainerReplica(id, replicaThree);
        int currentDeleteCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand);
        int currentReplicateCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.datanodeCommandHandler.getInvocation());
        ContainerReplica unhealthyReplica = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY, 1000L, originNodeId, replicaOne.getDatanodeDetails());
        this.containerStateManager.updateContainerReplica(id, unhealthyReplica);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentDeleteCommandCount + 1), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand));
        Assert.assertTrue((boolean)this.datanodeCommandHandler.received(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand, replicaOne.getDatanodeDetails()));
        this.containerStateManager.removeContainerReplica(id, replicaOne);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentReplicateCommandCount + 1), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand));
    }

    @Test
    public void testOverReplicatedQuasiClosedContainer() throws SCMException, ContainerNotFoundException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.QUASI_CLOSED);
        ContainerID id = container.containerID();
        UUID originNodeId = UUID.randomUUID();
        ContainerReplica replicaOne = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaTwo = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaThree = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaFour = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        this.containerStateManager.loadContainer(container);
        this.containerStateManager.updateContainerReplica(id, replicaOne);
        this.containerStateManager.updateContainerReplica(id, replicaTwo);
        this.containerStateManager.updateContainerReplica(id, replicaThree);
        this.containerStateManager.updateContainerReplica(id, replicaFour);
        int currentDeleteCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentDeleteCommandCount + 1), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand));
    }

    @Test
    public void testOverReplicatedQuasiClosedContainerWithUnhealthyReplica() throws SCMException, ContainerNotFoundException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.QUASI_CLOSED);
        ContainerID id = container.containerID();
        UUID originNodeId = UUID.randomUUID();
        ContainerReplica replicaOne = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaTwo = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaThree = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaFour = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        this.containerStateManager.loadContainer(container);
        this.containerStateManager.updateContainerReplica(id, replicaOne);
        this.containerStateManager.updateContainerReplica(id, replicaTwo);
        this.containerStateManager.updateContainerReplica(id, replicaThree);
        this.containerStateManager.updateContainerReplica(id, replicaFour);
        int currentDeleteCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentDeleteCommandCount + 1), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand));
        Assert.assertTrue((boolean)this.datanodeCommandHandler.received(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand, replicaOne.getDatanodeDetails()));
    }

    @Test
    public void testUnderReplicatedQuasiClosedContainer() throws SCMException, ContainerNotFoundException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.QUASI_CLOSED);
        ContainerID id = container.containerID();
        UUID originNodeId = UUID.randomUUID();
        ContainerReplica replicaOne = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaTwo = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        this.containerStateManager.loadContainer(container);
        this.containerStateManager.updateContainerReplica(id, replicaOne);
        this.containerStateManager.updateContainerReplica(id, replicaTwo);
        int currentReplicateCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentReplicateCommandCount + 1), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand));
    }

    @Test
    public void testUnderReplicatedQuasiClosedContainerWithUnhealthyReplica() throws SCMException, ContainerNotFoundException, InterruptedException, ContainerReplicaNotFoundException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.QUASI_CLOSED);
        ContainerID id = container.containerID();
        UUID originNodeId = UUID.randomUUID();
        ContainerReplica replicaOne = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaTwo = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        this.containerStateManager.loadContainer(container);
        this.containerStateManager.updateContainerReplica(id, replicaOne);
        this.containerStateManager.updateContainerReplica(id, replicaTwo);
        int currentReplicateCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand);
        int currentDeleteCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentReplicateCommandCount + 1), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand));
        Optional<CommandForDatanode> replicateCommand = this.datanodeCommandHandler.getReceivedCommands().stream().filter(c -> c.getCommand().getType().equals((Object)StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand)).findFirst();
        Assert.assertTrue((boolean)replicateCommand.isPresent());
        DatanodeDetails newNode = MockDatanodeDetails.createDatanodeDetails((UUID)replicateCommand.get().getDatanodeId());
        ContainerReplica newReplica = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 1000L, originNodeId, newNode);
        this.containerStateManager.updateContainerReplica(id, newReplica);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentDeleteCommandCount + 1), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand));
        Assert.assertTrue((boolean)this.datanodeCommandHandler.received(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand, replicaTwo.getDatanodeDetails()));
        this.containerStateManager.removeContainerReplica(id, replicaTwo);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentReplicateCommandCount + 2), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand));
    }

    @Test
    public void testQuasiClosedToClosed() throws SCMException, ContainerNotFoundException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.QUASI_CLOSED);
        ContainerID id = container.containerID();
        Set<ContainerReplica> replicas = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, MockDatanodeDetails.randomDatanodeDetails(), MockDatanodeDetails.randomDatanodeDetails(), MockDatanodeDetails.randomDatanodeDetails());
        this.containerStateManager.loadContainer(container);
        for (ContainerReplica replica : replicas) {
            this.containerStateManager.updateContainerReplica(id, replica);
        }
        int currentCloseCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentCloseCommandCount + 3), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand));
    }

    @Test
    public void testHealthyClosedContainer() throws SCMException, ContainerNotFoundException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        ContainerID id = container.containerID();
        Set<ContainerReplica> replicas = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, MockDatanodeDetails.randomDatanodeDetails(), MockDatanodeDetails.randomDatanodeDetails(), MockDatanodeDetails.randomDatanodeDetails());
        this.containerStateManager.loadContainer(container);
        for (ContainerReplica replica : replicas) {
            this.containerStateManager.updateContainerReplica(id, replica);
        }
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.datanodeCommandHandler.getInvocation());
    }

    @Test
    public void testUnhealthyOpenContainer() throws SCMException, ContainerNotFoundException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.OPEN);
        ContainerID id = container.containerID();
        Set<ContainerReplica> replicas = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN, MockDatanodeDetails.randomDatanodeDetails(), MockDatanodeDetails.randomDatanodeDetails());
        replicas.addAll(TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY, MockDatanodeDetails.randomDatanodeDetails()));
        this.containerStateManager.loadContainer(container);
        for (ContainerReplica replica : replicas) {
            this.containerStateManager.updateContainerReplica(id, replica);
        }
        CloseContainerEventHandler closeContainerHandler = (CloseContainerEventHandler)Mockito.mock(CloseContainerEventHandler.class);
        this.eventQueue.addHandler((Event)SCMEvents.CLOSE_CONTAINER, (EventHandler)closeContainerHandler);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        ((CloseContainerEventHandler)Mockito.verify((Object)closeContainerHandler, (VerificationMode)Mockito.times((int)1))).onMessage(id, (EventPublisher)this.eventQueue);
    }

    @Test
    public void testGeneratedConfig() {
        ReplicationManager.ReplicationManagerConfiguration rmc = (ReplicationManager.ReplicationManagerConfiguration)OzoneConfiguration.newInstanceOf(ReplicationManager.ReplicationManagerConfiguration.class);
        Assert.assertEquals((long)1800000L, (long)rmc.getEventTimeout());
    }

    @Test
    public void additionalReplicaScheduledWhenMisReplicated() throws SCMException, ContainerNotFoundException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        ContainerID id = container.containerID();
        UUID originNodeId = UUID.randomUUID();
        ContainerReplica replicaOne = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaTwo = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaThree = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        this.containerStateManager.loadContainer(container);
        this.containerStateManager.updateContainerReplica(id, replicaOne);
        this.containerStateManager.updateContainerReplica(id, replicaTwo);
        this.containerStateManager.updateContainerReplica(id, replicaThree);
        Mockito.when((Object)this.containerPlacementPolicy.validateContainerPlacement((List)Mockito.argThat((Matcher)new ListOfNElements(3)), Mockito.anyInt())).thenAnswer(invocation -> new ContainerPlacementStatusDefault(1, 2, 3));
        int currentReplicateCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentReplicateCommandCount + 1), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand));
        Mockito.when((Object)this.containerPlacementPolicy.validateContainerPlacement(Mockito.anyList(), Mockito.anyInt())).thenAnswer(invocation -> new ContainerPlacementStatusDefault(1, 2, 3));
        currentReplicateCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)currentReplicateCommandCount, (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand));
    }

    @Test
    public void overReplicatedButRemovingMakesMisReplicated() throws SCMException, ContainerNotFoundException, InterruptedException {
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        ContainerID id = container.containerID();
        UUID originNodeId = UUID.randomUUID();
        ContainerReplica replicaOne = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaTwo = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaThree = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaFour = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        ContainerReplica replicaFive = TestUtils.getReplicas(id, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY, 1000L, originNodeId, MockDatanodeDetails.randomDatanodeDetails());
        this.containerStateManager.loadContainer(container);
        this.containerStateManager.updateContainerReplica(id, replicaOne);
        this.containerStateManager.updateContainerReplica(id, replicaTwo);
        this.containerStateManager.updateContainerReplica(id, replicaThree);
        this.containerStateManager.updateContainerReplica(id, replicaFour);
        this.containerStateManager.updateContainerReplica(id, replicaFive);
        Mockito.when((Object)this.containerPlacementPolicy.validateContainerPlacement((List)Mockito.argThat((Matcher)new ListOfNElements(3)), Mockito.anyInt())).thenAnswer(invocation -> new ContainerPlacementStatusDefault(1, 2, 3));
        int currentDeleteCommandCount = this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand);
        this.replicationManager.processContainersNow();
        Thread.sleep(100L);
        Assert.assertEquals((long)(currentDeleteCommandCount + 1), (long)this.datanodeCommandHandler.getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand));
        Assert.assertTrue((boolean)this.datanodeCommandHandler.received(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand, replicaFive.getDatanodeDetails()));
    }

    @After
    public void teardown() throws IOException {
        this.containerStateManager.close();
        this.replicationManager.stop();
    }

    class ListOfNElements
    extends ArgumentMatcher<List> {
        private int expected;

        ListOfNElements(int expected) {
            this.expected = expected;
        }

        public boolean matches(Object argument) {
            return ((List)argument).size() == this.expected;
        }
    }

    private class DatanodeCommandHandler
    implements EventHandler<CommandForDatanode> {
        private AtomicInteger invocation = new AtomicInteger(0);
        private Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, AtomicInteger> commandInvocation = new HashMap<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, AtomicInteger>();
        private List<CommandForDatanode> commands = new ArrayList<CommandForDatanode>();

        private DatanodeCommandHandler() {
        }

        public void onMessage(CommandForDatanode command, EventPublisher publisher) {
            StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type type = command.getCommand().getType();
            this.commandInvocation.computeIfAbsent(type, k -> new AtomicInteger(0));
            this.commandInvocation.get(type).incrementAndGet();
            this.invocation.incrementAndGet();
            this.commands.add(command);
        }

        private int getInvocation() {
            return this.invocation.get();
        }

        private int getInvocationCount(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type type) {
            return this.commandInvocation.containsKey(type) ? this.commandInvocation.get(type).get() : 0;
        }

        private List<CommandForDatanode> getReceivedCommands() {
            return this.commands;
        }

        private boolean received(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type type, DatanodeDetails datanode) {
            return this.commands.stream().anyMatch(dc -> dc.getCommand().getType().equals((Object)type) && dc.getDatanodeId().equals(datanode.getUuid()));
        }
    }
}

