/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerStateManager;
import org.apache.hadoop.hdds.scm.container.IncrementalContainerReportHandler;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestIncrementalContainerReportHandler {
    private NodeManager nodeManager;
    private ContainerManager containerManager;
    private ContainerStateManager containerStateManager;
    private EventPublisher publisher;

    @Before
    public void setup() throws IOException {
        OzoneConfiguration conf = new OzoneConfiguration();
        String path = GenericTestUtils.getTempPath((String)UUID.randomUUID().toString());
        Path scmPath = Paths.get(path, "scm-meta");
        conf.set("ozone.metadata.dirs", scmPath.toString());
        this.containerManager = (ContainerManager)Mockito.mock(ContainerManager.class);
        NetworkTopologyImpl clusterMap = new NetworkTopologyImpl((ConfigurationSource)conf);
        EventQueue eventQueue = new EventQueue();
        SCMStorageConfig storageConfig = new SCMStorageConfig(conf);
        this.nodeManager = new SCMNodeManager(conf, storageConfig, (EventPublisher)eventQueue, (NetworkTopology)clusterMap);
        this.containerStateManager = new ContainerStateManager((ConfigurationSource)conf);
        this.publisher = (EventPublisher)Mockito.mock(EventPublisher.class);
        Mockito.when((Object)this.containerManager.getContainer((ContainerID)Mockito.any(ContainerID.class))).thenAnswer(invocation -> this.containerStateManager.getContainer((ContainerID)invocation.getArguments()[0]));
        Mockito.when((Object)this.containerManager.getContainerReplicas((ContainerID)Mockito.any(ContainerID.class))).thenAnswer(invocation -> this.containerStateManager.getContainerReplicas((ContainerID)invocation.getArguments()[0]));
        ((ContainerManager)Mockito.doAnswer(invocation -> {
            this.containerStateManager.removeContainerReplica((ContainerID)invocation.getArguments()[0], (ContainerReplica)invocation.getArguments()[1]);
            return null;
        }).when((Object)this.containerManager)).removeContainerReplica((ContainerID)Mockito.any(ContainerID.class), (ContainerReplica)Mockito.any(ContainerReplica.class));
        ((ContainerManager)Mockito.doAnswer(invocation -> {
            this.containerStateManager.updateContainerState((ContainerID)invocation.getArguments()[0], (HddsProtos.LifeCycleEvent)invocation.getArguments()[1]);
            return null;
        }).when((Object)this.containerManager)).updateContainerState((ContainerID)Mockito.any(ContainerID.class), (HddsProtos.LifeCycleEvent)Mockito.any(HddsProtos.LifeCycleEvent.class));
    }

    @After
    public void tearDown() throws IOException {
        this.containerStateManager.close();
    }

    @Test
    public void testClosingToClosed() throws IOException {
        IncrementalContainerReportHandler reportHandler = new IncrementalContainerReportHandler(this.nodeManager, this.containerManager);
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSING);
        DatanodeDetails datanodeOne = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails datanodeTwo = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails datanodeThree = MockDatanodeDetails.randomDatanodeDetails();
        this.nodeManager.register(datanodeOne, null, null);
        this.nodeManager.register(datanodeTwo, null, null);
        this.nodeManager.register(datanodeThree, null, null);
        Set<ContainerReplica> containerReplicas = TestUtils.getReplicas(container.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING, datanodeOne, datanodeTwo, datanodeThree);
        this.containerStateManager.loadContainer(container);
        containerReplicas.forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(container.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto containerReport = TestIncrementalContainerReportHandler.getIncrementalContainerReportProto(container.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne.getUuidString());
        SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode icrFromDatanode = new SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode(datanodeOne, containerReport);
        reportHandler.onMessage(icrFromDatanode, this.publisher);
        Assert.assertEquals((Object)HddsProtos.LifeCycleState.CLOSED, (Object)container.getState());
    }

    @Test
    public void testClosingToQuasiClosed() throws IOException {
        IncrementalContainerReportHandler reportHandler = new IncrementalContainerReportHandler(this.nodeManager, this.containerManager);
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSING);
        DatanodeDetails datanodeOne = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails datanodeTwo = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails datanodeThree = MockDatanodeDetails.randomDatanodeDetails();
        this.nodeManager.register(datanodeOne, null, null);
        this.nodeManager.register(datanodeTwo, null, null);
        this.nodeManager.register(datanodeThree, null, null);
        Set<ContainerReplica> containerReplicas = TestUtils.getReplicas(container.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING, datanodeOne, datanodeTwo, datanodeThree);
        this.containerStateManager.loadContainer(container);
        containerReplicas.forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(container.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto containerReport = TestIncrementalContainerReportHandler.getIncrementalContainerReportProto(container.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, datanodeOne.getUuidString());
        SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode icrFromDatanode = new SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode(datanodeOne, containerReport);
        reportHandler.onMessage(icrFromDatanode, this.publisher);
        Assert.assertEquals((Object)HddsProtos.LifeCycleState.QUASI_CLOSED, (Object)container.getState());
    }

    @Test
    public void testQuasiClosedToClosed() throws IOException {
        IncrementalContainerReportHandler reportHandler = new IncrementalContainerReportHandler(this.nodeManager, this.containerManager);
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.QUASI_CLOSED);
        DatanodeDetails datanodeOne = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails datanodeTwo = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails datanodeThree = MockDatanodeDetails.randomDatanodeDetails();
        this.nodeManager.register(datanodeOne, null, null);
        this.nodeManager.register(datanodeTwo, null, null);
        this.nodeManager.register(datanodeThree, null, null);
        Set<ContainerReplica> containerReplicas = TestUtils.getReplicas(container.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING, datanodeOne, datanodeTwo);
        containerReplicas.addAll(TestUtils.getReplicas(container.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, datanodeThree));
        this.containerStateManager.loadContainer(container);
        containerReplicas.forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(container.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto containerReport = TestIncrementalContainerReportHandler.getIncrementalContainerReportProto(container.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeThree.getUuidString());
        SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode icr = new SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode(datanodeOne, containerReport);
        reportHandler.onMessage(icr, this.publisher);
        Assert.assertEquals((Object)HddsProtos.LifeCycleState.CLOSED, (Object)container.getState());
    }

    @Test
    public void testDeleteContainer() throws IOException {
        IncrementalContainerReportHandler reportHandler = new IncrementalContainerReportHandler(this.nodeManager, this.containerManager);
        ContainerInfo container = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        DatanodeDetails datanodeOne = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails datanodeTwo = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails datanodeThree = MockDatanodeDetails.randomDatanodeDetails();
        this.nodeManager.register(datanodeOne, null, null);
        this.nodeManager.register(datanodeTwo, null, null);
        this.nodeManager.register(datanodeThree, null, null);
        Set<ContainerReplica> containerReplicas = TestUtils.getReplicas(container.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne, datanodeTwo, datanodeThree);
        this.containerStateManager.loadContainer(container);
        containerReplicas.forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(container.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        Assert.assertEquals((long)3L, (long)this.containerStateManager.getContainerReplicas(container.containerID()).size());
        StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto containerReport = TestIncrementalContainerReportHandler.getIncrementalContainerReportProto(container.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED, datanodeThree.getUuidString());
        SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode icr = new SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode(datanodeOne, containerReport);
        reportHandler.onMessage(icr, this.publisher);
        Assert.assertEquals((long)2L, (long)this.containerStateManager.getContainerReplicas(container.containerID()).size());
    }

    private static StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto getIncrementalContainerReportProto(ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state, String originNodeId) {
        StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto.Builder crBuilder = StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto.newBuilder();
        StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto = StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.newBuilder().setContainerID(containerId.getId()).setState(state).setOriginNodeId(originNodeId).setFinalhash("e16cc9d6024365750ed8dbd194ea46d2").setSize(0x140000000L).setUsed(2000000000L).setKeyCount(100000000L).setReadCount(100000000L).setWriteCount(100000000L).setReadBytes(2000000000L).setWriteBytes(2000000000L).setBlockCommitSequenceId(10000L).setDeleteTransactionId(0L).build();
        return crBuilder.addReport(replicaProto).build();
    }
}

