/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerStateManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestContainerStateManager {
    private ContainerStateManager containerStateManager;

    @Before
    public void init() throws IOException {
        OzoneConfiguration conf = new OzoneConfiguration();
        this.containerStateManager = new ContainerStateManager((ConfigurationSource)conf);
    }

    @Test
    public void checkReplicationStateOK() throws IOException {
        ContainerInfo c1 = this.allocateContainer();
        DatanodeDetails d1 = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails d2 = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails d3 = MockDatanodeDetails.randomDatanodeDetails();
        this.addReplica(c1, d1);
        this.addReplica(c1, d2);
        this.addReplica(c1, d3);
        Set replicas = this.containerStateManager.getContainerReplicas(c1.containerID());
        Assert.assertEquals((long)3L, (long)replicas.size());
    }

    @Test
    public void checkReplicationStateMissingReplica() throws IOException {
        ContainerInfo c1 = this.allocateContainer();
        DatanodeDetails d1 = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails d2 = MockDatanodeDetails.randomDatanodeDetails();
        this.addReplica(c1, d1);
        this.addReplica(c1, d2);
        Set replicas = this.containerStateManager.getContainerReplicas(c1.containerID());
        Assert.assertEquals((long)2L, (long)replicas.size());
        Assert.assertEquals((long)3L, (long)c1.getReplicationFactor().getNumber());
    }

    private void addReplica(ContainerInfo cont, DatanodeDetails node) throws ContainerNotFoundException {
        ContainerReplica replica = ContainerReplica.newBuilder().setContainerID(cont.containerID()).setContainerState(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED).setDatanodeDetails(node).build();
        this.containerStateManager.updateContainerReplica(cont.containerID(), replica);
    }

    private ContainerInfo allocateContainer() throws IOException {
        PipelineManager pipelineManager = (PipelineManager)Mockito.mock(SCMPipelineManager.class);
        Pipeline pipeline = Pipeline.newBuilder().setState(Pipeline.PipelineState.CLOSED).setId(PipelineID.randomId()).setType(HddsProtos.ReplicationType.STAND_ALONE).setFactor(HddsProtos.ReplicationFactor.THREE).setNodes(new ArrayList()).build();
        Mockito.when((Object)pipelineManager.createPipeline(HddsProtos.ReplicationType.STAND_ALONE, HddsProtos.ReplicationFactor.THREE)).thenReturn((Object)pipeline);
        return this.containerStateManager.allocateContainer(pipelineManager, HddsProtos.ReplicationType.STAND_ALONE, HddsProtos.ReplicationFactor.THREE, "root");
    }
}

