/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerStateManager;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestContainerReportHandler {
    private NodeManager nodeManager;
    private ContainerManager containerManager;
    private ContainerStateManager containerStateManager;
    private EventPublisher publisher;

    @Before
    public void setup() throws IOException {
        OzoneConfiguration conf = new OzoneConfiguration();
        this.nodeManager = new MockNodeManager(true, 10);
        this.containerManager = (ContainerManager)Mockito.mock(ContainerManager.class);
        this.containerStateManager = new ContainerStateManager((ConfigurationSource)conf);
        this.publisher = (EventPublisher)Mockito.mock(EventPublisher.class);
        Mockito.when((Object)this.containerManager.getContainer((ContainerID)Mockito.any(ContainerID.class))).thenAnswer(invocation -> this.containerStateManager.getContainer((ContainerID)invocation.getArguments()[0]));
        Mockito.when((Object)this.containerManager.getContainerReplicas((ContainerID)Mockito.any(ContainerID.class))).thenAnswer(invocation -> this.containerStateManager.getContainerReplicas((ContainerID)invocation.getArguments()[0]));
        ((ContainerManager)Mockito.doAnswer(invocation -> {
            this.containerStateManager.updateContainerState((ContainerID)invocation.getArguments()[0], (HddsProtos.LifeCycleEvent)invocation.getArguments()[1]);
            return null;
        }).when((Object)this.containerManager)).updateContainerState((ContainerID)Mockito.any(ContainerID.class), (HddsProtos.LifeCycleEvent)Mockito.any(HddsProtos.LifeCycleEvent.class));
        ((ContainerManager)Mockito.doAnswer(invocation -> {
            this.containerStateManager.updateContainerReplica((ContainerID)invocation.getArguments()[0], (ContainerReplica)invocation.getArguments()[1]);
            return null;
        }).when((Object)this.containerManager)).updateContainerReplica((ContainerID)Mockito.any(ContainerID.class), (ContainerReplica)Mockito.any(ContainerReplica.class));
        ((ContainerManager)Mockito.doAnswer(invocation -> {
            this.containerStateManager.removeContainerReplica((ContainerID)invocation.getArguments()[0], (ContainerReplica)invocation.getArguments()[1]);
            return null;
        }).when((Object)this.containerManager)).removeContainerReplica((ContainerID)Mockito.any(ContainerID.class), (ContainerReplica)Mockito.any(ContainerReplica.class));
    }

    @After
    public void tearDown() throws IOException {
        this.containerStateManager.close();
    }

    @Test
    public void testUnderReplicatedContainer() throws NodeNotFoundException, ContainerNotFoundException, SCMException {
        ContainerReportHandler reportHandler = new ContainerReportHandler(this.nodeManager, this.containerManager);
        Iterator nodeIterator = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY).iterator();
        DatanodeDetails datanodeOne = (DatanodeDetails)nodeIterator.next();
        DatanodeDetails datanodeTwo = (DatanodeDetails)nodeIterator.next();
        DatanodeDetails datanodeThree = (DatanodeDetails)nodeIterator.next();
        ContainerInfo containerOne = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        ContainerInfo containerTwo = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        Set containerIDSet = Stream.of(containerOne.containerID(), containerTwo.containerID()).collect(Collectors.toSet());
        this.nodeManager.setContainers(datanodeOne, containerIDSet);
        this.nodeManager.setContainers(datanodeTwo, containerIDSet);
        this.nodeManager.setContainers(datanodeThree, containerIDSet);
        this.containerStateManager.loadContainer(containerOne);
        this.containerStateManager.loadContainer(containerTwo);
        TestUtils.getReplicas(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne, datanodeTwo, datanodeThree).forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(containerOne.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        TestUtils.getReplicas(containerTwo.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne, datanodeTwo, datanodeThree).forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(containerTwo.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = TestContainerReportHandler.getContainerReportsProto(containerTwo.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne.getUuidString());
        SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode containerReportFromDatanode = new SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode(datanodeOne, containerReport);
        reportHandler.onMessage(containerReportFromDatanode, this.publisher);
        Assert.assertEquals((long)2L, (long)this.containerManager.getContainerReplicas(containerOne.containerID()).size());
    }

    @Test
    public void testOverReplicatedContainer() throws NodeNotFoundException, SCMException, ContainerNotFoundException {
        ContainerReportHandler reportHandler = new ContainerReportHandler(this.nodeManager, this.containerManager);
        Iterator nodeIterator = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY).iterator();
        DatanodeDetails datanodeOne = (DatanodeDetails)nodeIterator.next();
        DatanodeDetails datanodeTwo = (DatanodeDetails)nodeIterator.next();
        DatanodeDetails datanodeThree = (DatanodeDetails)nodeIterator.next();
        DatanodeDetails datanodeFour = (DatanodeDetails)nodeIterator.next();
        ContainerInfo containerOne = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        ContainerInfo containerTwo = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        Set containerIDSet = Stream.of(containerOne.containerID(), containerTwo.containerID()).collect(Collectors.toSet());
        this.nodeManager.setContainers(datanodeOne, containerIDSet);
        this.nodeManager.setContainers(datanodeTwo, containerIDSet);
        this.nodeManager.setContainers(datanodeThree, containerIDSet);
        this.containerStateManager.loadContainer(containerOne);
        this.containerStateManager.loadContainer(containerTwo);
        TestUtils.getReplicas(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne, datanodeTwo, datanodeThree).forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(containerOne.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        TestUtils.getReplicas(containerTwo.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne, datanodeTwo, datanodeThree).forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(containerTwo.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = TestContainerReportHandler.getContainerReportsProto(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeFour.getUuidString());
        SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode containerReportFromDatanode = new SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode(datanodeFour, containerReport);
        reportHandler.onMessage(containerReportFromDatanode, this.publisher);
        Assert.assertEquals((long)4L, (long)this.containerManager.getContainerReplicas(containerOne.containerID()).size());
    }

    @Test
    public void testClosingToClosed() throws NodeNotFoundException, IOException {
        ContainerReportHandler reportHandler = new ContainerReportHandler(this.nodeManager, this.containerManager);
        Iterator nodeIterator = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY).iterator();
        DatanodeDetails datanodeOne = (DatanodeDetails)nodeIterator.next();
        DatanodeDetails datanodeTwo = (DatanodeDetails)nodeIterator.next();
        DatanodeDetails datanodeThree = (DatanodeDetails)nodeIterator.next();
        ContainerInfo containerOne = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSING);
        ContainerInfo containerTwo = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        Set containerIDSet = Stream.of(containerOne.containerID(), containerTwo.containerID()).collect(Collectors.toSet());
        Set<ContainerReplica> containerOneReplicas = TestUtils.getReplicas(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING, datanodeOne);
        containerOneReplicas.addAll(TestUtils.getReplicas(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN, datanodeTwo, datanodeThree));
        Set<ContainerReplica> containerTwoReplicas = TestUtils.getReplicas(containerTwo.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne, datanodeTwo, datanodeThree);
        this.nodeManager.setContainers(datanodeOne, containerIDSet);
        this.nodeManager.setContainers(datanodeTwo, containerIDSet);
        this.nodeManager.setContainers(datanodeThree, containerIDSet);
        this.containerStateManager.loadContainer(containerOne);
        this.containerStateManager.loadContainer(containerTwo);
        containerOneReplicas.forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(containerTwo.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        containerTwoReplicas.forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(containerTwo.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = TestContainerReportHandler.getContainerReportsProto(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne.getUuidString());
        SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode containerReportFromDatanode = new SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode(datanodeOne, containerReport);
        reportHandler.onMessage(containerReportFromDatanode, this.publisher);
        Assert.assertEquals((Object)HddsProtos.LifeCycleState.CLOSED, (Object)containerOne.getState());
    }

    @Test
    public void testClosingToQuasiClosed() throws NodeNotFoundException, IOException {
        ContainerReportHandler reportHandler = new ContainerReportHandler(this.nodeManager, this.containerManager);
        Iterator nodeIterator = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY).iterator();
        DatanodeDetails datanodeOne = (DatanodeDetails)nodeIterator.next();
        DatanodeDetails datanodeTwo = (DatanodeDetails)nodeIterator.next();
        DatanodeDetails datanodeThree = (DatanodeDetails)nodeIterator.next();
        ContainerInfo containerOne = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSING);
        ContainerInfo containerTwo = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        Set containerIDSet = Stream.of(containerOne.containerID(), containerTwo.containerID()).collect(Collectors.toSet());
        Set<ContainerReplica> containerOneReplicas = TestUtils.getReplicas(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING, datanodeOne, datanodeTwo);
        containerOneReplicas.addAll(TestUtils.getReplicas(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN, datanodeThree));
        Set<ContainerReplica> containerTwoReplicas = TestUtils.getReplicas(containerTwo.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne, datanodeTwo, datanodeThree);
        this.nodeManager.setContainers(datanodeOne, containerIDSet);
        this.nodeManager.setContainers(datanodeTwo, containerIDSet);
        this.nodeManager.setContainers(datanodeThree, containerIDSet);
        this.containerStateManager.loadContainer(containerOne);
        this.containerStateManager.loadContainer(containerTwo);
        containerOneReplicas.forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(containerTwo.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        containerTwoReplicas.forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(containerTwo.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = TestContainerReportHandler.getContainerReportsProto(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, datanodeOne.getUuidString());
        SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode containerReportFromDatanode = new SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode(datanodeOne, containerReport);
        reportHandler.onMessage(containerReportFromDatanode, this.publisher);
        Assert.assertEquals((Object)HddsProtos.LifeCycleState.QUASI_CLOSED, (Object)containerOne.getState());
    }

    @Test
    public void testQuasiClosedToClosed() throws NodeNotFoundException, IOException {
        ContainerReportHandler reportHandler = new ContainerReportHandler(this.nodeManager, this.containerManager);
        Iterator nodeIterator = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY).iterator();
        DatanodeDetails datanodeOne = (DatanodeDetails)nodeIterator.next();
        DatanodeDetails datanodeTwo = (DatanodeDetails)nodeIterator.next();
        DatanodeDetails datanodeThree = (DatanodeDetails)nodeIterator.next();
        ContainerInfo containerOne = TestUtils.getContainer(HddsProtos.LifeCycleState.QUASI_CLOSED);
        ContainerInfo containerTwo = TestUtils.getContainer(HddsProtos.LifeCycleState.CLOSED);
        Set containerIDSet = Stream.of(containerOne.containerID(), containerTwo.containerID()).collect(Collectors.toSet());
        Set<ContainerReplica> containerOneReplicas = TestUtils.getReplicas(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED, 10000L, datanodeOne);
        containerOneReplicas.addAll(TestUtils.getReplicas(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING, datanodeTwo, datanodeThree));
        Set<ContainerReplica> containerTwoReplicas = TestUtils.getReplicas(containerTwo.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne, datanodeTwo, datanodeThree);
        this.nodeManager.setContainers(datanodeOne, containerIDSet);
        this.nodeManager.setContainers(datanodeTwo, containerIDSet);
        this.nodeManager.setContainers(datanodeThree, containerIDSet);
        this.containerStateManager.loadContainer(containerOne);
        this.containerStateManager.loadContainer(containerTwo);
        containerOneReplicas.forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(containerTwo.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        containerTwoReplicas.forEach(r -> {
            try {
                this.containerStateManager.updateContainerReplica(containerTwo.containerID(), r);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        });
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = TestContainerReportHandler.getContainerReportsProto(containerOne.containerID(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED, datanodeOne.getUuidString());
        SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode containerReportFromDatanode = new SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode(datanodeOne, containerReport);
        reportHandler.onMessage(containerReportFromDatanode, this.publisher);
        Assert.assertEquals((Object)HddsProtos.LifeCycleState.CLOSED, (Object)containerOne.getState());
    }

    private static StorageContainerDatanodeProtocolProtos.ContainerReportsProto getContainerReportsProto(ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state, String originNodeId) {
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto.Builder crBuilder = StorageContainerDatanodeProtocolProtos.ContainerReportsProto.newBuilder();
        StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto = StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.newBuilder().setContainerID(containerId.getId()).setState(state).setOriginNodeId(originNodeId).setFinalhash("e16cc9d6024365750ed8dbd194ea46d2").setSize(0x140000000L).setUsed(2000000000L).setKeyCount(100000000L).setReadCount(100000000L).setWriteCount(100000000L).setReadBytes(2000000000L).setWriteBytes(2000000000L).setBlockCommitSequenceId(10000L).setDeleteTransactionId(0L).build();
        return crBuilder.addReports(replicaProto).build();
    }
}

