/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.CloseContainerEventHandler;
import org.apache.hadoop.hdds.scm.container.ContainerActionsHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestContainerActionsHandler {
    @Test
    public void testCloseContainerAction() {
        EventQueue queue = new EventQueue();
        ContainerActionsHandler actionsHandler = new ContainerActionsHandler();
        CloseContainerEventHandler closeContainerEventHandler = (CloseContainerEventHandler)Mockito.mock(CloseContainerEventHandler.class);
        queue.addHandler((Event)SCMEvents.CLOSE_CONTAINER, (EventHandler)closeContainerEventHandler);
        queue.addHandler((Event)SCMEvents.CONTAINER_ACTIONS, (EventHandler)actionsHandler);
        StorageContainerDatanodeProtocolProtos.ContainerAction action = StorageContainerDatanodeProtocolProtos.ContainerAction.newBuilder().setContainerID(1L).setAction(StorageContainerDatanodeProtocolProtos.ContainerAction.Action.CLOSE).setReason(StorageContainerDatanodeProtocolProtos.ContainerAction.Reason.CONTAINER_FULL).build();
        StorageContainerDatanodeProtocolProtos.ContainerActionsProto cap = StorageContainerDatanodeProtocolProtos.ContainerActionsProto.newBuilder().addContainerActions(action).build();
        SCMDatanodeHeartbeatDispatcher.ContainerActionsFromDatanode containerActions = new SCMDatanodeHeartbeatDispatcher.ContainerActionsFromDatanode(MockDatanodeDetails.randomDatanodeDetails(), cap);
        queue.fireEvent((Event)SCMEvents.CONTAINER_ACTIONS, (Object)containerActions);
        queue.processAll(1000L);
        ((CloseContainerEventHandler)Mockito.verify((Object)closeContainerEventHandler, (VerificationMode)Mockito.times((int)1))).onMessage(ContainerID.valueof((long)1L), (EventPublisher)queue);
    }
}

