/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.container.CloseContainerEventHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.container.SCMContainerManager;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStoreImpl;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.MockRatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineManager;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.ozone.container.common.SCMTestUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;

public class TestCloseContainerEventHandler {
    private static OzoneConfiguration configuration;
    private static MockNodeManager nodeManager;
    private static SCMPipelineManager pipelineManager;
    private static SCMContainerManager containerManager;
    private static long size;
    private static File testDir;
    private static EventQueue eventQueue;
    private static SCMMetadataStore scmMetadataStore;

    @BeforeClass
    public static void setUp() throws Exception {
        configuration = SCMTestUtils.getConf();
        size = (long)configuration.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        testDir = GenericTestUtils.getTestDir((String)TestCloseContainerEventHandler.class.getSimpleName());
        configuration.set("ozone.metadata.dirs", testDir.getAbsolutePath());
        configuration.setInt("ozone.scm.ratis.pipeline.limit", 16);
        nodeManager = new MockNodeManager(true, 10);
        eventQueue = new EventQueue();
        scmMetadataStore = new SCMMetadataStoreImpl(configuration);
        pipelineManager = new SCMPipelineManager((ConfigurationSource)configuration, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)eventQueue);
        pipelineManager.allowPipelineCreation();
        MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider((NodeManager)nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)configuration, (EventPublisher)eventQueue);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        containerManager = new SCMContainerManager((ConfigurationSource)configuration, scmMetadataStore.getContainerTable(), (BatchOperationHandler)scmMetadataStore.getStore(), (PipelineManager)pipelineManager);
        pipelineManager.triggerPipelineCreation();
        eventQueue.addHandler((Event)SCMEvents.CLOSE_CONTAINER, (EventHandler)new CloseContainerEventHandler((PipelineManager)pipelineManager, (ContainerManager)containerManager));
        eventQueue.addHandler(SCMEvents.DATANODE_COMMAND, (EventHandler)nodeManager);
        Thread.sleep(2000L);
        TestUtils.openAllRatisPipelines((PipelineManager)pipelineManager);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (containerManager != null) {
            containerManager.close();
        }
        if (pipelineManager != null) {
            pipelineManager.close();
        }
        if (scmMetadataStore.getStore() != null) {
            scmMetadataStore.getStore().close();
        }
        FileUtil.fullyDelete((File)testDir);
    }

    @Test
    public void testIfCloseContainerEventHadnlerInvoked() {
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)CloseContainerEventHandler.LOG);
        eventQueue.fireEvent((Event)SCMEvents.CLOSE_CONTAINER, (Object)new ContainerID((long)Math.abs(RandomUtils.nextInt())));
        eventQueue.processAll(1000L);
        Assert.assertTrue((boolean)logCapturer.getOutput().contains("Close container Event triggered for container"));
    }

    @Test
    public void testCloseContainerEventWithInvalidContainer() {
        long id = Math.abs(RandomUtils.nextInt());
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)CloseContainerEventHandler.LOG);
        eventQueue.fireEvent((Event)SCMEvents.CLOSE_CONTAINER, (Object)new ContainerID(id));
        eventQueue.processAll(1000L);
        Assert.assertTrue((boolean)logCapturer.getOutput().contains("Failed to close the container"));
    }

    @Test
    public void testCloseContainerEventWithValidContainers() throws IOException {
        ContainerInfo container = containerManager.allocateContainer(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.ONE, "ozone");
        ContainerID id = container.containerID();
        DatanodeDetails datanode = pipelineManager.getPipeline(container.getPipelineID()).getFirstNode();
        int closeCount = nodeManager.getCommandCount(datanode);
        eventQueue.fireEvent((Event)SCMEvents.CLOSE_CONTAINER, (Object)id);
        eventQueue.processAll(1000L);
        Assert.assertEquals((long)(closeCount + 1), (long)nodeManager.getCommandCount(datanode));
        Assert.assertEquals((Object)HddsProtos.LifeCycleState.CLOSING, (Object)containerManager.getContainer(id).getState());
    }

    @Test
    public void testCloseContainerEventWithRatis() throws IOException {
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)CloseContainerEventHandler.LOG);
        ContainerInfo container = containerManager.allocateContainer(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, "ozone");
        ContainerID id = container.containerID();
        int[] closeCount = new int[3];
        eventQueue.fireEvent((Event)SCMEvents.CLOSE_CONTAINER, (Object)id);
        eventQueue.processAll(1000L);
        int i = 0;
        for (DatanodeDetails details : pipelineManager.getPipeline(container.getPipelineID()).getNodes()) {
            closeCount[i] = nodeManager.getCommandCount(details);
            ++i;
        }
        i = 0;
        for (DatanodeDetails details : pipelineManager.getPipeline(container.getPipelineID()).getNodes()) {
            Assert.assertEquals((long)closeCount[i], (long)nodeManager.getCommandCount(details));
            ++i;
        }
        eventQueue.fireEvent((Event)SCMEvents.CLOSE_CONTAINER, (Object)id);
        eventQueue.processAll(1000L);
        i = 0;
        for (DatanodeDetails details : pipelineManager.getPipeline(container.getPipelineID()).getNodes()) {
            Assert.assertEquals((long)(closeCount[i] + 1), (long)nodeManager.getCommandCount(details));
            Assert.assertEquals((Object)HddsProtos.LifeCycleState.CLOSING, (Object)containerManager.getContainer(id).getState());
            ++i;
        }
    }
}

