/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.placement.metrics.NodeStat;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.Node2ContainerMap;
import org.apache.hadoop.hdds.scm.node.states.Node2PipelineMap;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.VersionResponse;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.RegisteredCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.assertj.core.util.Preconditions;

public class MockNodeManager
implements NodeManager {
    private static final NodeData[] NODES = new NodeData[]{new NodeData(0xA0000000000L, 0x40000000L), new NodeData(0x400000000000L, 0x1900000000L), new NodeData(0x800000000000L, 0x4000000000L), new NodeData(0x280000000000L, 0x10000000000L), new NodeData(0x1000000000000L, 0xC80000000000L), new NodeData(0x140000000000L, 0x280000000L), new NodeData(0x200000000000L, 0x100000000000L), new NodeData(0x10000000000L, 0xE100000000L), new NodeData(0x10000000000L, 0xE100000000L, 2L), new NodeData(0x10000000000L, 0x3200000000L, 2L), new NodeData(0x10000000000L, 0x3200000000L, 3L)};
    private final List<DatanodeDetails> healthyNodes = new LinkedList<DatanodeDetails>();
    private final List<DatanodeDetails> staleNodes = new LinkedList<DatanodeDetails>();
    private final List<DatanodeDetails> deadNodes = new LinkedList<DatanodeDetails>();
    private final Map<DatanodeDetails, SCMNodeStat> nodeMetricMap = new HashMap<DatanodeDetails, SCMNodeStat>();
    private final SCMNodeStat aggregateStat;
    private boolean safemode;
    private final Map<UUID, List<SCMCommand>> commandMap;
    private Node2PipelineMap node2PipelineMap = new Node2PipelineMap();
    private final Node2ContainerMap node2ContainerMap = new Node2ContainerMap();
    private NetworkTopology clusterMap;
    private ConcurrentMap<String, Set<String>> dnsToUuidMap = new ConcurrentHashMap<String, Set<String>>();

    public MockNodeManager(NetworkTopologyImpl clusterMap, List<DatanodeDetails> nodes, boolean initializeFakeNodes, int nodeCount) {
        int x;
        this.aggregateStat = new SCMNodeStat();
        this.clusterMap = clusterMap;
        if (!nodes.isEmpty()) {
            for (x = 0; x < nodes.size(); ++x) {
                DatanodeDetails node = nodes.get(x);
                this.register(node, null, null);
                this.populateNodeMetric(node, x);
            }
        }
        if (initializeFakeNodes) {
            for (x = 0; x < nodeCount; ++x) {
                DatanodeDetails dd = MockDatanodeDetails.randomDatanodeDetails();
                this.register(dd, null, null);
                this.populateNodeMetric(dd, x);
            }
        }
        this.safemode = false;
        this.commandMap = new HashMap<UUID, List<SCMCommand>>();
    }

    public MockNodeManager(boolean initializeFakeNodes, int nodeCount) {
        this(new NetworkTopologyImpl((ConfigurationSource)new OzoneConfiguration()), new ArrayList<DatanodeDetails>(), initializeFakeNodes, nodeCount);
    }

    private void populateNodeMetric(DatanodeDetails datanodeDetails, int x) {
        SCMNodeStat newStat = new SCMNodeStat();
        long remaining = NODES[x % NODES.length].capacity - NODES[x % NODES.length].used;
        newStat.set(NODES[x % NODES.length].capacity, NODES[x % NODES.length].used, remaining);
        this.nodeMetricMap.put(datanodeDetails, newStat);
        this.aggregateStat.add((NodeStat)newStat);
        if (NODES[x % NODES.length].getCurrentState() == 1L) {
            this.healthyNodes.add(datanodeDetails);
        }
        if (NODES[x % NODES.length].getCurrentState() == 2L) {
            this.staleNodes.add(datanodeDetails);
        }
        if (NODES[x % NODES.length].getCurrentState() == 3L) {
            this.deadNodes.add(datanodeDetails);
        }
    }

    public void setSafemode(boolean safemode) {
        this.safemode = safemode;
    }

    public List<DatanodeDetails> getNodes(HddsProtos.NodeState nodestate) {
        if (nodestate == HddsProtos.NodeState.HEALTHY) {
            return this.healthyNodes;
        }
        if (nodestate == HddsProtos.NodeState.STALE) {
            return this.staleNodes;
        }
        if (nodestate == HddsProtos.NodeState.DEAD) {
            return this.deadNodes;
        }
        return null;
    }

    public int getNodeCount(HddsProtos.NodeState nodestate) {
        List<DatanodeDetails> nodes = this.getNodes(nodestate);
        if (nodes != null) {
            return nodes.size();
        }
        return 0;
    }

    public List<DatanodeDetails> getAllNodes() {
        return new ArrayList<DatanodeDetails>(this.nodeMetricMap.keySet());
    }

    public SCMNodeStat getStats() {
        return this.aggregateStat;
    }

    public Map<DatanodeDetails, SCMNodeStat> getNodeStats() {
        return this.nodeMetricMap;
    }

    public SCMNodeMetric getNodeStat(DatanodeDetails datanodeDetails) {
        SCMNodeStat stat = this.nodeMetricMap.get(datanodeDetails);
        if (stat == null) {
            return null;
        }
        return new SCMNodeMetric(stat);
    }

    public HddsProtos.NodeState getNodeState(DatanodeDetails dd) {
        return null;
    }

    public Set<PipelineID> getPipelines(DatanodeDetails dnId) {
        return this.node2PipelineMap.getPipelines(dnId.getUuid());
    }

    public int getPipelinesCount(DatanodeDetails datanodeDetails) {
        return this.node2PipelineMap.getPipelinesCount(datanodeDetails.getUuid());
    }

    public void addPipeline(Pipeline pipeline) {
        this.node2PipelineMap.addPipeline(pipeline);
    }

    public Node2PipelineMap getNode2PipelineMap() {
        return this.node2PipelineMap;
    }

    public void setNode2PipelineMap(Node2PipelineMap node2PipelineMap) {
        this.node2PipelineMap = node2PipelineMap;
    }

    public void removePipeline(Pipeline pipeline) {
        this.node2PipelineMap.removePipeline(pipeline);
    }

    public void addContainer(DatanodeDetails dd, ContainerID containerId) throws NodeNotFoundException {
        try {
            Set set = this.node2ContainerMap.getContainers(dd.getUuid());
            set.add(containerId);
            this.node2ContainerMap.setContainersForDatanode(dd.getUuid(), set);
        }
        catch (SCMException e) {
            e.printStackTrace();
        }
    }

    public void addDatanodeCommand(UUID dnId, SCMCommand command) {
        if (this.commandMap.containsKey(dnId)) {
            List<SCMCommand> commandList = this.commandMap.get(dnId);
            Preconditions.checkNotNull(commandList);
            commandList.add(command);
        } else {
            LinkedList<SCMCommand> commandList = new LinkedList<SCMCommand>();
            commandList.add(command);
            this.commandMap.put(dnId, commandList);
        }
    }

    public void processNodeReport(DatanodeDetails dnUuid, StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport) {
    }

    public void setContainers(DatanodeDetails uuid, Set<ContainerID> containerIds) throws NodeNotFoundException {
        try {
            this.node2ContainerMap.setContainersForDatanode(uuid.getUuid(), containerIds);
        }
        catch (SCMException e) {
            throw new NodeNotFoundException(e.getMessage());
        }
    }

    public Set<ContainerID> getContainers(DatanodeDetails uuid) {
        return this.node2ContainerMap.getContainers(uuid.getUuid());
    }

    public int getCommandCount(DatanodeDetails dd) {
        List<SCMCommand> list = this.commandMap.get(dd.getUuid());
        return list == null ? 0 : list.size();
    }

    public void clearCommandQueue(UUID dnId) {
        if (this.commandMap.containsKey(dnId)) {
            this.commandMap.put(dnId, new LinkedList());
        }
    }

    public void close() throws IOException {
    }

    public VersionResponse getVersion(StorageContainerDatanodeProtocolProtos.SCMVersionRequestProto versionRequest) {
        return null;
    }

    public RegisteredCommand register(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport, StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReportsProto) {
        try {
            this.node2ContainerMap.insertNewDatanode(datanodeDetails.getUuid(), Collections.emptySet());
            this.addEntryTodnsToUuidMap(datanodeDetails.getIpAddress(), datanodeDetails.getUuidString());
            if (this.clusterMap != null) {
                datanodeDetails.setNetworkName(datanodeDetails.getUuidString());
                this.clusterMap.add((Node)datanodeDetails);
            }
        }
        catch (SCMException e) {
            e.printStackTrace();
        }
        return null;
    }

    private synchronized void addEntryTodnsToUuidMap(String dnsName, String uuid) {
        ConcurrentHashMap.KeySetView dnList = (ConcurrentHashMap.KeySetView)this.dnsToUuidMap.get(dnsName);
        if (dnList == null) {
            dnList = ConcurrentHashMap.newKeySet();
            this.dnsToUuidMap.put(dnsName, dnList);
        }
        dnList.add(uuid);
    }

    public List<SCMCommand> processHeartbeat(DatanodeDetails datanodeDetails) {
        return null;
    }

    public Boolean isNodeRegistered(DatanodeDetails datanodeDetails) {
        return null;
    }

    public Map<String, Integer> getNodeCount() {
        HashMap<String, Integer> nodeCountMap = new HashMap<String, Integer>();
        for (HddsProtos.NodeState state : HddsProtos.NodeState.values()) {
            nodeCountMap.put(state.toString(), this.getNodeCount(state));
        }
        return nodeCountMap;
    }

    public Map<String, Long> getNodeInfo() {
        HashMap<String, Long> nodeInfo = new HashMap<String, Long>();
        nodeInfo.put("Capacity", this.aggregateStat.getCapacity().get());
        nodeInfo.put("Used", this.aggregateStat.getScmUsed().get());
        nodeInfo.put("Remaining", this.aggregateStat.getRemaining().get());
        return nodeInfo;
    }

    public void addContainer(DatanodeDetails datanodeDetails, long size) {
        SCMNodeStat stat = this.nodeMetricMap.get(datanodeDetails);
        if (stat != null) {
            this.aggregateStat.subtract((NodeStat)stat);
            stat.getCapacity().add(Long.valueOf(size));
            this.aggregateStat.add((NodeStat)stat);
            this.nodeMetricMap.put(datanodeDetails, stat);
        }
    }

    public void delContainer(DatanodeDetails datanodeDetails, long size) {
        SCMNodeStat stat = this.nodeMetricMap.get(datanodeDetails);
        if (stat != null) {
            this.aggregateStat.subtract((NodeStat)stat);
            stat.getCapacity().subtract(Long.valueOf(size));
            this.aggregateStat.add((NodeStat)stat);
            this.nodeMetricMap.put(datanodeDetails, stat);
        }
    }

    public void onMessage(CommandForDatanode commandForDatanode, EventPublisher publisher) {
        this.addDatanodeCommand(commandForDatanode.getDatanodeId(), commandForDatanode.getCommand());
    }

    public List<SCMCommand> getCommandQueue(UUID dnID) {
        return null;
    }

    public DatanodeDetails getNodeByUuid(String uuid) {
        Node node = this.clusterMap.getNode("/default-rack/" + uuid);
        return node == null ? null : (DatanodeDetails)node;
    }

    public List<DatanodeDetails> getNodesByAddress(String address) {
        LinkedList<DatanodeDetails> results = new LinkedList<DatanodeDetails>();
        Set uuids = (Set)this.dnsToUuidMap.get(address);
        if (uuids == null) {
            return results;
        }
        for (String uuid : uuids) {
            DatanodeDetails dn = this.getNodeByUuid(uuid);
            if (dn == null) continue;
            results.add(dn);
        }
        return results;
    }

    public NetworkTopology getClusterNetworkTopologyMap() {
        return this.clusterMap;
    }

    public void setNetworkTopology(NetworkTopology topology) {
        this.clusterMap = topology;
    }

    private static class NodeData {
        public static final long HEALTHY = 1L;
        public static final long STALE = 2L;
        public static final long DEAD = 3L;
        private long capacity;
        private long used;
        private long currentState;

        NodeData(long capacity, long used) {
            this(capacity, used, 1L);
        }

        NodeData(long capacity, long used, long currentState) {
            this.capacity = capacity;
            this.used = used;
            this.currentState = currentState;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public void setCapacity(long capacity) {
            this.capacity = capacity;
        }

        public long getUsed() {
            return this.used;
        }

        public void setUsed(long used) {
            this.used = used;
        }

        public long getCurrentState() {
            return this.currentState;
        }

        public void setCurrentState(long currentState) {
            this.currentState = currentState;
        }
    }
}

