/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.HddsIdFactory;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.command.CommandStatusReportHandler;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCommandStatusReportHandler
implements EventPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(TestCommandStatusReportHandler.class);
    private CommandStatusReportHandler cmdStatusReportHandler;

    @Before
    public void setup() {
        this.cmdStatusReportHandler = new CommandStatusReportHandler();
    }

    @Test
    public void testCommandStatusReport() {
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)LOG);
        SCMDatanodeHeartbeatDispatcher.CommandStatusReportFromDatanode report = this.getStatusReport(Collections.emptyList());
        this.cmdStatusReportHandler.onMessage(report, (EventPublisher)this);
        Assert.assertFalse((boolean)logCapturer.getOutput().contains("Delete_Block_Status"));
        Assert.assertFalse((boolean)logCapturer.getOutput().contains("Replicate_Command_Status"));
        report = this.getStatusReport(this.getCommandStatusList());
        this.cmdStatusReportHandler.onMessage(report, (EventPublisher)this);
        Assert.assertTrue((boolean)logCapturer.getOutput().contains("firing event of type Delete_Block_Status"));
        Assert.assertTrue((boolean)logCapturer.getOutput().contains("type: deleteBlocksCommand"));
    }

    private SCMDatanodeHeartbeatDispatcher.CommandStatusReportFromDatanode getStatusReport(List<StorageContainerDatanodeProtocolProtos.CommandStatus> reports) {
        StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto report = TestUtils.createCommandStatusReport(reports);
        DatanodeDetails dn = MockDatanodeDetails.randomDatanodeDetails();
        return new SCMDatanodeHeartbeatDispatcher.CommandStatusReportFromDatanode(dn, report);
    }

    public <PAYLOAD, EVENT_TYPE extends Event<PAYLOAD>> void fireEvent(EVENT_TYPE event, PAYLOAD payload) {
        LOG.info("firing event of type {}, payload {}", (Object)event.getName(), (Object)payload.toString());
    }

    private List<StorageContainerDatanodeProtocolProtos.CommandStatus> getCommandStatusList() {
        ArrayList<StorageContainerDatanodeProtocolProtos.CommandStatus> reports = new ArrayList<StorageContainerDatanodeProtocolProtos.CommandStatus>(3);
        StorageContainerDatanodeProtocolProtos.CommandStatus.Builder builder = StorageContainerDatanodeProtocolProtos.CommandStatus.newBuilder();
        builder.setCmdId(HddsIdFactory.getLongId()).setStatus(StorageContainerDatanodeProtocolProtos.CommandStatus.Status.EXECUTED).setType(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand);
        reports.add(builder.build());
        builder.setMsg("Not enough space").setCmdId(HddsIdFactory.getLongId()).setStatus(StorageContainerDatanodeProtocolProtos.CommandStatus.Status.FAILED).setType(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand);
        reports.add(builder.build());
        return reports;
    }
}

