/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.block.DatanodeDeletedBlockTransactions;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogImpl;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.SCMContainerManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestDeletedBlockLog {
    private static DeletedBlockLogImpl deletedBlockLog;
    private OzoneConfiguration conf;
    private File testDir;
    private ContainerManager containerManager;
    private StorageContainerManager scm;
    private List<DatanodeDetails> dnList;

    @Before
    public void setup() throws Exception {
        this.testDir = GenericTestUtils.getTestDir((String)TestDeletedBlockLog.class.getSimpleName());
        this.conf = new OzoneConfiguration();
        this.conf.setInt("ozone.scm.block.deletion.max.retry", 20);
        this.conf.set("ozone.metadata.dirs", this.testDir.getAbsolutePath());
        this.scm = TestUtils.getScm(this.conf);
        this.containerManager = (ContainerManager)Mockito.mock(SCMContainerManager.class);
        deletedBlockLog = new DeletedBlockLogImpl((ConfigurationSource)this.conf, this.containerManager, this.scm.getScmMetadataStore());
        this.dnList = new ArrayList<DatanodeDetails>(3);
        this.setupContainerManager();
    }

    private void setupContainerManager() throws IOException {
        this.dnList.add(DatanodeDetails.newBuilder().setUuid(UUID.randomUUID()).build());
        this.dnList.add(DatanodeDetails.newBuilder().setUuid(UUID.randomUUID()).build());
        this.dnList.add(DatanodeDetails.newBuilder().setUuid(UUID.randomUUID()).build());
        ContainerInfo container = new ContainerInfo.Builder().setContainerID(1L).setReplicationFactor(HddsProtos.ReplicationFactor.THREE).setState(HddsProtos.LifeCycleState.CLOSED).build();
        Set replicaSet = this.dnList.stream().map(datanodeDetails -> ContainerReplica.newBuilder().setContainerID(container.containerID()).setContainerState(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN).setDatanodeDetails(datanodeDetails).build()).collect(Collectors.toSet());
        Mockito.when((Object)this.containerManager.getContainerReplicas((ContainerID)Matchers.anyObject())).thenReturn(replicaSet);
        Mockito.when((Object)this.containerManager.getContainer((ContainerID)Matchers.anyObject())).thenReturn((Object)container);
    }

    @After
    public void tearDown() throws Exception {
        deletedBlockLog.close();
        this.scm.stop();
        this.scm.join();
        FileUtils.deleteDirectory((File)this.testDir);
    }

    private Map<Long, List<Long>> generateData(int dataSize) {
        HashMap<Long, List<Long>> blockMap = new HashMap<Long, List<Long>>();
        Random random = new Random(1L);
        int continerIDBase = random.nextInt(100);
        int localIDBase = random.nextInt(1000);
        for (int i = 0; i < dataSize; ++i) {
            long containerID = continerIDBase + i;
            ArrayList<Long> blocks = new ArrayList<Long>();
            int blockSize = random.nextInt(30) + 1;
            for (int j = 0; j < blockSize; ++j) {
                long localID = localIDBase + j;
                blocks.add(localID);
            }
            blockMap.put(containerID, blocks);
        }
        return blockMap;
    }

    private void commitTransactions(List<StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult> transactionResults, DatanodeDetails ... dns) {
        for (DatanodeDetails dnDetails : dns) {
            deletedBlockLog.commitTransactions(transactionResults, dnDetails.getUuid());
        }
    }

    private void commitTransactions(List<StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult> transactionResults) {
        this.commitTransactions(transactionResults, this.dnList.toArray(new DatanodeDetails[3]));
    }

    private void commitTransactions(Collection<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTransactions, DatanodeDetails ... dns) {
        this.commitTransactions(deletedBlocksTransactions.stream().map(this::createDeleteBlockTransactionResult).collect(Collectors.toList()), dns);
    }

    private void commitTransactions(Collection<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTransactions) {
        this.commitTransactions(deletedBlocksTransactions.stream().map(this::createDeleteBlockTransactionResult).collect(Collectors.toList()));
    }

    private StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult createDeleteBlockTransactionResult(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction transaction) {
        return StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult.newBuilder().setContainerID(transaction.getContainerID()).setSuccess(true).setTxID(transaction.getTxID()).build();
    }

    private List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getTransactions(int maximumAllowedTXNum) throws IOException {
        DatanodeDeletedBlockTransactions transactions = new DatanodeDeletedBlockTransactions(this.containerManager, maximumAllowedTXNum, 3);
        deletedBlockLog.getTransactions(transactions);
        return transactions.getDatanodeTransactions(this.dnList.get(0).getUuid());
    }

    @Test
    public void testIncrementCount() throws Exception {
        int maxRetry = this.conf.getInt("ozone.scm.block.deletion.max.retry", 20);
        for (Map.Entry<Long, List<Long>> entry : this.generateData(30).entrySet()) {
            deletedBlockLog.addTransaction(entry.getKey().longValue(), entry.getValue());
        }
        List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> blocks = this.getTransactions(40);
        List txIDs = blocks.stream().map(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction::getTxID).collect(Collectors.toList());
        for (int i = 0; i < maxRetry; ++i) {
            deletedBlockLog.incrementCount(txIDs);
        }
        deletedBlockLog.incrementCount(txIDs);
        blocks = this.getTransactions(40);
        for (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction block : blocks) {
            Assert.assertEquals((long)-1L, (long)block.getCount());
        }
        blocks = this.getTransactions(40);
        Assert.assertEquals((long)blocks.size(), (long)0L);
    }

    @Test
    public void testCommitTransactions() throws Exception {
        for (Map.Entry<Long, List<Long>> entry : this.generateData(50).entrySet()) {
            deletedBlockLog.addTransaction(entry.getKey().longValue(), entry.getValue());
        }
        List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> blocks = this.getTransactions(20);
        blocks.add(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.newBuilder().setContainerID(1L).setTxID(70L).setCount(0).addLocalID(0L).build());
        this.commitTransactions((Collection<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>)blocks);
        blocks.remove(blocks.size() - 1);
        blocks = this.getTransactions(50);
        Assert.assertEquals((long)30L, (long)blocks.size());
        this.commitTransactions((Collection<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>)blocks, this.dnList.get(1), this.dnList.get(2), DatanodeDetails.newBuilder().setUuid(UUID.randomUUID()).build());
        blocks = this.getTransactions(50);
        Assert.assertEquals((long)30L, (long)blocks.size());
        this.commitTransactions((Collection<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>)blocks, this.dnList.get(0));
        blocks = this.getTransactions(50);
        Assert.assertEquals((long)0L, (long)blocks.size());
    }

    @Test
    public void testRandomOperateTransactions() throws Exception {
        Random random = new Random();
        int added = 0;
        int committed = 0;
        List<Object> blocks = new ArrayList();
        ArrayList<Long> txIDs = new ArrayList<Long>();
        byte[] latestTxid = StringUtils.string2Bytes((String)"#LATEST_TXID#");
        MetadataKeyFilters.MetadataKeyFilter avoidLatestTxid = (preKey, currentKey, nextKey) -> !Arrays.equals(latestTxid, currentKey);
        for (int i = 0; i < 100; ++i) {
            int state = random.nextInt(4);
            if (state == 0) {
                for (Map.Entry<Long, List<Long>> entry : this.generateData(10).entrySet()) {
                    deletedBlockLog.addTransaction(entry.getKey().longValue(), entry.getValue());
                }
                added += 10;
                continue;
            }
            if (state == 1) {
                blocks = this.getTransactions(20);
                txIDs = new ArrayList();
                for (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction block : blocks) {
                    txIDs.add(block.getTxID());
                }
                deletedBlockLog.incrementCount(txIDs);
                continue;
            }
            if (state == 2) {
                this.commitTransactions((Collection<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>)blocks);
                committed += blocks.size();
                blocks = new ArrayList();
                continue;
            }
            try (TableIterator iter = this.scm.getScmMetadataStore().getDeletedBlocksTXTable().iterator();){
                AtomicInteger count = new AtomicInteger();
                iter.forEachRemaining(keyValue -> count.incrementAndGet());
                Assert.assertEquals((long)added, (long)(count.get() + committed));
                continue;
            }
        }
        blocks = this.getTransactions(1000);
        this.commitTransactions((Collection<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>)blocks);
    }

    @Test
    public void testPersistence() throws Exception {
        for (Map.Entry<Long, List<Long>> entry : this.generateData(50).entrySet()) {
            deletedBlockLog.addTransaction(entry.getKey().longValue(), entry.getValue());
        }
        deletedBlockLog.close();
        deletedBlockLog = new DeletedBlockLogImpl((ConfigurationSource)this.conf, this.containerManager, this.scm.getScmMetadataStore());
        List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> blocks = this.getTransactions(10);
        this.commitTransactions((Collection<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>)blocks);
        blocks = this.getTransactions(100);
        Assert.assertEquals((long)40L, (long)blocks.size());
        this.commitTransactions((Collection<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>)blocks);
    }

    @Test
    public void testDeletedBlockTransactions() throws IOException {
        int txNum = 10;
        int maximumAllowedTXNum = 5;
        List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> blocks = null;
        LinkedList<Long> containerIDs = new LinkedList<Long>();
        DatanodeDetails dnId1 = this.dnList.get(0);
        DatanodeDetails dnId2 = this.dnList.get(1);
        int count = 0;
        long containerID = 0L;
        for (Map.Entry<Long, List<Long>> entry : this.generateData(txNum).entrySet()) {
            containerID = entry.getKey();
            containerIDs.add(containerID);
            deletedBlockLog.addTransaction(containerID, entry.getValue());
            if (++count <= maximumAllowedTXNum + 1) {
                this.mockContainerInfo(containerID, dnId1);
                continue;
            }
            this.mockContainerInfo(containerID, dnId2);
        }
        DatanodeDeletedBlockTransactions transactions = new DatanodeDeletedBlockTransactions(this.containerManager, maximumAllowedTXNum, 2);
        deletedBlockLog.getTransactions(transactions);
        for (UUID id : transactions.getDatanodeIDs()) {
            List txs = transactions.getDatanodeTransactions(id);
            this.commitTransactions(txs);
        }
        blocks = this.getTransactions(txNum);
        Assert.assertEquals((long)1L, (long)blocks.size());
        Assert.assertFalse((boolean)transactions.isFull());
        Assert.assertEquals((long)maximumAllowedTXNum, (long)transactions.getDatanodeTransactions(dnId1.getUuid()).size());
        int n = transactions.getDatanodeTransactions(dnId2.getUuid()).size();
        StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.Builder builder = StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.newBuilder();
        builder.setTxID(11L);
        builder.setContainerID(containerID);
        builder.setCount(0);
        transactions.addTransaction(builder.build(), null);
        Assert.assertEquals((long)n, (long)transactions.getDatanodeTransactions(dnId2.getUuid()).size());
        containerID = RandomUtils.nextLong();
        builder = StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.newBuilder();
        builder.setTxID(12L);
        builder.setContainerID(containerID);
        builder.setCount(0);
        this.mockContainerInfo(containerID, dnId2);
        transactions.addTransaction(builder.build(), null);
        Assert.assertTrue((boolean)transactions.isFull());
    }

    private void mockContainerInfo(long containerID, DatanodeDetails dd) throws IOException {
        List<DatanodeDetails> dns = Collections.singletonList(dd);
        Pipeline pipeline = Pipeline.newBuilder().setType(HddsProtos.ReplicationType.STAND_ALONE).setFactor(HddsProtos.ReplicationFactor.ONE).setState(Pipeline.PipelineState.OPEN).setId(PipelineID.randomId()).setNodes(dns).build();
        ContainerInfo.Builder builder = new ContainerInfo.Builder();
        builder.setPipelineID(pipeline.getId()).setReplicationType(pipeline.getType()).setReplicationFactor(pipeline.getFactor());
        ContainerInfo containerInfo = builder.build();
        ((ContainerManager)Mockito.doReturn((Object)containerInfo).when((Object)this.containerManager)).getContainer(ContainerID.valueof((long)containerID));
        Set replicaSet = dns.stream().map(datanodeDetails -> ContainerReplica.newBuilder().setContainerID(containerInfo.containerID()).setContainerState(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN).setDatanodeDetails(datanodeDetails).build()).collect(Collectors.toSet());
        Mockito.when((Object)this.containerManager.getContainerReplicas(ContainerID.valueof((long)containerID))).thenReturn(replicaSet);
    }
}

