/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.SCMConfigurator;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.protocol.commands.RegisteredCommand;
import org.apache.hadoop.security.authentication.client.AuthenticationException;

public final class TestUtils {
    private static ThreadLocalRandom random = ThreadLocalRandom.current();

    private TestUtils() {
    }

    public static DatanodeDetails getDatanodeDetails(RegisteredCommand registeredCommand) {
        return MockDatanodeDetails.createDatanodeDetails((String)registeredCommand.getDatanode().getUuidString(), (String)registeredCommand.getDatanode().getHostName(), (String)registeredCommand.getDatanode().getIpAddress(), null);
    }

    public static DatanodeDetails createRandomDatanodeAndRegister(SCMNodeManager nodeManager) {
        return TestUtils.getDatanodeDetails(nodeManager.register(MockDatanodeDetails.randomDatanodeDetails(), null, TestUtils.getRandomPipelineReports()));
    }

    public static List<DatanodeDetails> getListOfRegisteredDatanodeDetails(SCMNodeManager nodeManager, int count) {
        ArrayList<DatanodeDetails> datanodes = new ArrayList<DatanodeDetails>();
        for (int i = 0; i < count; ++i) {
            datanodes.add(TestUtils.createRandomDatanodeAndRegister(nodeManager));
        }
        return datanodes;
    }

    public static StorageContainerDatanodeProtocolProtos.NodeReportProto getRandomNodeReport() {
        return TestUtils.getRandomNodeReport(1);
    }

    public static StorageContainerDatanodeProtocolProtos.NodeReportProto getRandomNodeReport(int numberOfStorageReport) {
        UUID nodeId = UUID.randomUUID();
        return TestUtils.getRandomNodeReport(nodeId, File.separator + nodeId, numberOfStorageReport);
    }

    public static StorageContainerDatanodeProtocolProtos.NodeReportProto getRandomNodeReport(UUID nodeId, String basePath, int numberOfStorageReport) {
        ArrayList<StorageContainerDatanodeProtocolProtos.StorageReportProto> storageReports = new ArrayList<StorageContainerDatanodeProtocolProtos.StorageReportProto>();
        for (int i = 0; i < numberOfStorageReport; ++i) {
            storageReports.add(TestUtils.getRandomStorageReport(nodeId, basePath + File.separator + i));
        }
        return TestUtils.createNodeReport(storageReports);
    }

    public static StorageContainerDatanodeProtocolProtos.NodeReportProto createNodeReport(StorageContainerDatanodeProtocolProtos.StorageReportProto ... reports) {
        return TestUtils.createNodeReport(Arrays.asList(reports));
    }

    public static StorageContainerDatanodeProtocolProtos.NodeReportProto createNodeReport(List<StorageContainerDatanodeProtocolProtos.StorageReportProto> reports) {
        StorageContainerDatanodeProtocolProtos.NodeReportProto.Builder nodeReport = StorageContainerDatanodeProtocolProtos.NodeReportProto.newBuilder();
        nodeReport.addAllStorageReport(reports);
        return nodeReport.build();
    }

    public static StorageContainerDatanodeProtocolProtos.StorageReportProto getRandomStorageReport(UUID nodeId, String path) {
        return TestUtils.createStorageReport(nodeId, path, random.nextInt(1000), random.nextInt(500), random.nextInt(500), StorageContainerDatanodeProtocolProtos.StorageTypeProto.DISK);
    }

    public static StorageContainerDatanodeProtocolProtos.StorageReportProto createStorageReport(UUID nodeId, String path, long capacity, long used, long remaining, StorageContainerDatanodeProtocolProtos.StorageTypeProto type) {
        Preconditions.checkNotNull((Object)nodeId);
        Preconditions.checkNotNull((Object)path);
        StorageContainerDatanodeProtocolProtos.StorageReportProto.Builder srb = StorageContainerDatanodeProtocolProtos.StorageReportProto.newBuilder();
        srb.setStorageUuid(nodeId.toString()).setStorageLocation(path).setCapacity(capacity).setScmUsed(used).setRemaining(remaining);
        StorageContainerDatanodeProtocolProtos.StorageTypeProto storageTypeProto = type == null ? StorageContainerDatanodeProtocolProtos.StorageTypeProto.DISK : type;
        srb.setStorageType(storageTypeProto);
        return srb.build();
    }

    public static StorageContainerDatanodeProtocolProtos.ContainerReportsProto getRandomContainerReports() {
        return TestUtils.getRandomContainerReports(1);
    }

    public static StorageContainerDatanodeProtocolProtos.ContainerReportsProto getRandomContainerReports(int numberOfContainers) {
        ArrayList<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> containerInfos = new ArrayList<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto>();
        for (int i = 0; i < numberOfContainers; ++i) {
            containerInfos.add(TestUtils.getRandomContainerInfo(i));
        }
        return TestUtils.getContainerReports(containerInfos);
    }

    public static StorageContainerDatanodeProtocolProtos.PipelineReportsProto getRandomPipelineReports() {
        return StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder().build();
    }

    public static SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode getPipelineReportFromDatanode(DatanodeDetails dn, PipelineID ... pipelineIDs) {
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto.Builder reportBuilder = StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder();
        for (PipelineID pipelineID : pipelineIDs) {
            reportBuilder.addPipelineReport(StorageContainerDatanodeProtocolProtos.PipelineReport.newBuilder().setPipelineID(pipelineID.getProtobuf()).setIsLeader(false));
        }
        return new SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode(dn, reportBuilder.build());
    }

    public static SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode getPipelineReportFromDatanode(DatanodeDetails dn, PipelineID pipelineID, boolean isLeader) {
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto.Builder reportBuilder = StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder();
        reportBuilder.addPipelineReport(StorageContainerDatanodeProtocolProtos.PipelineReport.newBuilder().setPipelineID(pipelineID.getProtobuf()).setIsLeader(isLeader));
        return new SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode(dn, reportBuilder.build());
    }

    public static void openAllRatisPipelines(PipelineManager pipelineManager) throws IOException {
        List pipelines = pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS);
        for (Pipeline pipeline : pipelines) {
            pipelineManager.openPipeline(pipeline.getId());
        }
    }

    public static SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode getPipelineActionFromDatanode(DatanodeDetails dn, PipelineID ... pipelineIDs) {
        StorageContainerDatanodeProtocolProtos.PipelineActionsProto.Builder actionsProtoBuilder = StorageContainerDatanodeProtocolProtos.PipelineActionsProto.newBuilder();
        for (PipelineID pipelineID : pipelineIDs) {
            StorageContainerDatanodeProtocolProtos.ClosePipelineInfo closePipelineInfo = StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.newBuilder().setPipelineID(pipelineID.getProtobuf()).setReason(StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.PIPELINE_FAILED).setDetailedReason("").build();
            actionsProtoBuilder.addPipelineActions(StorageContainerDatanodeProtocolProtos.PipelineAction.newBuilder().setClosePipeline(closePipelineInfo).setAction(StorageContainerDatanodeProtocolProtos.PipelineAction.Action.CLOSE).build());
        }
        return new SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode(dn, actionsProtoBuilder.build());
    }

    public static StorageContainerDatanodeProtocolProtos.ContainerReportsProto getContainerReports(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto ... containerInfos) {
        return TestUtils.getContainerReports(Arrays.asList(containerInfos));
    }

    public static StorageContainerDatanodeProtocolProtos.ContainerReportsProto getContainerReports(List<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> containerInfos) {
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto.Builder reportsBuilder = StorageContainerDatanodeProtocolProtos.ContainerReportsProto.newBuilder();
        for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto containerInfo : containerInfos) {
            reportsBuilder.addReports(containerInfo);
        }
        return reportsBuilder.build();
    }

    public static StorageContainerDatanodeProtocolProtos.ContainerReplicaProto getRandomContainerInfo(long containerId) {
        return TestUtils.createContainerInfo(containerId, 0x140000000L, random.nextLong(1000L), 0x40000000L * (long)random.nextInt(5), random.nextLong(1000L), 0x40000000L * (long)random.nextInt(2), random.nextLong(1000L), 0x40000000L * (long)random.nextInt(5));
    }

    public static StorageContainerDatanodeProtocolProtos.ContainerReplicaProto createContainerInfo(long containerId, long size, long keyCount, long bytesUsed, long readCount, long readBytes, long writeCount, long writeBytes) {
        return StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.newBuilder().setContainerID(containerId).setState(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN).setSize(size).setKeyCount(keyCount).setUsed(bytesUsed).setReadCount(readCount).setReadBytes(readBytes).setWriteCount(writeCount).setWriteBytes(writeBytes).build();
    }

    public static StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto createCommandStatusReport(List<StorageContainerDatanodeProtocolProtos.CommandStatus> reports) {
        StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto.Builder report = StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto.newBuilder();
        report.addAllCmdStatus(reports);
        return report.build();
    }

    public static ContainerInfo allocateContainer(ContainerManager containerManager) throws IOException {
        return containerManager.allocateContainer(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, "root");
    }

    public static void closeContainer(ContainerManager containerManager, ContainerID id) throws IOException {
        containerManager.updateContainerState(id, HddsProtos.LifeCycleEvent.FINALIZE);
        containerManager.updateContainerState(id, HddsProtos.LifeCycleEvent.CLOSE);
    }

    public static void quasiCloseContainer(ContainerManager containerManager, ContainerID id) throws IOException {
        containerManager.updateContainerState(id, HddsProtos.LifeCycleEvent.FINALIZE);
        containerManager.updateContainerState(id, HddsProtos.LifeCycleEvent.QUASI_CLOSE);
    }

    public static StorageContainerManager getScm(OzoneConfiguration conf) throws IOException, AuthenticationException {
        return TestUtils.getScm(conf, new SCMConfigurator());
    }

    public static StorageContainerManager getScm(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException, AuthenticationException {
        conf.set("ozone.scm.client.address", "127.0.0.1:0");
        conf.set("ozone.scm.block.client.address", "127.0.0.1:0");
        conf.set("ozone.scm.datanode.address", "127.0.0.1:0");
        conf.set("ozone.scm.http-address", "127.0.0.1:0");
        SCMStorageConfig scmStore = new SCMStorageConfig(conf);
        if (scmStore.getState() != Storage.StorageState.INITIALIZED) {
            String clusterId = UUID.randomUUID().toString();
            String scmId = UUID.randomUUID().toString();
            scmStore.setClusterId(clusterId);
            scmStore.setScmId(scmId);
            scmStore.initialize();
        }
        return new StorageContainerManager(conf, configurator);
    }

    public static ContainerInfo getContainer(HddsProtos.LifeCycleState state) {
        return new ContainerInfo.Builder().setContainerID(RandomUtils.nextLong()).setReplicationType(HddsProtos.ReplicationType.RATIS).setReplicationFactor(HddsProtos.ReplicationFactor.THREE).setState(state).setSequenceId(10000L).setOwner("TEST").build();
    }

    public static Set<ContainerReplica> getReplicas(ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state, DatanodeDetails ... datanodeDetails) {
        return TestUtils.getReplicas(containerId, state, 10000L, datanodeDetails);
    }

    public static Set<ContainerReplica> getReplicas(ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state, long sequenceId, DatanodeDetails ... datanodeDetails) {
        HashSet<ContainerReplica> replicas = new HashSet<ContainerReplica>();
        for (DatanodeDetails datanode : datanodeDetails) {
            replicas.add(TestUtils.getReplicas(containerId, state, sequenceId, datanode.getUuid(), datanode));
        }
        return replicas;
    }

    public static ContainerReplica getReplicas(ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State state, long sequenceId, UUID originNodeId, DatanodeDetails datanodeDetails) {
        return ContainerReplica.newBuilder().setContainerID(containerId).setContainerState(state).setDatanodeDetails(datanodeDetails).setOriginNodeId(originNodeId).setSequenceId(sequenceId).build();
    }
}

