/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.server.StorageContainerManagerHttpServer;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestStorageContainerManagerHttpServer {
    private static final String BASEDIR = GenericTestUtils.getTempPath((String)TestStorageContainerManagerHttpServer.class.getSimpleName());
    private static String keystoresDir;
    private static String sslConfDir;
    private static OzoneConfiguration conf;
    private static URLConnectionFactory connectionFactory;
    private final HttpConfig.Policy policy;

    @Parameterized.Parameters
    public static Collection<Object[]> policy() {
        Object[][] params = new Object[][]{{HttpConfig.Policy.HTTP_ONLY}, {HttpConfig.Policy.HTTPS_ONLY}, {HttpConfig.Policy.HTTP_AND_HTTPS}};
        return Arrays.asList(params);
    }

    public TestStorageContainerManagerHttpServer(HttpConfig.Policy policy) {
        this.policy = policy;
    }

    @BeforeClass
    public static void setUp() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        conf = new OzoneConfiguration();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestStorageContainerManagerHttpServer.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
        conf.set("ozone.https.client.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        conf.set("ozone.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        connectionFactory.destroy();
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
    }

    @Test
    public void testHttpPolicy() throws Exception {
        conf.set("ozone.http.policy", this.policy.name());
        conf.set("ozone.scm.http-address", "localhost:0");
        conf.set("ozone.scm.https-address", "localhost:0");
        StorageContainerManagerHttpServer server = null;
        try {
            server = new StorageContainerManagerHttpServer((MutableConfigurationSource)conf);
            server.start();
            Assert.assertTrue((boolean)TestStorageContainerManagerHttpServer.implies(this.policy.isHttpEnabled(), TestStorageContainerManagerHttpServer.canAccess("http", server.getHttpAddress())));
            Assert.assertTrue((boolean)TestStorageContainerManagerHttpServer.implies(this.policy.isHttpEnabled() && !this.policy.isHttpsEnabled(), !TestStorageContainerManagerHttpServer.canAccess("https", server.getHttpsAddress())));
            Assert.assertTrue((boolean)TestStorageContainerManagerHttpServer.implies(this.policy.isHttpsEnabled(), TestStorageContainerManagerHttpServer.canAccess("https", server.getHttpsAddress())));
            Assert.assertTrue((boolean)TestStorageContainerManagerHttpServer.implies(this.policy.isHttpsEnabled() && !this.policy.isHttpEnabled(), !TestStorageContainerManagerHttpServer.canAccess("http", server.getHttpAddress())));
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    private static boolean canAccess(String scheme, InetSocketAddress addr) {
        if (addr == null) {
            return false;
        }
        try {
            URL url = new URL(scheme + "://" + NetUtils.getHostPortString((InetSocketAddress)addr) + "/jmx");
            URLConnection conn = connectionFactory.openConnection(url);
            conn.connect();
            conn.getContent();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static boolean implies(boolean a, boolean b) {
        return !a || b;
    }
}

