/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.test.PathUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHddsServerUtils {
    public static final Logger LOG = LoggerFactory.getLogger(TestHddsServerUtils.class);
    @Rule
    public Timeout timeout = new Timeout(300000);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testGetDatanodeAddressWithPort() {
        String scmHost = "host123:100";
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.datanode.address", "host123:100");
        InetSocketAddress address = HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
        Assert.assertEquals((Object)address.getHostName(), (Object)"host123:100".split(":")[0]);
        Assert.assertEquals((long)address.getPort(), (long)Integer.parseInt("host123:100".split(":")[1]));
    }

    @Test
    public void testGetDatanodeAddressWithoutPort() {
        String scmHost = "host123";
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.datanode.address", "host123");
        InetSocketAddress address = HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
        Assert.assertEquals((Object)"host123", (Object)address.getHostName());
        Assert.assertEquals((long)9861L, (long)address.getPort());
    }

    @Test
    public void testDatanodeAddressFallbackToClientNoPort() {
        String scmHost = "host123";
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.client.address", "host123");
        InetSocketAddress address = HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
        Assert.assertEquals((Object)"host123", (Object)address.getHostName());
        Assert.assertEquals((long)9861L, (long)address.getPort());
    }

    @Test
    public void testDatanodeAddressFallbackToClientWithPort() {
        String scmHost = "host123:100";
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.client.address", "host123:100");
        InetSocketAddress address = HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
        Assert.assertEquals((Object)address.getHostName(), (Object)"host123:100".split(":")[0]);
        Assert.assertEquals((long)address.getPort(), (long)9861L);
    }

    @Test
    public void testDatanodeAddressFallbackToScmNamesNoPort() {
        String scmHost = "host123";
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.names", "host123");
        InetSocketAddress address = HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
        Assert.assertEquals((Object)"host123", (Object)address.getHostName());
        Assert.assertEquals((long)9861L, (long)address.getPort());
    }

    @Test
    public void testDatanodeAddressFallbackToScmNamesWithPort() {
        String scmHost = "host123:100";
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.names", "host123:100");
        InetSocketAddress address = HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
        Assert.assertEquals((Object)address.getHostName(), (Object)"host123:100".split(":")[0]);
        Assert.assertEquals((long)9861L, (long)address.getPort());
    }

    @Test
    public void testClientFailsWithMultipleScmNames() {
        String scmHost = "host123,host456";
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.names", "host123,host456");
        this.thrown.expect(IllegalArgumentException.class);
        HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetScmDbDir() {
        File testDir = PathUtils.getTestDir(TestHddsServerUtils.class);
        File dbDir = new File(testDir, "scmDbDir");
        File metaDir = new File(testDir, "metaDir");
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.db.dirs", dbDir.getPath());
        conf.set("ozone.metadata.dirs", metaDir.getPath());
        try {
            Assert.assertEquals((Object)dbDir, (Object)ServerUtils.getScmDbDir((ConfigurationSource)conf));
            Assert.assertTrue((boolean)dbDir.exists());
        }
        finally {
            FileUtils.deleteQuietly((File)dbDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetScmDbDirWithFallback() {
        File testDir = PathUtils.getTestDir(TestHddsServerUtils.class);
        File metaDir = new File(testDir, "metaDir");
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.metadata.dirs", metaDir.getPath());
        try {
            Assert.assertEquals((Object)metaDir, (Object)ServerUtils.getScmDbDir((ConfigurationSource)conf));
            Assert.assertTrue((boolean)metaDir.exists());
        }
        finally {
            FileUtils.deleteQuietly((File)metaDir);
        }
    }

    @Test
    public void testNoScmDbDirConfigured() {
        this.thrown.expect(IllegalArgumentException.class);
        ServerUtils.getScmDbDir((ConfigurationSource)new OzoneConfiguration());
    }

    @Test
    public void testGetStaleNodeInterval() {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.setTimeDuration("ozone.scm.stale.node.interval", 300L, TimeUnit.SECONDS);
        conf.setInt("ozone.scm.heartbeat.thread.interval", 100);
        Assert.assertEquals((long)100000L, (long)HddsServerUtil.getStaleNodeInterval((ConfigurationSource)conf));
        conf.setTimeDuration("ozone.scm.stale.node.interval", 10L, TimeUnit.MILLISECONDS);
        conf.setInt("ozone.scm.heartbeat.thread.interval", 100);
        Assert.assertEquals((long)90000L, (long)HddsServerUtil.getStaleNodeInterval((ConfigurationSource)conf));
    }
}

