/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.net.InetSocketAddress;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.Timeout;

public class TestHddsServerUtil {
    @Rule
    public Timeout timeout = new Timeout(300000);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMissingScmDataNodeAddress() {
        OzoneConfiguration conf = new OzoneConfiguration();
        this.thrown.expect(IllegalArgumentException.class);
        HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
    }

    @Test
    public void testGetScmDataNodeAddress() {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.client.address", "1.2.3.4");
        InetSocketAddress addr = HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"1.2.3.4"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)9861));
        conf.set("ozone.scm.client.address", "1.2.3.4:100");
        addr = HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"1.2.3.4"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)9861));
        conf.set("ozone.scm.client.address", "1.2.3.4:100");
        conf.set("ozone.scm.datanode.address", "5.6.7.8");
        addr = HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"5.6.7.8"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)9861));
        conf.set("ozone.scm.client.address", "1.2.3.4:100");
        conf.set("ozone.scm.datanode.address", "5.6.7.8:200");
        addr = HddsServerUtil.getScmAddressForDataNodes((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"5.6.7.8"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)200));
    }

    @Test
    public void testScmClientBindHostDefault() {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.client.address", "1.2.3.4");
        InetSocketAddress addr = HddsServerUtil.getScmClientBindAddress((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"0.0.0.0"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)9860));
        conf.set("ozone.scm.client.address", "1.2.3.4:100");
        conf.set("ozone.scm.datanode.address", "1.2.3.4:200");
        addr = HddsServerUtil.getScmClientBindAddress((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"0.0.0.0"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)100));
        conf.set("ozone.scm.client.address", "1.2.3.4");
        conf.set("ozone.scm.datanode.address", "1.2.3.4");
        conf.set("ozone.scm.client.bind.host", "5.6.7.8");
        addr = HddsServerUtil.getScmClientBindAddress((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"5.6.7.8"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)9860));
        conf.set("ozone.scm.client.address", "1.2.3.4:100");
        conf.set("ozone.scm.datanode.address", "1.2.3.4:200");
        conf.set("ozone.scm.client.bind.host", "5.6.7.8");
        addr = HddsServerUtil.getScmClientBindAddress((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"5.6.7.8"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)100));
    }

    @Test
    public void testScmDataNodeBindHostDefault() {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.scm.client.address", "1.2.3.4");
        InetSocketAddress addr = HddsServerUtil.getScmDataNodeBindAddress((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"0.0.0.0"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)9861));
        conf.set("ozone.scm.client.address", "1.2.3.4:100");
        conf.set("ozone.scm.datanode.address", "1.2.3.4:200");
        addr = HddsServerUtil.getScmDataNodeBindAddress((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"0.0.0.0"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)200));
        conf.set("ozone.scm.client.address", "1.2.3.4:100");
        conf.set("ozone.scm.datanode.address", "1.2.3.4");
        conf.set("ozone.scm.datanode.bind.host", "5.6.7.8");
        addr = HddsServerUtil.getScmDataNodeBindAddress((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"5.6.7.8"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)9861));
        conf.set("ozone.scm.client.address", "1.2.3.4:100");
        conf.set("ozone.scm.datanode.address", "1.2.3.4:200");
        conf.set("ozone.scm.datanode.bind.host", "5.6.7.8");
        addr = HddsServerUtil.getScmDataNodeBindAddress((ConfigurationSource)conf);
        Assert.assertThat((Object)addr.getHostString(), (Matcher)Is.is((Object)"5.6.7.8"));
        Assert.assertThat((Object)addr.getPort(), (Matcher)Is.is((Object)200));
    }
}

