/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.lang.reflect.Field;

public final class HddsWhiteboxTestUtils {
    private HddsWhiteboxTestUtils() {
    }

    public static Object getInternalState(Object target, String field) {
        Class<?> c = target.getClass();
        try {
            Field f = HddsWhiteboxTestUtils.getFieldFromHierarchy(c, field);
            f.setAccessible(true);
            return f.get(target);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set internal state on a private field.", e);
        }
    }

    public static void setInternalState(Object target, String field, Object value) {
        Class<?> c = target.getClass();
        try {
            Field f = HddsWhiteboxTestUtils.getFieldFromHierarchy(c, field);
            f.setAccessible(true);
            f.set(target, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set internal state on a private field.", e);
        }
    }

    private static Field getFieldFromHierarchy(Class<?> clazz, String field) {
        Field f = HddsWhiteboxTestUtils.getField(clazz, field);
        while (f == null && clazz != Object.class) {
            clazz = clazz.getSuperclass();
            f = HddsWhiteboxTestUtils.getField(clazz, field);
        }
        if (f == null) {
            throw new RuntimeException("You want me to set value to this field: '" + field + "' on this class: '" + clazz.getSimpleName() + "' but this field is not declared within hierarchy of this class!");
        }
        return f;
    }

    private static Field getField(Class<?> clazz, String field) {
        try {
            return clazz.getDeclaredField(field);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

