/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.security.authentication.client.AuthenticationException;

public final class HddsTestUtils {
    private HddsTestUtils() {
    }

    public static SCMDatanodeProtocolServer.NodeRegistrationContainerReport createNodeRegistrationContainerReport(int numOfContainers) {
        return new SCMDatanodeProtocolServer.NodeRegistrationContainerReport(MockDatanodeDetails.randomDatanodeDetails(), TestUtils.getRandomContainerReports(numOfContainers));
    }

    public static SCMDatanodeProtocolServer.NodeRegistrationContainerReport createNodeRegistrationContainerReport(List<ContainerInfo> dnContainers) {
        ArrayList<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> containers = new ArrayList<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto>();
        dnContainers.forEach(c -> containers.add(TestUtils.getRandomContainerInfo(c.getContainerID())));
        return new SCMDatanodeProtocolServer.NodeRegistrationContainerReport(MockDatanodeDetails.randomDatanodeDetails(), TestUtils.getContainerReports(containers));
    }

    public static StorageContainerManager getScm(OzoneConfiguration conf) throws IOException, AuthenticationException {
        conf.set("ozone.scm.client.address", "127.0.0.1:0");
        conf.set("ozone.scm.block.client.address", "127.0.0.1:0");
        conf.set("ozone.scm.datanode.address", "127.0.0.1:0");
        conf.set("ozone.scm.http-address", "127.0.0.1:0");
        SCMStorageConfig scmStore = new SCMStorageConfig(conf);
        if (scmStore.getState() != Storage.StorageState.INITIALIZED) {
            String clusterId = UUID.randomUUID().toString();
            String scmId = UUID.randomUUID().toString();
            scmStore.setClusterId(clusterId);
            scmStore.setScmId(scmId);
            scmStore.initialize();
        }
        return StorageContainerManager.createSCM((OzoneConfiguration)conf);
    }

    public static List<ContainerInfo> getContainerInfo(int numContainers) {
        ArrayList<ContainerInfo> containerInfoList = new ArrayList<ContainerInfo>();
        for (int i = 0; i < numContainers; ++i) {
            ContainerInfo.Builder builder = new ContainerInfo.Builder();
            containerInfoList.add(builder.setContainerID(RandomUtils.nextLong()).build());
        }
        return containerInfoList;
    }
}

