/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.events;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventExecutor;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.SingleThreadExecutor;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventQueue
implements EventPublisher,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(EventQueue.class);
    private static final String EXECUTOR_NAME_SEPARATOR = "For";
    private final Map<Event, Map<EventExecutor, List<EventHandler>>> executors = new HashMap<Event, Map<EventExecutor, List<EventHandler>>>();
    private final AtomicLong queuedCount = new AtomicLong(0L);
    private final AtomicLong eventCount = new AtomicLong(0L);
    private boolean isRunning = true;

    public <PAYLOAD, EVENT_TYPE extends Event<PAYLOAD>> void addHandler(EVENT_TYPE event, EventHandler<PAYLOAD> handler) {
        this.addHandler(event, handler, this.generateHandlerName(handler));
    }

    public <PAYLOAD, EVENT_TYPE extends Event<PAYLOAD>> void addHandler(EVENT_TYPE event, EventHandler<PAYLOAD> handler, String handlerName) {
        this.validateEvent(event);
        Preconditions.checkNotNull(handler, (Object)"Handler name should not be null.");
        String executorName = StringUtils.camelize((String)event.getName()) + EXECUTOR_NAME_SEPARATOR + handlerName;
        this.addHandler(event, new SingleThreadExecutor(executorName), handler);
    }

    private <EVENT_TYPE extends Event<?>> void validateEvent(EVENT_TYPE event) {
        Preconditions.checkArgument((!event.getName().contains(EXECUTOR_NAME_SEPARATOR) ? 1 : 0) != 0, (Object)"Event name should not contain For string.");
    }

    private <PAYLOAD> String generateHandlerName(EventHandler<PAYLOAD> handler) {
        if (!"".equals(handler.getClass().getSimpleName())) {
            return handler.getClass().getSimpleName();
        }
        return handler.getClass().getName();
    }

    public <PAYLOAD, EVENT_TYPE extends Event<PAYLOAD>> void addHandler(EVENT_TYPE event, EventExecutor<PAYLOAD> executor, EventHandler<PAYLOAD> handler) {
        if (!this.isRunning) {
            LOG.warn("Not adding handler for {}, EventQueue is not running", event);
            return;
        }
        this.validateEvent(event);
        this.executors.putIfAbsent(event, new HashMap());
        this.executors.get(event).putIfAbsent(executor, new ArrayList());
        this.executors.get(event).get(executor).add(handler);
    }

    @Override
    public <PAYLOAD, EVENT_TYPE extends Event<PAYLOAD>> void fireEvent(EVENT_TYPE event, PAYLOAD payload) {
        if (!this.isRunning) {
            LOG.warn("Processing of {} is skipped, EventQueue is not running", event);
            return;
        }
        Map<EventExecutor, List<EventHandler>> eventExecutorListMap = this.executors.get(event);
        this.eventCount.incrementAndGet();
        if (eventExecutorListMap != null) {
            for (Map.Entry<EventExecutor, List<EventHandler>> executorAndHandlers : eventExecutorListMap.entrySet()) {
                for (EventHandler handler : executorAndHandlers.getValue()) {
                    this.queuedCount.incrementAndGet();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Delivering event {} to executor/handler {}: {}", new Object[]{event.getName(), executorAndHandlers.getKey().getName(), payload});
                    }
                    executorAndHandlers.getKey().onMessage(handler, payload, this);
                }
            }
        } else {
            LOG.warn("No event handler registered for event " + event);
        }
    }

    @VisibleForTesting
    public void processAll(long timeout) {
        long processed;
        long currentTime = Time.now();
        do {
            if (!this.isRunning) {
                LOG.warn("Processing of event skipped. EventQueue is not running");
                return;
            }
            processed = 0L;
            Stream allExecutor = this.executors.values().stream().flatMap(handlerMap -> handlerMap.keySet().stream());
            boolean allIdle = allExecutor.allMatch(executor -> executor.queuedEvents() == executor.successfulEvents() + executor.failedEvents());
            if (allIdle) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted exception while sleeping.", (Throwable)e);
            }
        } while (Time.now() <= currentTime + timeout);
        throw new AssertionError((Object)("Messages are not processed in the given timeframe. Queued: " + this.queuedCount.get() + " Processed: " + processed));
    }

    @Override
    public void close() {
        this.isRunning = false;
        Set<EventExecutor> allExecutors = this.executors.values().stream().flatMap(handlerMap -> handlerMap.keySet().stream()).collect(Collectors.toSet());
        allExecutors.forEach(executor -> {
            try {
                executor.close();
            }
            catch (Exception ex) {
                LOG.error("Can't close the executor " + executor.getName(), (Throwable)ex);
            }
        });
    }
}

