/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ipc.RPC;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServerUtils.class);

    private ServerUtils() {
    }

    public static long sanitizeUserArgs(String key, long valueTocheck, String baseKey, long baseValue, long minFactor, long maxFactor) {
        long minLimit = baseValue * minFactor;
        long maxLimit = baseValue * maxFactor;
        if (valueTocheck < minLimit) {
            LOG.warn("{} value = {} is smaller than min = {} based on the key value of {}, reset to the min value {}.", new Object[]{key, valueTocheck, minLimit, baseKey, minLimit});
            valueTocheck = minLimit;
        } else if (valueTocheck > maxLimit) {
            LOG.warn("{} value = {} is larger than max = {} based on the key value of {}, reset to the max value {}.", new Object[]{key, valueTocheck, maxLimit, baseKey, maxLimit});
            valueTocheck = maxLimit;
        }
        return valueTocheck;
    }

    public static InetSocketAddress updateRPCListenAddress(OzoneConfiguration conf, String rpcAddressKey, InetSocketAddress addr, RPC.Server rpcServer) {
        return ServerUtils.updateListenAddress(conf, rpcAddressKey, addr, rpcServer.getListenerAddress());
    }

    public static InetSocketAddress updateListenAddress(OzoneConfiguration conf, String addressKey, InetSocketAddress addr, InetSocketAddress listenAddr) {
        InetSocketAddress updatedAddr = new InetSocketAddress(addr.getHostString(), listenAddr.getPort());
        conf.set(addressKey, addr.getHostString() + ":" + listenAddr.getPort());
        return updatedAddr;
    }

    public static void releaseConnection(HttpRequestBase request) {
        if (request != null) {
            request.releaseConnection();
        }
    }

    public static File getScmDbDir(Configuration conf) {
        File metadataDir = ServerUtils.getDirectoryFromConfig(conf, "ozone.scm.db.dirs", "SCM");
        if (metadataDir != null) {
            return metadataDir;
        }
        LOG.warn("{} is not configured. We recommend adding this setting. Falling back to {} instead.", (Object)"ozone.scm.db.dirs", (Object)"ozone.metadata.dirs");
        return ServerUtils.getOzoneMetaDirPath(conf);
    }

    public static File getDirectoryFromConfig(Configuration conf, String key, String componentName) {
        Collection metadirs = conf.getTrimmedStringCollection(key);
        if (metadirs.size() > 1) {
            throw new IllegalArgumentException("Bad config setting " + key + ". " + componentName + " does not support multiple metadata dirs currently");
        }
        if (metadirs.size() == 1) {
            File dbDirPath = new File((String)metadirs.iterator().next());
            if (!dbDirPath.exists() && !dbDirPath.mkdirs()) {
                throw new IllegalArgumentException("Unable to create directory " + dbDirPath + " specified in configuration setting " + key);
            }
            return dbDirPath;
        }
        return null;
    }

    public static File getOzoneMetaDirPath(Configuration conf) {
        File dirPath = ServerUtils.getDirectoryFromConfig(conf, "ozone.metadata.dirs", "Ozone");
        if (dirPath == null) {
            throw new IllegalArgumentException("ozone.metadata.dirs must be defined.");
        }
        return dirPath;
    }

    public static void setOzoneMetaDirPath(OzoneConfiguration conf, String path) {
        conf.set("ozone.metadata.dirs", path);
    }

    public static File getDBPath(Configuration conf, String key) {
        File dbDirPath = ServerUtils.getDirectoryFromConfig(conf, key, "OM");
        if (dbDirPath != null) {
            return dbDirPath;
        }
        LOG.warn("{} is not configured. We recommend adding this setting. Falling back to {} instead.", (Object)key, (Object)"ozone.metadata.dirs");
        return ServerUtils.getOzoneMetaDirPath(conf);
    }
}

