/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricType;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;

public class PrometheusMetricsSink
implements MetricsSink {
    private Map<String, String> metricLines = new HashMap<String, String>();
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!(^|[A-Z_]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
    private static final Pattern REPLACE_PATTERN = Pattern.compile("[^a-zA-Z0-9]+");

    public void putMetrics(MetricsRecord metricsRecord) {
        for (AbstractMetric metrics : metricsRecord.metrics()) {
            if (metrics.type() != MetricType.COUNTER && metrics.type() != MetricType.GAUGE) continue;
            String key = this.prometheusName(metricsRecord.name(), metrics.name());
            StringBuilder builder = new StringBuilder();
            builder.append("# TYPE " + key + " " + metrics.type().toString().toLowerCase() + "\n");
            builder.append(key + "{");
            String sep = "";
            for (MetricsTag tag : metricsRecord.tags()) {
                String tagName = tag.name().toLowerCase();
                if (tagName.equals("numopenconnectionsperuser")) continue;
                builder.append(sep + tagName + "=\"" + tag.value() + "\"");
                sep = ",";
            }
            builder.append("} ");
            builder.append(metrics.value());
            this.metricLines.put(key, builder.toString());
        }
    }

    public String prometheusName(String recordName, String metricName) {
        if (StringUtils.isNotEmpty((CharSequence)recordName) && recordName.startsWith("Rocksdb_")) {
            return recordName.toLowerCase() + "_" + metricName.toLowerCase();
        }
        String baseName = StringUtils.capitalize((String)recordName) + StringUtils.capitalize((String)metricName);
        CharSequence[] parts = SPLIT_PATTERN.split(baseName);
        String result = String.join((CharSequence)"_", parts).toLowerCase();
        return REPLACE_PATTERN.matcher(result).replaceAll("_");
    }

    public void flush() {
    }

    public void init(SubsetConfiguration subsetConfiguration) {
    }

    public void writeMetrics(Writer writer) throws IOException {
        for (String line : this.metricLines.values()) {
            writer.write(line + "\n");
        }
    }
}

