/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lease;

import java.util.HashMap;
import org.apache.hadoop.ozone.lease.Lease;
import org.apache.hadoop.ozone.lease.LeaseAlreadyExistException;
import org.apache.hadoop.ozone.lease.LeaseException;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.lease.LeaseNotFoundException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestLeaseManager {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testLeaseAcquireAndRelease() throws LeaseException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Lease leaseTwo = manager.acquire((Object)resourceTwo);
        Lease leaseThree = manager.acquire((Object)resourceThree);
        Assert.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assert.assertEquals((Object)leaseTwo, (Object)manager.get((Object)resourceTwo));
        Assert.assertEquals((Object)leaseThree, (Object)manager.get((Object)resourceThree));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        Assert.assertFalse((boolean)leaseTwo.hasExpired());
        Assert.assertFalse((boolean)leaseThree.hasExpired());
        manager.release((Object)resourceOne);
        manager.release((Object)resourceTwo);
        manager.release((Object)resourceThree);
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        Assert.assertTrue((boolean)leaseTwo.hasExpired());
        Assert.assertTrue((boolean)leaseThree.hasExpired());
        manager.shutdown();
    }

    @Test
    public void testLeaseAlreadyExist() throws LeaseException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Lease leaseTwo = manager.acquire((Object)resourceTwo);
        Assert.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assert.assertEquals((Object)leaseTwo, (Object)manager.get((Object)resourceTwo));
        this.exception.expect(LeaseAlreadyExistException.class);
        this.exception.expectMessage("Resource: " + resourceOne);
        manager.acquire((Object)resourceOne);
        manager.release((Object)resourceOne);
        manager.release((Object)resourceTwo);
        manager.shutdown();
    }

    @Test
    public void testLeaseNotFound() throws LeaseException, InterruptedException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        this.exception.expect(LeaseNotFoundException.class);
        this.exception.expectMessage("Resource: " + resourceOne);
        manager.get((Object)resourceOne);
        Lease leaseTwo = manager.acquire((Object)resourceTwo);
        Assert.assertEquals((Object)leaseTwo, (Object)manager.get((Object)resourceTwo));
        Assert.assertFalse((boolean)leaseTwo.hasExpired());
        manager.release((Object)resourceTwo);
        Assert.assertTrue((boolean)leaseTwo.hasExpired());
        this.exception.expect(LeaseNotFoundException.class);
        this.exception.expectMessage("Resource: " + resourceTwo);
        manager.get((Object)resourceTwo);
        Lease leaseThree = manager.acquire((Object)resourceThree);
        Assert.assertEquals((Object)leaseThree, (Object)manager.get((Object)resourceThree));
        Assert.assertFalse((boolean)leaseThree.hasExpired());
        long sleepTime = leaseThree.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assert.assertTrue((boolean)leaseThree.hasExpired());
        this.exception.expect(LeaseNotFoundException.class);
        this.exception.expectMessage("Resource: " + resourceThree);
        manager.get((Object)resourceThree);
        manager.shutdown();
    }

    @Test
    public void testCustomLeaseTimeout() throws LeaseException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Lease leaseTwo = manager.acquire((Object)resourceTwo, 10000L);
        Lease leaseThree = manager.acquire((Object)resourceThree, 50000L);
        Assert.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assert.assertEquals((Object)leaseTwo, (Object)manager.get((Object)resourceTwo));
        Assert.assertEquals((Object)leaseThree, (Object)manager.get((Object)resourceThree));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        Assert.assertFalse((boolean)leaseTwo.hasExpired());
        Assert.assertFalse((boolean)leaseThree.hasExpired());
        Assert.assertEquals((long)5000L, (long)leaseOne.getLeaseLifeTime());
        Assert.assertEquals((long)10000L, (long)leaseTwo.getLeaseLifeTime());
        Assert.assertEquals((long)50000L, (long)leaseThree.getLeaseLifeTime());
        manager.shutdown();
    }

    @Test
    public void testLeaseCallback() throws LeaseException, InterruptedException {
        HashMap<DummyResource, String> leaseStatus = new HashMap<DummyResource, String>();
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        leaseStatus.put(resourceOne, "lease in use");
        leaseOne.registerCallBack(() -> {
            leaseStatus.put(resourceOne, "lease expired");
            return null;
        });
        long sleepTime = leaseOne.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        this.exception.expect(LeaseNotFoundException.class);
        this.exception.expectMessage("Resource: " + resourceOne);
        manager.get((Object)resourceOne);
        Assert.assertEquals((Object)"lease expired", leaseStatus.get(resourceOne));
    }

    @Test
    public void testCallbackExecutionInCaseOfLeaseRelease() throws LeaseException, InterruptedException {
        HashMap<DummyResource, String> leaseStatus = new HashMap<DummyResource, String>();
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        leaseStatus.put(resourceOne, "lease in use");
        leaseOne.registerCallBack(() -> {
            leaseStatus.put(resourceOne, "lease expired");
            return null;
        });
        leaseStatus.put(resourceOne, "lease released");
        manager.release((Object)resourceOne);
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        this.exception.expect(LeaseNotFoundException.class);
        this.exception.expectMessage("Resource: " + resourceOne);
        manager.get((Object)resourceOne);
        Assert.assertEquals((Object)"lease released", leaseStatus.get(resourceOne));
    }

    @Test
    public void testLeaseCallbackWithMultipleLeases() throws LeaseException, InterruptedException {
        HashMap<DummyResource, String> leaseStatus = new HashMap<DummyResource, String>();
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        DummyResource resourceFour = new DummyResource("four");
        DummyResource resourceFive = new DummyResource("five");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Lease leaseTwo = manager.acquire((Object)resourceTwo);
        Lease leaseThree = manager.acquire((Object)resourceThree);
        Lease leaseFour = manager.acquire((Object)resourceFour);
        Lease leaseFive = manager.acquire((Object)resourceFive);
        leaseStatus.put(resourceOne, "lease in use");
        leaseStatus.put(resourceTwo, "lease in use");
        leaseStatus.put(resourceThree, "lease in use");
        leaseStatus.put(resourceFour, "lease in use");
        leaseStatus.put(resourceFive, "lease in use");
        leaseOne.registerCallBack(() -> {
            leaseStatus.put(resourceOne, "lease expired");
            return null;
        });
        leaseTwo.registerCallBack(() -> {
            leaseStatus.put(resourceTwo, "lease expired");
            return null;
        });
        leaseThree.registerCallBack(() -> {
            leaseStatus.put(resourceThree, "lease expired");
            return null;
        });
        leaseFour.registerCallBack(() -> {
            leaseStatus.put(resourceFour, "lease expired");
            return null;
        });
        leaseFive.registerCallBack(() -> {
            leaseStatus.put(resourceFive, "lease expired");
            return null;
        });
        leaseStatus.put(resourceOne, "lease released");
        manager.release((Object)resourceOne);
        leaseStatus.put(resourceTwo, "lease released");
        manager.release((Object)resourceTwo);
        leaseStatus.put(resourceThree, "lease released");
        manager.release((Object)resourceThree);
        long sleepTime = leaseFive.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        Assert.assertTrue((boolean)leaseTwo.hasExpired());
        Assert.assertTrue((boolean)leaseThree.hasExpired());
        Assert.assertTrue((boolean)leaseFour.hasExpired());
        Assert.assertTrue((boolean)leaseFive.hasExpired());
        Assert.assertEquals((Object)"lease released", leaseStatus.get(resourceOne));
        Assert.assertEquals((Object)"lease released", leaseStatus.get(resourceTwo));
        Assert.assertEquals((Object)"lease released", leaseStatus.get(resourceThree));
        Assert.assertEquals((Object)"lease expired", leaseStatus.get(resourceFour));
        Assert.assertEquals((Object)"lease expired", leaseStatus.get(resourceFive));
        manager.shutdown();
    }

    @Test
    public void testReuseReleasedLease() throws LeaseException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Assert.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        manager.release((Object)resourceOne);
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        Lease sameResourceLease = manager.acquire((Object)resourceOne);
        Assert.assertEquals((Object)sameResourceLease, (Object)manager.get((Object)resourceOne));
        Assert.assertFalse((boolean)sameResourceLease.hasExpired());
        manager.release((Object)resourceOne);
        Assert.assertTrue((boolean)sameResourceLease.hasExpired());
        manager.shutdown();
    }

    @Test
    public void testReuseTimedOutLease() throws LeaseException, InterruptedException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Assert.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        long sleepTime = leaseOne.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        Lease sameResourceLease = manager.acquire((Object)resourceOne);
        Assert.assertEquals((Object)sameResourceLease, (Object)manager.get((Object)resourceOne));
        Assert.assertFalse((boolean)sameResourceLease.hasExpired());
        manager.release((Object)resourceOne);
        Assert.assertTrue((boolean)sameResourceLease.hasExpired());
        manager.shutdown();
    }

    @Test
    public void testRenewLease() throws LeaseException, InterruptedException {
        LeaseManager manager = new LeaseManager("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease leaseOne = manager.acquire((Object)resourceOne);
        Assert.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        leaseOne.renew(5000L);
        Thread.sleep(5000L);
        Assert.assertEquals((Object)leaseOne, (Object)manager.get((Object)resourceOne));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        manager.release((Object)resourceOne);
        manager.shutdown();
    }

    private static final class DummyResource {
        private final String name;

        private DummyResource(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof DummyResource) {
                return this.name.equals(((DummyResource)obj).name);
            }
            return false;
        }

        public String toString() {
            return "DummyResource{name='" + this.name + '\'' + '}';
        }
    }
}

