/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.collections.SetUtils;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.common.statemachine.StateMachine;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestStateMachine {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testStateMachineStates() throws InvalidStateTransitionException {
        HashSet<STATES> finals = new HashSet<STATES>();
        finals.add(STATES.FINAL);
        StateMachine stateMachine = new StateMachine((Enum)STATES.INIT, finals);
        stateMachine.addTransition((Enum)STATES.INIT, (Enum)STATES.CREATING, (Enum)EVENTS.ALLOCATE);
        stateMachine.addTransition((Enum)STATES.CREATING, (Enum)STATES.OPERATIONAL, (Enum)EVENTS.CREATE);
        stateMachine.addTransition((Enum)STATES.OPERATIONAL, (Enum)STATES.OPERATIONAL, (Enum)EVENTS.UPDATE);
        stateMachine.addTransition((Enum)STATES.OPERATIONAL, (Enum)STATES.CLEANUP, (Enum)EVENTS.DELETE);
        stateMachine.addTransition((Enum)STATES.OPERATIONAL, (Enum)STATES.CLOSED, (Enum)EVENTS.CLOSE);
        stateMachine.addTransition((Enum)STATES.CREATING, (Enum)STATES.CLEANUP, (Enum)EVENTS.TIMEOUT);
        Assert.assertEquals((String)"Initial State", (Object)((Object)STATES.INIT), (Object)stateMachine.getInitialState());
        Assert.assertTrue((String)"Final States", (boolean)SetUtils.isEqualSet(finals, (Collection)stateMachine.getFinalStates()));
        Assert.assertEquals((String)"STATE should be OPERATIONAL after being created", (Object)((Object)STATES.OPERATIONAL), (Object)stateMachine.getNextState((Enum)STATES.CREATING, (Enum)EVENTS.CREATE));
        Assert.assertEquals((String)"STATE should be OPERATIONAL after being updated", (Object)((Object)STATES.OPERATIONAL), (Object)stateMachine.getNextState((Enum)STATES.OPERATIONAL, (Enum)EVENTS.UPDATE));
        Assert.assertEquals((String)"STATE should be CLEANUP after being deleted", (Object)((Object)STATES.CLEANUP), (Object)stateMachine.getNextState((Enum)STATES.OPERATIONAL, (Enum)EVENTS.DELETE));
        Assert.assertEquals((String)"STATE should be CLEANUP after being timeout", (Object)((Object)STATES.CLEANUP), (Object)stateMachine.getNextState((Enum)STATES.CREATING, (Enum)EVENTS.TIMEOUT));
        Assert.assertEquals((String)"STATE should be CLOSED after being closed", (Object)((Object)STATES.CLOSED), (Object)stateMachine.getNextState((Enum)STATES.OPERATIONAL, (Enum)EVENTS.CLOSE));
        this.expectException();
        stateMachine.getNextState((Enum)STATES.OPERATIONAL, (Enum)EVENTS.CREATE);
        this.expectException();
        stateMachine.getNextState((Enum)STATES.CREATING, (Enum)EVENTS.CLOSE);
    }

    private void expectException() {
        this.exception.expect(InvalidStateTransitionException.class);
        this.exception.expectMessage("Invalid event");
    }

    public static enum EVENTS {
        ALLOCATE,
        CREATE,
        UPDATE,
        CLOSE,
        DELETE,
        TIMEOUT;

    }

    public static enum STATES {
        INIT,
        CREATING,
        OPERATIONAL,
        CLOSED,
        CLEANUP,
        FINAL;

    }
}

