/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hdds.utils.MockGatheringChannel;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestChunkBuffer {
    private static int nextInt(int n) {
        return ThreadLocalRandom.current().nextInt(n);
    }

    @Test(timeout=1000L)
    public void testImplWithByteBuffer() {
        TestChunkBuffer.runTestImplWithByteBuffer(1);
        TestChunkBuffer.runTestImplWithByteBuffer(1024);
        for (int i = 0; i < 10; ++i) {
            TestChunkBuffer.runTestImplWithByteBuffer(TestChunkBuffer.nextInt(100) + 1);
        }
    }

    private static void runTestImplWithByteBuffer(int n) {
        byte[] expected = new byte[n];
        ThreadLocalRandom.current().nextBytes(expected);
        TestChunkBuffer.runTestImpl(expected, 0, ChunkBuffer.allocate((int)n));
    }

    @Test(timeout=1000L)
    public void testIncrementalChunkBuffer() {
        TestChunkBuffer.runTestIncrementalChunkBuffer(1, 1);
        TestChunkBuffer.runTestIncrementalChunkBuffer(4, 8);
        TestChunkBuffer.runTestIncrementalChunkBuffer(16, 1024);
        for (int i = 0; i < 10; ++i) {
            int a = ThreadLocalRandom.current().nextInt(100) + 1;
            int b = ThreadLocalRandom.current().nextInt(100) + 1;
            TestChunkBuffer.runTestIncrementalChunkBuffer(Math.min(a, b), Math.max(a, b));
        }
    }

    private static void runTestIncrementalChunkBuffer(int increment, int n) {
        byte[] expected = new byte[n];
        ThreadLocalRandom.current().nextBytes(expected);
        TestChunkBuffer.runTestImpl(expected, increment, ChunkBuffer.allocate((int)n, (int)increment));
    }

    @Test(timeout=1000L)
    public void testImplWithList() {
        TestChunkBuffer.runTestImplWithList(4, 8);
        TestChunkBuffer.runTestImplWithList(16, 1024);
        for (int i = 0; i < 10; ++i) {
            int a = ThreadLocalRandom.current().nextInt(10) + 1;
            int b = ThreadLocalRandom.current().nextInt(100) + 1;
            TestChunkBuffer.runTestImplWithList(Math.min(a, b), Math.max(a, b));
        }
    }

    private static void runTestImplWithList(int count, int n) {
        byte[] expected = new byte[n];
        ThreadLocalRandom.current().nextBytes(expected);
        int avg = n / count;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(count);
        int offset = 0;
        for (int i = 0; i < count - 1; ++i) {
            int length = ThreadLocalRandom.current().nextInt(avg) + 1;
            buffers.add(ByteBuffer.allocate(length));
            offset += length;
        }
        if (n > offset) {
            buffers.add(ByteBuffer.allocate(n - offset));
        }
        ChunkBuffer impl = ChunkBuffer.wrap(buffers);
        TestChunkBuffer.runTestImpl(expected, -1, impl);
    }

    private static void runTestImpl(byte[] expected, int bpc, ChunkBuffer impl) {
        int n = expected.length;
        System.out.println("n=" + n + ", impl=" + impl);
        Assert.assertEquals((long)0L, (long)impl.position());
        Assert.assertEquals((long)n, (long)impl.remaining());
        Assert.assertEquals((long)n, (long)impl.limit());
        impl.put(expected);
        Assert.assertEquals((long)n, (long)impl.position());
        Assert.assertEquals((long)0L, (long)impl.remaining());
        Assert.assertEquals((long)n, (long)impl.limit());
        TestChunkBuffer.assertDuplicate(expected, impl);
        if (bpc > 0) {
            TestChunkBuffer.assertIterate(expected, impl, bpc);
        } else if (bpc == 0) {
            int bytesPerChecksum;
            int d;
            for (d = 1; d < 5; ++d) {
                bytesPerChecksum = n / d;
                if (bytesPerChecksum <= 0) continue;
                TestChunkBuffer.assertIterate(expected, impl, bytesPerChecksum);
            }
            for (d = 1; d < 10; ++d) {
                bytesPerChecksum = TestChunkBuffer.nextInt(n) + 1;
                TestChunkBuffer.assertIterate(expected, impl, bytesPerChecksum);
            }
        }
        TestChunkBuffer.assertWrite(expected, impl);
    }

    private static void assertDuplicate(byte[] expected, ChunkBuffer impl) {
        int n = expected.length;
        TestChunkBuffer.assertToByteString(expected, 0, n, impl);
        for (int i = 0; i < 10; ++i) {
            int offset = TestChunkBuffer.nextInt(n);
            int length = TestChunkBuffer.nextInt(n - offset + 1);
            TestChunkBuffer.assertToByteString(expected, offset, length, impl);
        }
    }

    private static void assertIterate(byte[] expected, ChunkBuffer impl, int bpc) {
        int n = expected.length;
        ChunkBuffer duplicated = impl.duplicate(0, n);
        Assert.assertEquals((long)0L, (long)duplicated.position());
        Assert.assertEquals((long)n, (long)duplicated.remaining());
        int numChecksums = (n + bpc - 1) / bpc;
        Iterator i = duplicated.iterate(bpc).iterator();
        int count = 0;
        for (int j = 0; j < numChecksums; ++j) {
            ByteBuffer b = (ByteBuffer)i.next();
            int expectedRemaining = j < numChecksums - 1 ? bpc : n - bpc * (numChecksums - 1);
            Assert.assertEquals((long)expectedRemaining, (long)b.remaining());
            int offset = j * bpc;
            for (int k = 0; k < expectedRemaining; ++k) {
                Assert.assertEquals((long)expected[offset + k], (long)b.get());
                ++count;
            }
        }
        Assert.assertEquals((long)n, (long)count);
        Assert.assertFalse((boolean)i.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, i::next);
    }

    private static void assertToByteString(byte[] expected, int offset, int length, ChunkBuffer impl) {
        ChunkBuffer duplicated = impl.duplicate(offset, offset + length);
        Assert.assertEquals((long)offset, (long)duplicated.position());
        Assert.assertEquals((long)length, (long)duplicated.remaining());
        ByteString computed = duplicated.toByteString(buffer -> {
            buffer.mark();
            ByteString string = ByteString.copyFrom((ByteBuffer)buffer);
            buffer.reset();
            return string;
        });
        Assert.assertEquals((long)offset, (long)duplicated.position());
        Assert.assertEquals((long)length, (long)duplicated.remaining());
        TestChunkBuffer.assertEquals("offset=" + offset + ", length=" + length, ByteString.copyFrom((byte[])expected, (int)offset, (int)length), computed);
    }

    private static void assertWrite(byte[] expected, ChunkBuffer impl) {
        impl.rewind();
        Assert.assertEquals((long)0L, (long)impl.position());
        ByteArrayOutputStream output = new ByteArrayOutputStream(expected.length);
        try {
            impl.writeTo((GatheringByteChannel)new MockGatheringChannel(Channels.newChannel(output)));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected error: " + e));
        }
        Assert.assertArrayEquals((byte[])expected, (byte[])output.toByteArray());
        Assert.assertFalse((boolean)impl.hasRemaining());
    }

    private static void assertEquals(String message, ByteString expected, ByteString actual) {
        Assert.assertEquals((String)message, (Object)TestChunkBuffer.toString(expected.toByteArray()), (Object)TestChunkBuffer.toString(actual.toByteArray()));
    }

    private static String toString(byte[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(Character.forDigit(b >> 4 & 0xF, 16)).append(Character.forDigit(b & 0xF, 16)).append(" ");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }
}

