/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipException;
import org.apache.hadoop.hdds.utils.RetriableTask;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestRetriableTask {
    @Test
    public void returnsSuccessfulResult() throws Exception {
        String result = "bilbo";
        RetriableTask task = new RetriableTask(RetryPolicies.RETRY_FOREVER, "test", () -> result);
        Assert.assertEquals((Object)result, (Object)task.call());
    }

    @Test
    public void returnsSuccessfulResultAfterFailures() throws Exception {
        String result = "gandalf";
        AtomicInteger attempts = new AtomicInteger();
        RetriableTask task = new RetriableTask(RetryPolicies.RETRY_FOREVER, "test", () -> {
            if (attempts.incrementAndGet() <= 2) {
                throw new Exception("testing");
            }
            return result;
        });
        Assert.assertEquals((Object)result, (Object)task.call());
    }

    @Test
    public void respectsRetryPolicy() {
        int expectedAttempts = 3;
        AtomicInteger attempts = new AtomicInteger();
        RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)expectedAttempts, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        RetriableTask task = new RetriableTask(retryPolicy, "thr", () -> {
            attempts.incrementAndGet();
            throw new ZipException("testing");
        });
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> ((RetriableTask)task).call());
        Assert.assertEquals(ZipException.class, e.getCause().getClass());
        Assert.assertEquals((long)expectedAttempts, (long)attempts.get());
    }
}

