/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import org.apache.hadoop.hdds.utils.ResourceSemaphore;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceSemaphore {
    @Test(timeout=1000L)
    public void testGroup() {
        ResourceSemaphore.Group g = new ResourceSemaphore.Group(new int[]{3, 1});
        TestResourceSemaphore.assertUsed(g, 0, 0);
        TestResourceSemaphore.assertAcquire(g, true, 1, 1);
        TestResourceSemaphore.assertUsed(g, 1, 1);
        TestResourceSemaphore.assertAcquire(g, false, 1, 1);
        TestResourceSemaphore.assertUsed(g, 1, 1);
        TestResourceSemaphore.assertAcquire(g, false, 0, 1);
        TestResourceSemaphore.assertUsed(g, 1, 1);
        TestResourceSemaphore.assertAcquire(g, true, 1, 0);
        TestResourceSemaphore.assertUsed(g, 2, 1);
        TestResourceSemaphore.assertAcquire(g, true, 1, 0);
        TestResourceSemaphore.assertUsed(g, 3, 1);
        TestResourceSemaphore.assertAcquire(g, false, 1, 0);
        TestResourceSemaphore.assertUsed(g, 3, 1);
        g.release(new int[]{1, 1});
        TestResourceSemaphore.assertUsed(g, 2, 0);
        g.release(new int[]{2, 0});
        TestResourceSemaphore.assertUsed(g, 0, 0);
        g.release(new int[]{0, 0});
        TestResourceSemaphore.assertUsed(g, 0, 0);
        try {
            g.release(new int[]{1, 0});
            Assert.fail((String)"Should have failed.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            g.release(new int[]{0, 1});
            Assert.fail((String)"Should have failed.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static void assertUsed(ResourceSemaphore.Group g, int ... expected) {
        Assert.assertEquals((long)expected.length, (long)g.resourceSize());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)expected[i], (long)g.get(i).used());
        }
    }

    static void assertAcquire(ResourceSemaphore.Group g, boolean expected, int ... permits) {
        boolean computed = g.tryAcquire(permits);
        Assert.assertEquals((Object)expected, (Object)computed);
    }
}

