/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.utils.Cache;
import org.apache.hadoop.hdds.utils.ResourceLimitCache;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceLimitCache {
    @Test
    public void testResourceLimitCache() throws InterruptedException, TimeoutException {
        ResourceLimitCache resourceCache = new ResourceLimitCache(new ConcurrentHashMap(), (k, v) -> new int[]{k}, new int[]{10});
        resourceCache.put((Object)6, (Object)"a");
        resourceCache.put((Object)4, (Object)"a");
        resourceCache.put((Object)4, (Object)"a");
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> TestResourceLimitCache.lambda$testResourceLimitCache$1((Cache)resourceCache));
        Assert.assertTrue((!future.isDone() ? 1 : 0) != 0);
        Thread.sleep(100L);
        Assert.assertTrue((!future.isDone() ? 1 : 0) != 0);
        resourceCache.remove((Object)4);
        GenericTestUtils.waitFor(future::isDone, (int)100, (int)1000);
        Assert.assertTrue((future.isDone() && !future.isCompletedExceptionally() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)resourceCache.get((Object)1));
        future = CompletableFuture.supplyAsync(() -> TestResourceLimitCache.lambda$testResourceLimitCache$2((Cache)resourceCache));
        Assert.assertTrue((!future.isDone() ? 1 : 0) != 0);
        Thread.sleep(100L);
        Assert.assertTrue((!future.isDone() ? 1 : 0) != 0);
        future.cancel(true);
        resourceCache.remove((Object)1);
        Assert.assertNull((Object)resourceCache.get((Object)4));
    }

    private static /* synthetic */ String lambda$testResourceLimitCache$2(Cache resourceCache) {
        try {
            return (String)resourceCache.put((Object)4, (Object)"a");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static /* synthetic */ String lambda$testResourceLimitCache$1(Cache resourceCache) {
        try {
            return (String)resourceCache.put((Object)1, (Object)"a");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

