/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.hdds.scm.net.NodeSchemaLoader;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestYamlSchemaLoader {
    private static final Logger LOG = LoggerFactory.getLogger(TestYamlSchemaLoader.class);
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    @Rule
    public Timeout testTimeout = new Timeout(30000);

    public TestYamlSchemaLoader(String schemaFile, String errMsg) {
        try {
            String filePath = this.classLoader.getResource("./networkTopologyTestFiles/" + schemaFile).getPath();
            NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath);
            Assert.fail((String)"expect exceptions");
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().contains(errMsg));
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getSchemaFiles() {
        Object[][] schemaFiles = new Object[][]{{"multiple-root.yaml", "Multiple root"}, {"middle-leaf.yaml", "Leaf node in the middle"}};
        return Arrays.asList(schemaFiles);
    }

    @Test
    public void testGood() {
        try {
            String filePath = this.classLoader.getResource("./networkTopologyTestFiles/good.yaml").getPath();
            NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath);
        }
        catch (Throwable e) {
            Assert.fail((String)"should succeed");
        }
    }

    @Test
    public void testNotExist() {
        String filePath = this.classLoader.getResource("./networkTopologyTestFiles/good.yaml").getPath() + ".backup";
        try {
            NodeSchemaLoader.getInstance().loadSchemaFromFile(filePath);
            Assert.fail((String)"should fail");
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().contains("not found"));
        }
    }
}

