/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.scm.net.NodeSchemaManager;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNodeSchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestNodeSchemaManager.class);
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private NodeSchemaManager manager;
    private Configuration conf;
    @Rule
    public Timeout testTimeout = new Timeout(30000);

    public TestNodeSchemaManager() {
        this.conf = new Configuration();
        String filePath = this.classLoader.getResource("./networkTopologyTestFiles/good.xml").getPath();
        this.conf.set("ozone.scm.network.topology.schema.file", filePath);
        this.manager = NodeSchemaManager.getInstance();
        this.manager.init(this.conf);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailure1() {
        this.manager.getCost(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailure2() {
        this.manager.getCost(this.manager.getMaxLevel() + 1);
    }

    @Test
    public void testPass() {
        Assert.assertEquals((long)4L, (long)this.manager.getMaxLevel());
        for (int i = 1; i <= this.manager.getMaxLevel(); ++i) {
            Assert.assertTrue((this.manager.getCost(i) == 1 || this.manager.getCost(i) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testInitFailure() {
        String filePath = this.classLoader.getResource("./networkTopologyTestFiles/good.xml").getPath() + ".backup";
        this.conf.set("ozone.scm.network.topology.schema.file", filePath);
        try {
            this.manager.init(this.conf);
            Assert.fail((String)"should fail");
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Failed to load schema file:" + filePath));
        }
    }

    @Test
    public void testComplete() {
        String path = "/node1";
        Assert.assertEquals((Object)("/default-rack/default-nodegroup" + path), (Object)this.manager.complete(path));
        Assert.assertEquals((Object)("/rack/default-nodegroup" + path), (Object)this.manager.complete("/rack" + path));
        Assert.assertEquals((Object)("/default-rack/nodegroup" + path), (Object)this.manager.complete("/nodegroup" + path));
        Assert.assertEquals(null, (Object)this.manager.complete("/dc" + path));
    }
}

