/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.scm.net.InnerNode;
import org.apache.hadoop.hdds.scm.net.NetConstants;
import org.apache.hadoop.hdds.scm.net.NetUtils;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.net.NodeImpl;
import org.apache.hadoop.hdds.scm.net.NodeSchema;
import org.apache.hadoop.hdds.scm.net.NodeSchemaManager;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestNetworkTopologyImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TestNetworkTopologyImpl.class);
    private NetworkTopology cluster;
    private Node[] dataNodes;
    private Random random = new Random();
    @Rule
    public Timeout testTimeout = new Timeout(3000000);

    public TestNetworkTopologyImpl(NodeSchema[] schemas, Node[] nodeArray) {
        NodeSchemaManager.getInstance().init(schemas, true);
        this.cluster = new NetworkTopologyImpl(NodeSchemaManager.getInstance());
        this.dataNodes = nodeArray;
        for (int i = 0; i < this.dataNodes.length; ++i) {
            this.cluster.add(this.dataNodes[i]);
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> setupDatanodes() {
        Object[][] topologies = new Object[][]{{new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.LEAF_SCHEMA}, new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/"), TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/"), TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/"), TestNetworkTopologyImpl.createDatanode("7.7.7.7", "/"), TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/")}}, {new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.LEAF_SCHEMA}, new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/r1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/r1"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/r2"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/r2"), TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/r2"), TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/r3"), TestNetworkTopologyImpl.createDatanode("7.7.7.7", "/r3"), TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/r3")}}, {new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.DATACENTER_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.LEAF_SCHEMA}, new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/d1/r1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/d1/r1"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/d1/r2"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/d1/r2"), TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/d1/r2"), TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/d2/r3"), TestNetworkTopologyImpl.createDatanode("7.7.7.7", "/d2/r3"), TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/d2/r3")}}, {new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.DATACENTER_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.NODEGROUP_SCHEMA, NetConstants.LEAF_SCHEMA}, new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/d1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/d1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/d1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/d1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/d1/r2/ng3"), TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/d2/r3/ng3"), TestNetworkTopologyImpl.createDatanode("7.7.7.7", "/d2/r3/ng3"), TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/d2/r3/ng3"), TestNetworkTopologyImpl.createDatanode("9.9.9.9", "/d3/r1/ng1"), TestNetworkTopologyImpl.createDatanode("10.10.10.10", "/d3/r1/ng1"), TestNetworkTopologyImpl.createDatanode("11.11.11.11", "/d3/r1/ng1"), TestNetworkTopologyImpl.createDatanode("12.12.12.12", "/d3/r2/ng2"), TestNetworkTopologyImpl.createDatanode("13.13.13.13", "/d3/r2/ng2"), TestNetworkTopologyImpl.createDatanode("14.14.14.14", "/d4/r1/ng1"), TestNetworkTopologyImpl.createDatanode("15.15.15.15", "/d4/r1/ng1"), TestNetworkTopologyImpl.createDatanode("16.16.16.16", "/d4/r1/ng1"), TestNetworkTopologyImpl.createDatanode("17.17.17.17", "/d4/r1/ng2"), TestNetworkTopologyImpl.createDatanode("18.18.18.18", "/d4/r1/ng2"), TestNetworkTopologyImpl.createDatanode("19.19.19.19", "/d4/r1/ng3"), TestNetworkTopologyImpl.createDatanode("20.20.20.20", "/d4/r1/ng3")}}, {new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.REGION_SCHEMA, NetConstants.DATACENTER_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.NODEGROUP_SCHEMA, NetConstants.LEAF_SCHEMA}, new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/d1/rg1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/d1/rg1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/d1/rg1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/d1/rg1/r1/ng1"), TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("7.7.7.7", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("9.9.9.9", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("10.10.10.10", "/d1/rg1/r1/ng2"), TestNetworkTopologyImpl.createDatanode("11.11.11.11", "/d1/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("12.12.12.12", "/d1/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("13.13.13.13", "/d1/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("14.14.14.14", "/d1/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("15.15.15.15", "/d1/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("16.16.16.16", "/d1/rg1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("17.17.17.17", "/d1/rg1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("18.18.18.18", "/d1/rg1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("19.19.19.19", "/d1/rg1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("20.20.20.20", "/d1/rg1/r2/ng2"), TestNetworkTopologyImpl.createDatanode("21.21.21.21", "/d2/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("22.22.22.22", "/d2/rg1/r2/ng1"), TestNetworkTopologyImpl.createDatanode("23.23.23.23", "/d2/rg2/r2/ng1"), TestNetworkTopologyImpl.createDatanode("24.24.24.24", "/d2/rg2/r2/ng1"), TestNetworkTopologyImpl.createDatanode("25.25.25.25", "/d2/rg2/r2/ng1")}}};
        return Arrays.asList(topologies);
    }

    @Test
    public void testContains() {
        Node nodeNotInMap = TestNetworkTopologyImpl.createDatanode("8.8.8.8", "/d2/r4");
        for (int i = 0; i < this.dataNodes.length; ++i) {
            Assert.assertTrue((boolean)this.cluster.contains(this.dataNodes[i]));
        }
        Assert.assertFalse((boolean)this.cluster.contains(nodeNotInMap));
    }

    @Test
    public void testNumOfChildren() {
        Assert.assertEquals((long)this.dataNodes.length, (long)this.cluster.getNumOfLeafNode(null));
        Assert.assertEquals((long)0L, (long)this.cluster.getNumOfLeafNode("/switch1/node1"));
    }

    @Test
    public void testGetNode() {
        Assert.assertEquals((Object)this.cluster.getNode(""), (Object)this.cluster.getNode(null));
        Assert.assertEquals((Object)this.cluster.getNode(""), (Object)this.cluster.getNode("/"));
        Assert.assertEquals(null, (Object)this.cluster.getNode("/switch1/node1"));
        Assert.assertEquals(null, (Object)this.cluster.getNode("/switch1"));
    }

    @Test
    public void testCreateInvalidTopology() {
        ArrayList<NodeSchema> schemas = new ArrayList<NodeSchema>();
        schemas.add(NetConstants.ROOT_SCHEMA);
        schemas.add(NetConstants.RACK_SCHEMA);
        schemas.add(NetConstants.LEAF_SCHEMA);
        NodeSchemaManager.getInstance().init(schemas.toArray(new NodeSchema[0]), true);
        NetworkTopologyImpl newCluster = new NetworkTopologyImpl(NodeSchemaManager.getInstance());
        Node[] invalidDataNodes = new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/r1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/r2"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/d1/r2")};
        newCluster.add(invalidDataNodes[0]);
        newCluster.add(invalidDataNodes[1]);
        try {
            newCluster.add(invalidDataNodes[2]);
            Assert.fail((String)"expected InvalidTopologyException");
        }
        catch (NetworkTopology.InvalidTopologyException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Failed to add"));
            Assert.assertTrue((boolean)e.getMessage().contains("Its path depth is not " + newCluster.getMaxLevel()));
        }
    }

    @Test
    public void testInitWithConfigFile() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Configuration conf = new Configuration();
        try {
            String filePath = classLoader.getResource("./networkTopologyTestFiles/good.xml").getPath();
            conf.set("ozone.scm.network.topology.schema.file", filePath);
            NetworkTopologyImpl newCluster = new NetworkTopologyImpl(conf);
            LOG.info("network topology max level = {}", (Object)newCluster.getMaxLevel());
        }
        catch (Throwable e) {
            Assert.fail((String)"should succeed");
        }
    }

    @Test
    public void testAncestor() {
        int maxLevel;
        Assume.assumeTrue((this.cluster.getMaxLevel() > 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.cluster.isSameParent(this.dataNodes[0], this.dataNodes[1]));
        for (maxLevel = this.cluster.getMaxLevel(); maxLevel > 1; --maxLevel) {
            Assert.assertTrue((boolean)this.cluster.isSameAncestor(this.dataNodes[0], this.dataNodes[1], maxLevel - 1));
        }
        Assert.assertFalse((boolean)this.cluster.isSameParent(this.dataNodes[1], this.dataNodes[2]));
        Assert.assertFalse((boolean)this.cluster.isSameParent(null, this.dataNodes[2]));
        Assert.assertFalse((boolean)this.cluster.isSameParent(this.dataNodes[1], null));
        Assert.assertFalse((boolean)this.cluster.isSameParent(null, null));
        Assert.assertFalse((boolean)this.cluster.isSameAncestor(this.dataNodes[1], this.dataNodes[2], 0));
        Assert.assertFalse((boolean)this.cluster.isSameAncestor(this.dataNodes[1], null, 1));
        Assert.assertFalse((boolean)this.cluster.isSameAncestor(null, this.dataNodes[2], 1));
        Assert.assertFalse((boolean)this.cluster.isSameAncestor(null, null, 1));
        maxLevel = this.cluster.getMaxLevel();
        Assert.assertTrue((boolean)this.cluster.isSameAncestor(this.dataNodes[this.random.nextInt(this.cluster.getNumOfLeafNode(null))], this.dataNodes[this.random.nextInt(this.cluster.getNumOfLeafNode(null))], maxLevel - 1));
    }

    @Test
    public void testAddRemove() {
        int i;
        for (i = 0; i < this.dataNodes.length; ++i) {
            this.cluster.remove(this.dataNodes[i]);
        }
        for (i = 0; i < this.dataNodes.length; ++i) {
            Assert.assertFalse((boolean)this.cluster.contains(this.dataNodes[i]));
        }
        Assert.assertEquals((long)0L, (long)this.cluster.getNumOfLeafNode(null));
        Assert.assertEquals((long)0L, (long)this.cluster.getNumOfNodes(2));
        for (i = 0; i < this.dataNodes.length; ++i) {
            this.cluster.add(this.dataNodes[i]);
        }
        Assert.assertTrue((this.cluster.getNumOfNodes(2) > 0 ? 1 : 0) != 0);
        try {
            this.cluster.add((Node)this.cluster.chooseRandom(null).getParent());
            Assert.fail((String)"Inner node can not be added manually");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Not allowed to add an inner node"));
        }
        try {
            this.cluster.remove((Node)this.cluster.chooseRandom(null).getParent());
            Assert.fail((String)"Inner node can not be removed manually");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Not allowed to remove an inner node"));
        }
    }

    @Test
    public void testGetNodesWithLevel() {
        int maxLevel = this.cluster.getMaxLevel();
        try {
            Assert.assertEquals((long)1L, (long)this.cluster.getNumOfNodes(0));
            Assert.fail((String)"level 0 is not supported");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid level"));
        }
        try {
            Assert.assertEquals((long)1L, (long)this.cluster.getNumOfNodes(0));
            Assert.fail((String)"level 0 is not supported");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid level"));
        }
        try {
            Assert.assertEquals((long)1L, (long)this.cluster.getNumOfNodes(maxLevel + 1));
            Assert.fail((String)"level out of scope");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid level"));
        }
        try {
            Assert.assertEquals((long)1L, (long)this.cluster.getNumOfNodes(maxLevel + 1));
            Assert.fail((String)"level out of scope");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid level"));
        }
        Assert.assertEquals((long)1L, (long)this.cluster.getNumOfNodes(1));
        Assert.assertEquals((long)1L, (long)this.cluster.getNumOfNodes(1));
        Assert.assertEquals((long)this.dataNodes.length, (long)this.cluster.getNumOfNodes(maxLevel));
        Assert.assertEquals((long)this.dataNodes.length, (long)this.cluster.getNumOfNodes(maxLevel));
    }

    @Test
    public void testChooseRandomSimple() {
        String path = this.dataNodes[this.random.nextInt(this.dataNodes.length)].getNetworkFullPath();
        Assert.assertEquals((Object)path, (Object)this.cluster.chooseRandom(path).getNetworkFullPath());
        path = path.substring(0, path.lastIndexOf("/"));
        while (!path.equals("")) {
            Assert.assertTrue((boolean)this.cluster.chooseRandom(path).getNetworkLocation().startsWith(path));
            Node node = this.cluster.chooseRandom("~" + path);
            Assert.assertTrue((!node.getNetworkLocation().startsWith(path) ? 1 : 0) != 0);
            path = path.substring(0, path.lastIndexOf("/"));
        }
        Assert.assertNotNull((Object)this.cluster.chooseRandom(null));
        Assert.assertNotNull((Object)this.cluster.chooseRandom(""));
        Assert.assertNotNull((Object)this.cluster.chooseRandom("/"));
        Assert.assertNull((Object)this.cluster.chooseRandom("~"));
        Assert.assertNull((Object)this.cluster.chooseRandom("~/"));
        path = this.dataNodes[this.random.nextInt(this.dataNodes.length)].getNetworkFullPath();
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(path);
        Assert.assertNull((Object)this.cluster.chooseRandom(path, pathList));
        Assert.assertNotNull((Object)this.cluster.chooseRandom(null, pathList));
        Assert.assertNotNull((Object)this.cluster.chooseRandom("", pathList));
        Assert.assertNull((Object)this.cluster.chooseRandom("", Arrays.asList(this.dataNodes)));
        Assert.assertNull((Object)this.cluster.chooseRandom("/", Arrays.asList(this.dataNodes)));
        Assert.assertNull((Object)this.cluster.chooseRandom("~", Arrays.asList(this.dataNodes)));
        Assert.assertNull((Object)this.cluster.chooseRandom("~/", Arrays.asList(this.dataNodes)));
        Assert.assertNull((Object)this.cluster.chooseRandom(null, Arrays.asList(this.dataNodes)));
    }

    @Test
    public void testChooseRandomExcludedScope() {
        Map<Node, Integer> frequency;
        String scope;
        int[] excludedNodeIndexs;
        for (int i : excludedNodeIndexs = new int[]{0, this.dataNodes.length - 1, this.random.nextInt(this.dataNodes.length), this.random.nextInt(this.dataNodes.length)}) {
            String path = this.dataNodes[i].getNetworkFullPath();
            while (!path.equals("")) {
                scope = "~" + path;
                frequency = this.pickNodesAtRandom(100, scope, null, 0);
                for (Node key : this.dataNodes) {
                    if (!key.getNetworkFullPath().startsWith(path)) continue;
                    Assert.assertTrue((frequency.get(key) == 0 ? 1 : 0) != 0);
                }
                path = path.substring(0, path.lastIndexOf("/"));
            }
        }
        frequency = this.pickNodes(100, null, null, null, 0);
        for (Node key : this.dataNodes) {
            Assert.assertTrue((frequency.get(key) != 0 ? 1 : 0) != 0);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        frequency = this.pickNodes(100, arrayList, null, null, 0);
        for (Node key : this.dataNodes) {
            Assert.assertTrue((frequency.get(key) == 0 ? 1 : 0) != 0);
        }
        scope = "~";
        frequency = this.pickNodesAtRandom(100, scope, null, 0);
        for (Node key : this.dataNodes) {
            Assert.assertTrue((frequency.get(key) == 0 ? 1 : 0) != 0);
        }
        arrayList.clear();
        arrayList.add("/city1");
        frequency = this.pickNodes(this.cluster.getNumOfLeafNode(null), arrayList, null, null, 0);
        for (Node key : this.dataNodes) {
            Assert.assertTrue((frequency.get(key) != 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testChooseRandomExcludedNode() {
        int ancestorGen;
        Map<Node, Integer> frequency;
        Node[][] excludedNodeLists = new Node[][]{new Node[0], {this.dataNodes[0]}, {this.dataNodes[this.dataNodes.length - 1]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}};
        int leafNum = this.cluster.getNumOfLeafNode(null);
        for (Node[] list : excludedNodeLists) {
            List<Node> excludedList = Arrays.asList(list);
            for (int ancestorGen2 = 0; ancestorGen2 < this.cluster.getMaxLevel(); ++ancestorGen2) {
                frequency = this.pickNodesAtRandom(leafNum, null, excludedList, ancestorGen2);
                List ancestorList = NetUtils.getAncestorList((NetworkTopology)this.cluster, excludedList, (int)ancestorGen2);
                for (Node key : this.dataNodes) {
                    if (!excludedList.contains(key) && (ancestorList.size() <= 0 || ancestorList.stream().map(a -> (InnerNode)a).filter(a -> a.isAncestor(key)).collect(Collectors.toList()).size() <= 0)) continue;
                    Assert.assertTrue((frequency.get(key) == 0 ? 1 : 0) != 0);
                }
            }
        }
        List<Node> excludedList = Arrays.asList(this.dataNodes);
        for (ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
            frequency = this.pickNodesAtRandom(leafNum, null, excludedList, ancestorGen);
            for (Node key : this.dataNodes) {
                Assert.assertTrue((frequency.get(key) == 0 ? 1 : 0) != 0);
            }
        }
        excludedList = Arrays.asList(TestNetworkTopologyImpl.createDatanode("1.1.1.1.", "/city1/rack1"));
        for (ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
            frequency = this.pickNodes(leafNum, null, excludedList, null, ancestorGen);
            for (Node key : this.dataNodes) {
                Assert.assertTrue((frequency.get(key) != 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testChooseRandomExcludedNodeAndScope() {
        Map<Node, Integer> frequency;
        String scope;
        int[] excludedNodeIndexs = new int[]{0, this.dataNodes.length - 1, this.random.nextInt(this.dataNodes.length), this.random.nextInt(this.dataNodes.length)};
        Node[][] excludedNodeLists = new Node[][]{new Node[0], {this.dataNodes[0]}, {this.dataNodes[this.dataNodes.length - 1]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}};
        int leafNum = this.cluster.getNumOfLeafNode(null);
        for (int i : excludedNodeIndexs) {
            String path = this.dataNodes[i].getNetworkFullPath();
            while (!path.equals("")) {
                scope = "~" + path;
                for (int ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
                    for (Node[] list : excludedNodeLists) {
                        List<Node> excludedList = Arrays.asList(list);
                        frequency = this.pickNodesAtRandom(leafNum, scope, excludedList, ancestorGen);
                        List ancestorList = NetUtils.getAncestorList((NetworkTopology)this.cluster, excludedList, (int)ancestorGen);
                        for (Node key : this.dataNodes) {
                            if (!excludedList.contains(key) && !key.getNetworkFullPath().startsWith(path) && (ancestorList.size() <= 0 || ancestorList.stream().map(a -> (InnerNode)a).filter(a -> a.isAncestor(key)).collect(Collectors.toList()).size() <= 0)) continue;
                            Assert.assertTrue((frequency.get(key) == 0 ? 1 : 0) != 0);
                        }
                    }
                }
                path = path.substring(0, path.lastIndexOf("/"));
            }
        }
        List<Node> excludedList = Arrays.asList(this.dataNodes);
        for (int i : excludedNodeIndexs) {
            String path = this.dataNodes[i].getNetworkFullPath();
            while (!path.equals("")) {
                scope = "~" + path;
                for (int ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
                    frequency = this.pickNodesAtRandom(leafNum, scope, excludedList, ancestorGen);
                    for (Node key : this.dataNodes) {
                        Assert.assertTrue((frequency.get(key) == 0 ? 1 : 0) != 0);
                    }
                }
                path = path.substring(0, path.lastIndexOf("/"));
            }
        }
        for (int ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
            frequency = this.pickNodes(leafNum, null, null, null, ancestorGen);
            for (Node key : this.dataNodes) {
                Assert.assertTrue((frequency.get(key) != 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testChooseRandomWithAffinityNode() {
        Map<Node, Integer> frequency;
        int[] excludedNodeIndexs = new int[]{0, this.dataNodes.length - 1, this.random.nextInt(this.dataNodes.length), this.random.nextInt(this.dataNodes.length)};
        Node[][] excludedNodeLists = new Node[][]{new Node[0], {this.dataNodes[0]}, {this.dataNodes[this.dataNodes.length - 1]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}};
        int[] affinityNodeIndexs = new int[]{0, this.dataNodes.length - 1, this.random.nextInt(this.dataNodes.length), this.random.nextInt(this.dataNodes.length)};
        Node[][] excludedScopeIndexs = new Node[][]{{this.dataNodes[0]}, {this.dataNodes[this.dataNodes.length - 1]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}};
        int leafNum = this.cluster.getNumOfLeafNode(null);
        ArrayList<String> pathList = new ArrayList();
        for (int k : affinityNodeIndexs) {
            Node[][] nodeArrayArray = excludedScopeIndexs;
            int n = nodeArrayArray.length;
            for (int i = 0; i < n; ++i) {
                Node[] excludedScopes = nodeArrayArray[i];
                pathList.clear();
                pathList.addAll(Arrays.stream(excludedScopes).map(node -> node.getNetworkFullPath()).collect(Collectors.toList()));
                while (!((String)pathList.get(0)).equals("")) {
                    for (int ancestorGen = this.cluster.getMaxLevel() - 1; ancestorGen > 0; --ancestorGen) {
                        for (Node[] list : excludedNodeLists) {
                            List<Node> excludedList = Arrays.asList(list);
                            frequency = this.pickNodes(leafNum, pathList, excludedList, this.dataNodes[k], ancestorGen);
                            Node affinityAncestor = this.dataNodes[k].getAncestor(ancestorGen);
                            for (Node key : this.dataNodes) {
                                if (affinityAncestor == null) continue;
                                if (frequency.get(key) > 0) {
                                    Assert.assertTrue((boolean)affinityAncestor.isAncestor(key));
                                    continue;
                                }
                                if (!affinityAncestor.isAncestor(key) || excludedList != null && excludedList.contains(key) || pathList != null && pathList.stream().anyMatch(path -> key.getNetworkFullPath().startsWith((String)path))) continue;
                                Assert.fail((String)("Node is not picked when sequentially going through ancestor node's leaf nodes. node:" + key.getNetworkFullPath() + ", ancestor node:" + affinityAncestor.getNetworkFullPath() + ", excludedScope: " + ((Object)pathList).toString() + ", excludedList:" + (excludedList == null ? "" : excludedList.toString())));
                            }
                        }
                    }
                    pathList = pathList.stream().map(path -> path.substring(0, path.lastIndexOf("/"))).collect(Collectors.toList());
                }
            }
        }
        List<Node> excludedList = Arrays.asList(this.dataNodes);
        for (int k : affinityNodeIndexs) {
            for (int i : excludedNodeIndexs) {
                String path2 = this.dataNodes[i].getNetworkFullPath();
                while (!path2.equals("")) {
                    String scope = "~" + path2;
                    for (int ancestorGen = 0; ancestorGen < this.cluster.getMaxLevel(); ++ancestorGen) {
                        frequency = this.pickNodesAtRandom(leafNum, scope, excludedList, this.dataNodes[k], ancestorGen);
                        for (Node key : this.dataNodes) {
                            Assert.assertTrue((frequency.get(key) == 0 ? 1 : 0) != 0);
                        }
                    }
                    path2 = path2.substring(0, path2.lastIndexOf("/"));
                }
            }
        }
        int ancestorGen = this.cluster.getMaxLevel() - 1;
        for (int k : affinityNodeIndexs) {
            while (ancestorGen > 0) {
                frequency = this.pickNodes(leafNum, null, null, this.dataNodes[k], ancestorGen);
                Node affinityAncestor = this.dataNodes[k].getAncestor(ancestorGen);
                for (Node key : this.dataNodes) {
                    if (frequency.get(key) <= 0 || affinityAncestor == null) continue;
                    Assert.assertTrue((boolean)affinityAncestor.isAncestor(key));
                }
                --ancestorGen;
            }
        }
        try {
            this.cluster.chooseRandom(null, null, null, this.dataNodes[0], this.cluster.getMaxLevel());
            Assert.fail((String)"ancestor generation exceeds max level, should fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("ancestorGen " + this.cluster.getMaxLevel() + " exceeds this network topology acceptable level"));
        }
    }

    @Test
    public void testCost() {
        Node[] nodeList;
        ArrayList<NodeSchema> schemas = new ArrayList<NodeSchema>();
        schemas.add(NetConstants.ROOT_SCHEMA);
        schemas.add(NetConstants.RACK_SCHEMA);
        schemas.add(NetConstants.NODEGROUP_SCHEMA);
        schemas.add(NetConstants.LEAF_SCHEMA);
        NodeSchemaManager manager = NodeSchemaManager.getInstance();
        manager.init(schemas.toArray(new NodeSchema[0]), true);
        NetworkTopologyImpl newCluster = new NetworkTopologyImpl(manager);
        for (Node node : nodeList = new Node[]{TestNetworkTopologyImpl.createDatanode("1.1.1.1", "/r1/ng1"), TestNetworkTopologyImpl.createDatanode("2.2.2.2", "/r1/ng1"), TestNetworkTopologyImpl.createDatanode("3.3.3.3", "/r1/ng2"), TestNetworkTopologyImpl.createDatanode("4.4.4.4", "/r2/ng1")}) {
            newCluster.add(node);
        }
        Node outScopeNode1 = TestNetworkTopologyImpl.createDatanode("5.5.5.5", "/r2/ng2");
        Node outScopeNode2 = TestNetworkTopologyImpl.createDatanode("6.6.6.6", "/r2/ng2");
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)newCluster.getDistanceCost(nodeList[0], null));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)newCluster.getDistanceCost(null, nodeList[0]));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)newCluster.getDistanceCost(outScopeNode1, nodeList[0]));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)newCluster.getDistanceCost(nodeList[0], outScopeNode1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)newCluster.getDistanceCost(outScopeNode1, outScopeNode2));
        Assert.assertEquals((long)0L, (long)newCluster.getDistanceCost(null, null));
        Assert.assertEquals((long)0L, (long)newCluster.getDistanceCost(nodeList[0], nodeList[0]));
        Assert.assertEquals((long)2L, (long)newCluster.getDistanceCost(nodeList[0], nodeList[1]));
        Assert.assertEquals((long)4L, (long)newCluster.getDistanceCost(nodeList[0], nodeList[2]));
        Assert.assertEquals((long)6L, (long)newCluster.getDistanceCost(nodeList[0], nodeList[3]));
        schemas.clear();
        schemas.add(new NodeSchema.Builder().setType(NodeSchema.LayerType.ROOT).setCost(5).build());
        schemas.add(new NodeSchema.Builder().setType(NodeSchema.LayerType.INNER_NODE).setCost(3).build());
        schemas.add(new NodeSchema.Builder().setType(NodeSchema.LayerType.INNER_NODE).setCost(1).build());
        schemas.add(new NodeSchema.Builder().setType(NodeSchema.LayerType.LEAF_NODE).build());
        manager = NodeSchemaManager.getInstance();
        manager.init(schemas.toArray(new NodeSchema[0]), true);
        newCluster = new NetworkTopologyImpl(manager);
        for (Node node : nodeList) {
            newCluster.add(node);
        }
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)newCluster.getDistanceCost(nodeList[0], null));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)newCluster.getDistanceCost(null, nodeList[0]));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)newCluster.getDistanceCost(outScopeNode1, nodeList[0]));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)newCluster.getDistanceCost(nodeList[0], outScopeNode1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)newCluster.getDistanceCost(outScopeNode1, outScopeNode2));
        Assert.assertEquals((long)0L, (long)newCluster.getDistanceCost(null, null));
        Assert.assertEquals((long)0L, (long)newCluster.getDistanceCost(nodeList[0], nodeList[0]));
        Assert.assertEquals((long)2L, (long)newCluster.getDistanceCost(nodeList[0], nodeList[1]));
        Assert.assertEquals((long)8L, (long)newCluster.getDistanceCost(nodeList[0], nodeList[2]));
        Assert.assertEquals((long)18L, (long)newCluster.getDistanceCost(nodeList[0], nodeList[3]));
    }

    @Test
    public void testSortByDistanceCost() {
        Node[] readers;
        Node[][] nodes = new Node[][]{new Node[0], {this.dataNodes[0]}, {this.dataNodes[this.dataNodes.length - 1]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}, {this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}};
        for (Node reader : readers = new Node[]{null, this.dataNodes[0], this.dataNodes[this.dataNodes.length - 1], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)], this.dataNodes[this.random.nextInt(this.dataNodes.length)]}) {
            for (Node[] nodeList : nodes) {
                for (int length = nodeList.length; length > 0; --length) {
                    List ret = this.cluster.sortByDistanceCost(reader, Arrays.asList(nodeList), length);
                    for (int i = 0; i < ret.size(); ++i) {
                        if (i + 1 >= ret.size()) continue;
                        int cost1 = this.cluster.getDistanceCost(reader, (Node)ret.get(i));
                        int cost2 = this.cluster.getDistanceCost(reader, (Node)ret.get(i + 1));
                        Assert.assertTrue((String)("reader:" + (reader != null ? reader.getNetworkFullPath() : "null") + ",node1:" + ((Node)ret.get(i)).getNetworkFullPath() + ",node2:" + ((Node)ret.get(i + 1)).getNetworkFullPath() + ",cost1:" + cost1 + ",cost2:" + cost2), (cost1 == Integer.MAX_VALUE || cost1 <= cost2 ? 1 : 0) != 0);
                    }
                }
            }
        }
        List<Object> nodeList = Arrays.asList((Object[])this.dataNodes.clone());
        for (Node reader : readers) {
            for (int length = nodeList.size(); length >= 0; --length) {
                List sortedNodeList = this.cluster.sortByDistanceCost(reader, nodeList, length);
                for (int i = 0; i < sortedNodeList.size(); ++i) {
                    if (i + 1 >= sortedNodeList.size()) continue;
                    int cost1 = this.cluster.getDistanceCost(reader, (Node)sortedNodeList.get(i));
                    int cost2 = this.cluster.getDistanceCost(reader, (Node)sortedNodeList.get(i + 1));
                    Assert.assertTrue((String)("reader:" + (reader != null ? reader.getNetworkFullPath() : "null") + ",node1:" + ((Node)sortedNodeList.get(i)).getNetworkFullPath() + ",node2:" + ((Node)sortedNodeList.get(i + 1)).getNetworkFullPath() + ",cost1:" + cost1 + ",cost2:" + cost2), (cost1 == Integer.MAX_VALUE || cost1 <= cost2 ? 1 : 0) != 0);
                }
            }
        }
    }

    private static Node createDatanode(String name, String path) {
        return new NodeImpl(name, path, 0);
    }

    private Map<Node, Integer> pickNodesAtRandom(int numNodes, String excludedScope, Collection<Node> excludedNodes, int ancestorGen) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (Node dnd : this.dataNodes) {
            frequency.put(dnd, 0);
        }
        for (int j = 0; j < numNodes; ++j) {
            Node node = this.cluster.chooseRandom(excludedScope, excludedNodes, ancestorGen);
            if (node == null) continue;
            frequency.put(node, (Integer)frequency.get(node) + 1);
        }
        LOG.info("Result:{}", frequency);
        return frequency;
    }

    private Map<Node, Integer> pickNodesAtRandom(int numNodes, String excludedScope, Collection<Node> excludedNodes, Node affinityNode, int ancestorGen) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (Node dnd : this.dataNodes) {
            frequency.put(dnd, 0);
        }
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(excludedScope.substring(1));
        for (int j = 0; j < numNodes; ++j) {
            Node node = this.cluster.chooseRandom("", pathList, excludedNodes, affinityNode, ancestorGen);
            if (node == null) continue;
            frequency.put(node, (Integer)frequency.get(node) + 1);
        }
        LOG.info("Result:{}", frequency);
        return frequency;
    }

    private Map<Node, Integer> pickNodes(int numNodes, List<String> excludedScopes, Collection<Node> excludedNodes, Node affinityNode, int ancestorGen) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (Node dnd : this.dataNodes) {
            frequency.put(dnd, 0);
        }
        excludedNodes = excludedNodes == null ? null : (Collection)excludedNodes.stream().distinct().collect(Collectors.toList());
        for (int j = 0; j < numNodes; ++j) {
            Node node = this.cluster.getNode(j, null, excludedScopes, excludedNodes, affinityNode, ancestorGen);
            if (node == null) continue;
            frequency.put(node, (Integer)frequency.get(node) + 1);
        }
        LOG.info("Result:{}", frequency);
        return frequency;
    }
}

