/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.fs.DU;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;

public class TestDU {
    private static final File DIR = GenericTestUtils.getTestDir((String)TestDU.class.getSimpleName());

    @Before
    public void setUp() {
        Assumptions.assumeFalse((boolean)Shell.WINDOWS);
        FileUtil.fullyDelete((File)DIR);
        Assertions.assertTrue((boolean)DIR.mkdirs());
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)DIR);
    }

    static void createFile(File newFile, int size) throws IOException {
        Random random = new Random();
        byte[] data = new byte[size];
        random.nextBytes(data);
        Assumptions.assumeTrue((boolean)newFile.createNewFile());
        RandomAccessFile file = new RandomAccessFile(newFile, "rws");
        file.write(data);
        file.getFD().sync();
        file.close();
    }

    @Test
    public void testGetUsed() throws Exception {
        long writtenSize = 32768L;
        File file = new File(DIR, "data");
        TestDU.createFile(file, 32768);
        DU du = new DU(file);
        long duSize = du.getUsedSpace();
        TestDU.assertFileSize(32768L, duSize);
    }

    @Test
    public void testExcludePattern() throws IOException {
        TestDU.createFile(new File(DIR, "include.txt"), 4096);
        TestDU.createFile(new File(DIR, "exclude.tmp"), 102400);
        DU du = new DU(DIR, "*.tmp");
        long usedSpace = du.getUsedSpace();
        TestDU.assertFileSize(4096L, usedSpace);
    }

    private static void assertFileSize(long expected, long actual) {
        long max = expected + 8192L;
        Assertions.assertTrue((expected <= actual && actual <= max ? 1 : 0) != 0, () -> String.format("Invalid on-disk size: %d, expected to be in [%d, %d]", actual, expected, max));
    }
}

