/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hdds.fs.CachingSpaceUsageSource;
import org.apache.hadoop.hdds.fs.MockSpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.MockSpaceUsagePersistence;
import org.apache.hadoop.hdds.fs.MockSpaceUsageSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestCachingSpaceUsageSource {
    private static final File DIR = GenericTestUtils.getTestDir((String)TestCachingSpaceUsageSource.class.getSimpleName());

    @Test
    public void providesInitialValueUntilStarted() {
        long initialValue = TestCachingSpaceUsageSource.validInitialValue();
        SpaceUsageCheckParams params = TestCachingSpaceUsageSource.paramsBuilder(new AtomicLong(initialValue)).withRefresh(Duration.ZERO).build();
        CachingSpaceUsageSource subject = new CachingSpaceUsageSource(params);
        Assertions.assertEquals((long)initialValue, (long)subject.getUsedSpace());
    }

    @Test
    public void ignoresMissingInitialValue() {
        SpaceUsageCheckParams params = TestCachingSpaceUsageSource.paramsBuilder().withRefresh(Duration.ZERO).build();
        CachingSpaceUsageSource subject = new CachingSpaceUsageSource(params);
        Assertions.assertEquals((long)0L, (long)subject.getUsedSpace());
    }

    @Test
    public void updatesValueFromSourceUponStartIfPeriodicRefreshNotConfigured() {
        AtomicLong savedValue = new AtomicLong(TestCachingSpaceUsageSource.validInitialValue());
        SpaceUsageCheckParams params = TestCachingSpaceUsageSource.paramsBuilder(savedValue).withRefresh(Duration.ZERO).build();
        CachingSpaceUsageSource subject = new CachingSpaceUsageSource(params);
        subject.start();
        TestCachingSpaceUsageSource.assertSubjectWasRefreshed(params.getSource().getUsedSpace(), (SpaceUsageSource)subject);
    }

    @Test
    public void schedulesRefreshWithDelayIfConfigured() {
        long initialValue = TestCachingSpaceUsageSource.validInitialValue();
        AtomicLong savedValue = new AtomicLong(initialValue);
        SpaceUsageCheckParams params = TestCachingSpaceUsageSource.paramsBuilder(savedValue).build();
        Duration refresh = params.getRefresh();
        ScheduledExecutorService executor = TestCachingSpaceUsageSource.sameThreadExecutorWithoutDelay();
        CachingSpaceUsageSource subject = new CachingSpaceUsageSource(params, executor);
        subject.start();
        TestCachingSpaceUsageSource.verifyRefreshWasScheduled(executor, refresh.toMillis(), refresh);
        TestCachingSpaceUsageSource.assertSubjectWasRefreshed(params.getSource().getUsedSpace(), (SpaceUsageSource)subject);
        Assertions.assertEquals((long)initialValue, (long)savedValue.get(), (String)"value should not have been saved to file yet");
    }

    @Test
    public void schedulesImmediateRefreshIfInitialValueMissing() {
        long initialValue = TestCachingSpaceUsageSource.missingInitialValue();
        AtomicLong savedValue = new AtomicLong(initialValue);
        SpaceUsageCheckParams params = TestCachingSpaceUsageSource.paramsBuilder(savedValue).build();
        ScheduledExecutorService executor = TestCachingSpaceUsageSource.sameThreadExecutorWithoutDelay();
        CachingSpaceUsageSource subject = new CachingSpaceUsageSource(params, executor);
        subject.start();
        TestCachingSpaceUsageSource.verifyRefreshWasScheduled(executor, 0L, params.getRefresh());
        TestCachingSpaceUsageSource.assertSubjectWasRefreshed(params.getSource().getUsedSpace(), (SpaceUsageSource)subject);
        Assertions.assertEquals((long)initialValue, (long)savedValue.get(), (String)"value should not have been saved to file yet");
    }

    @Test
    public void savesValueOnShutdown() {
        AtomicLong savedValue = new AtomicLong(TestCachingSpaceUsageSource.validInitialValue());
        SpaceUsageSource source = (SpaceUsageSource)Mockito.mock(SpaceUsageSource.class);
        long usedSpace = 4L;
        Mockito.when((Object)source.getUsedSpace()).thenReturn((Object)4L, (Object[])new Long[]{5L, 6L});
        SpaceUsageCheckParams params = TestCachingSpaceUsageSource.paramsBuilder(savedValue).withSource(source).build();
        ScheduledFuture future = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        ScheduledExecutorService executor = TestCachingSpaceUsageSource.sameThreadExecutorWithoutDelay(future);
        CachingSpaceUsageSource subject = new CachingSpaceUsageSource(params, executor);
        subject.start();
        subject.shutdown();
        Assertions.assertEquals((long)4L, (long)savedValue.get(), (String)"value should have been saved to file");
        Assertions.assertEquals((long)4L, (long)subject.getUsedSpace(), (String)"no further updates from source expected");
        ((ScheduledFuture)Mockito.verify((Object)future)).cancel(true);
        ((ScheduledExecutorService)Mockito.verify((Object)executor)).shutdown();
    }

    private static long missingInitialValue() {
        return 0L;
    }

    private static long validInitialValue() {
        return RandomUtils.nextLong((long)1L, (long)100L);
    }

    private static MockSpaceUsageCheckParams.Builder paramsBuilder(AtomicLong savedValue) {
        return TestCachingSpaceUsageSource.paramsBuilder().withPersistence(MockSpaceUsagePersistence.inMemory(savedValue));
    }

    private static MockSpaceUsageCheckParams.Builder paramsBuilder() {
        return MockSpaceUsageCheckParams.newBuilder(DIR).withSource(MockSpaceUsageSource.fixed(10000L, 1000L)).withRefresh(Duration.ofMinutes(5L));
    }

    private static ScheduledExecutorService sameThreadExecutorWithoutDelay() {
        return TestCachingSpaceUsageSource.sameThreadExecutorWithoutDelay((ScheduledFuture)Mockito.mock(ScheduledFuture.class));
    }

    private static ScheduledExecutorService sameThreadExecutorWithoutDelay(ScheduledFuture<?> result) {
        ScheduledExecutorService executor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        Mockito.when(executor.scheduleWithFixedDelay((Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            Runnable task = (Runnable)invocation.getArgument(0);
            task.run();
            return result;
        });
        return executor;
    }

    private static void verifyRefreshWasScheduled(ScheduledExecutorService executor, long expectedInitialDelay, Duration refresh) {
        ((ScheduledExecutorService)Mockito.verify((Object)executor)).scheduleWithFixedDelay((Runnable)ArgumentMatchers.any(), ArgumentMatchers.eq((long)expectedInitialDelay), ArgumentMatchers.eq((long)refresh.toMillis()), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    private static void assertSubjectWasRefreshed(long expected, SpaceUsageSource subject) {
        Assertions.assertEquals((long)expected, (long)subject.getUsedSpace(), (String)"subject should have been refreshed");
    }
}

