/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import org.apache.hadoop.hdds.fs.SpaceUsageSource;

public final class MockSpaceUsageSource {
    public static SpaceUsageSource zero() {
        return MockSpaceUsageSource.fixed(0L, 0L);
    }

    public static SpaceUsageSource unlimited() {
        return MockSpaceUsageSource.fixed(Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public static SpaceUsageSource fixed(long capacity, long available) {
        return MockSpaceUsageSource.fixed(capacity, available, capacity - available);
    }

    public static SpaceUsageSource fixed(long capacity, long available, long used) {
        return new Fixed(capacity, available, used);
    }

    private MockSpaceUsageSource() {
        throw new UnsupportedOperationException("no instances");
    }

    private static final class Fixed
    implements SpaceUsageSource {
        private final long capacity;
        private final long available;
        private final long used;

        Fixed(long capacity, long available, long used) {
            this.capacity = capacity;
            this.available = available;
            this.used = used;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public long getAvailable() {
            return this.available;
        }

        public long getUsedSpace() {
            return this.used;
        }
    }
}

