/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.SimpleConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestOzoneConfiguration {
    private Configuration conf;
    @Rule
    public TemporaryFolder tempConfigs = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.conf = new OzoneConfiguration();
    }

    private void startConfig(BufferedWriter out) throws IOException {
        out.write("<?xml version=\"1.0\"?>\n");
        out.write("<configuration>\n");
    }

    private void endConfig(BufferedWriter out) throws IOException {
        out.write("</configuration>\n");
        out.flush();
        out.close();
    }

    @Test
    public void testGetAllPropertiesByTags() throws Exception {
        Path fileResource;
        File coreDefault = this.tempConfigs.newFile("core-default-test.xml");
        File coreSite = this.tempConfigs.newFile("core-site-test.xml");
        try (BufferedWriter out = new BufferedWriter(new FileWriter(coreDefault));){
            this.startConfig(out);
            this.appendProperty(out, "hadoop.tags.system", "YARN,HDFS,NAMENODE");
            this.appendProperty(out, "hadoop.tags.custom", "MYCUSTOMTAG");
            this.appendPropertyByTag(out, "dfs.cblock.trace.io", "false", "YARN");
            this.appendPropertyByTag(out, "dfs.replication", "1", "HDFS");
            this.appendPropertyByTag(out, "dfs.namenode.logging.level", "INFO", "NAMENODE");
            this.appendPropertyByTag(out, "dfs.random.key", "XYZ", "MYCUSTOMTAG");
            this.endConfig(out);
            fileResource = new Path(coreDefault.getAbsolutePath());
            this.conf.addResource(fileResource);
            Assert.assertEquals((Object)this.conf.getAllPropertiesByTag("MYCUSTOMTAG").getProperty("dfs.random.key"), (Object)"XYZ");
        }
        out = new BufferedWriter(new FileWriter(coreSite));
        var4_4 = null;
        try {
            this.startConfig(out);
            this.appendProperty(out, "dfs.random.key", "ABC");
            this.appendProperty(out, "dfs.replication", "3");
            this.appendProperty(out, "dfs.cblock.trace.io", "true");
            this.endConfig(out);
            fileResource = new Path(coreSite.getAbsolutePath());
            this.conf.addResource(fileResource);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var4_4 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
        Assert.assertEquals((Object)"3", (Object)this.conf.getAllPropertiesByTag("HDFS").getProperty("dfs.replication"));
        Assert.assertEquals((Object)"ABC", (Object)this.conf.getAllPropertiesByTag("MYCUSTOMTAG").getProperty("dfs.random.key"));
        Assert.assertEquals((Object)"true", (Object)this.conf.getAllPropertiesByTag("YARN").getProperty("dfs.cblock.trace.io"));
    }

    @Test
    public void getConfigurationObject() {
        OzoneConfiguration ozoneConfig = new OzoneConfiguration();
        ozoneConfig.set("test.scm.client.address", "address");
        ozoneConfig.set("test.scm.client.bind.host", "host");
        ozoneConfig.setBoolean("test.scm.client.enabled", true);
        ozoneConfig.setInt("test.scm.client.port", 5555);
        ozoneConfig.setTimeDuration("test.scm.client.wait", 10L, TimeUnit.MINUTES);
        SimpleConfiguration configuration = (SimpleConfiguration)ozoneConfig.getObject(SimpleConfiguration.class);
        Assert.assertEquals((Object)"host", (Object)configuration.getBindHost());
        Assert.assertEquals((Object)"address", (Object)configuration.getClientAddress());
        Assert.assertEquals((Object)true, (Object)configuration.isEnabled());
        Assert.assertEquals((long)5555L, (long)configuration.getPort());
        Assert.assertEquals((long)600L, (long)configuration.getWaitTime());
    }

    @Test
    public void getConfigurationObjectWithDefault() {
        OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
        SimpleConfiguration configuration = (SimpleConfiguration)ozoneConfiguration.getObject(SimpleConfiguration.class);
        Assert.assertEquals((Object)true, (Object)configuration.isEnabled());
        Assert.assertEquals((long)9878L, (long)configuration.getPort());
    }

    @Test(expected=NumberFormatException.class)
    public void postConstructValidation() {
        OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
        ozoneConfiguration.setInt("test.scm.client.port", -3);
        SimpleConfiguration configuration = (SimpleConfiguration)ozoneConfiguration.getObject(SimpleConfiguration.class);
    }

    private void appendProperty(BufferedWriter out, String name, String val) throws IOException {
        this.appendProperty(out, name, val, false);
    }

    private void appendProperty(BufferedWriter out, String name, String val, boolean isFinal) throws IOException {
        out.write("<property>");
        out.write("<name>");
        out.write(name);
        out.write("</name>");
        out.write("<value>");
        out.write(val);
        out.write("</value>");
        if (isFinal) {
            out.write("<final>true</final>");
        }
        out.write("</property>\n");
    }

    private void appendPropertyByTag(BufferedWriter out, String name, String val, String tags) throws IOException {
        this.appendPropertyByTag(out, name, val, false, tags);
    }

    private void appendPropertyByTag(BufferedWriter out, String name, String val, boolean isFinal, String tag) throws IOException {
        out.write("<property>");
        out.write("<name>");
        out.write(name);
        out.write("</name>");
        out.write("<value>");
        out.write(val);
        out.write("</value>");
        if (isFinal) {
            out.write("<final>true</final>");
        }
        out.write("<tag>");
        out.write(tag);
        out.write("</tag>");
        out.write("</property>\n");
    }
}

