/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestHddsUtils {
    @Test
    public void testGetHostName() {
        Assert.assertEquals(Optional.of("localhost"), (Object)HddsUtils.getHostName((String)"localhost:1234"));
        Assert.assertEquals(Optional.of("localhost"), (Object)HddsUtils.getHostName((String)"localhost"));
        Assert.assertEquals(Optional.empty(), (Object)HddsUtils.getHostName((String)":1234"));
    }

    @Test
    public void validatePath() throws Exception {
        HddsUtils.validatePath((Path)Paths.get("/", new String[0]), (Path)Paths.get("/", new String[0]));
        HddsUtils.validatePath((Path)Paths.get("/a", new String[0]), (Path)Paths.get("/", new String[0]));
        HddsUtils.validatePath((Path)Paths.get("/a", new String[0]), (Path)Paths.get("/a", new String[0]));
        HddsUtils.validatePath((Path)Paths.get("/a/b", new String[0]), (Path)Paths.get("/a", new String[0]));
        HddsUtils.validatePath((Path)Paths.get("/a/b/c", new String[0]), (Path)Paths.get("/a", new String[0]));
        HddsUtils.validatePath((Path)Paths.get("/a/../a/b", new String[0]), (Path)Paths.get("/a", new String[0]));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> HddsUtils.validatePath((Path)Paths.get("/b/c", new String[0]), (Path)Paths.get("/a", new String[0])));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> HddsUtils.validatePath((Path)Paths.get("/", new String[0]), (Path)Paths.get("/a", new String[0])));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> HddsUtils.validatePath((Path)Paths.get("/a/..", new String[0]), (Path)Paths.get("/a", new String[0])));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> HddsUtils.validatePath((Path)Paths.get("/a/../b", new String[0]), (Path)Paths.get("/a", new String[0])));
    }
}

