/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.LongSumReducer;
import org.apache.hadoop.mapreduce.lib.map.RegexMapper;
import org.apache.hadoop.tools.DistCpV1;
import org.apache.hadoop.tools.Logalyzer;

public class Logalyzer {
    private static Configuration fsConfig = new Configuration();
    public static final String SORT_COLUMNS = "logalizer.logcomparator.sort.columns";
    public static final String COLUMN_SEPARATOR = "logalizer.logcomparator.column.separator";

    public void doArchive(String logListURI, String archiveDirectory) throws IOException {
        String destURL = FileSystem.getDefaultUri((Configuration)fsConfig) + archiveDirectory;
        DistCpV1.copy((Configuration)new JobConf(fsConfig), (String)logListURI, (String)destURL, null, (boolean)true, (boolean)false);
    }

    public void doAnalyze(String inputFilesDirectory, String outputDirectory, String grepPattern, String sortColumns, String columnSeparator) throws IOException {
        Path grepInput = new Path(inputFilesDirectory);
        Path analysisOutput = null;
        analysisOutput = outputDirectory.equals("") ? new Path(inputFilesDirectory, "logalyzer_" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE))) : new Path(outputDirectory);
        JobConf grepJob = new JobConf(fsConfig);
        grepJob.setJobName("logalyzer-grep-sort");
        FileInputFormat.setInputPaths((JobConf)grepJob, (Path[])new Path[]{grepInput});
        grepJob.setInputFormat(TextInputFormat.class);
        grepJob.setMapperClass(LogRegexMapper.class);
        grepJob.set(RegexMapper.PATTERN, grepPattern);
        grepJob.set(SORT_COLUMNS, sortColumns);
        grepJob.set(COLUMN_SEPARATOR, columnSeparator);
        grepJob.setCombinerClass(LongSumReducer.class);
        grepJob.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath((JobConf)grepJob, (Path)analysisOutput);
        grepJob.setOutputFormat(TextOutputFormat.class);
        grepJob.setOutputKeyClass(Text.class);
        grepJob.setOutputValueClass(LongWritable.class);
        grepJob.setOutputKeyComparatorClass(LogComparator.class);
        grepJob.setNumReduceTasks(1);
        JobClient.runJob((JobConf)grepJob);
    }

    public static void main(String[] args) {
        Log LOG = LogFactory.getLog(Logalyzer.class);
        String version = "Logalyzer.0.0.1";
        String usage = "Usage: Logalyzer [-archive -logs <urlsFile>] -archiveDir <archiveDirectory> -grep <pattern> -sort <column1,column2,...> -separator <separator> -analysis <outputDirectory>";
        System.out.println(version);
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        boolean archive = false;
        boolean grep = false;
        boolean sort = false;
        String archiveDir = "";
        String logListURI = "";
        String grepPattern = ".*";
        String sortColumns = "";
        String columnSeparator = " ";
        String outputDirectory = "";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-archive")) {
                archive = true;
                continue;
            }
            if (args[i].equals("-archiveDir")) {
                archiveDir = args[++i];
                continue;
            }
            if (args[i].equals("-grep")) {
                grep = true;
                grepPattern = args[++i];
                continue;
            }
            if (args[i].equals("-logs")) {
                logListURI = args[++i];
                continue;
            }
            if (args[i].equals("-sort")) {
                sort = true;
                sortColumns = args[++i];
                continue;
            }
            if (args[i].equals("-separator")) {
                columnSeparator = args[++i];
                continue;
            }
            if (!args[i].equals("-analysis")) continue;
            outputDirectory = args[++i];
        }
        LOG.info((Object)("analysisDir = " + outputDirectory));
        LOG.info((Object)("archiveDir = " + archiveDir));
        LOG.info((Object)("logListURI = " + logListURI));
        LOG.info((Object)("grepPattern = " + grepPattern));
        LOG.info((Object)("sortColumns = " + sortColumns));
        LOG.info((Object)("separator = " + columnSeparator));
        try {
            Logalyzer logalyzer = new Logalyzer();
            if (archive) {
                logalyzer.doArchive(logListURI, archiveDir);
            }
            if (grep || sort) {
                logalyzer.doAnalyze(archiveDir, outputDirectory, grepPattern, sortColumns, columnSeparator);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    static {
        Configuration.addDeprecation((String)"mapred.reducer.sort", (String[])new String[]{SORT_COLUMNS});
        Configuration.addDeprecation((String)"mapred.reducer.separator", (String[])new String[]{COLUMN_SEPARATOR});
    }
}

