/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.Closeable;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.StubContext;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.util.DataChecksum;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCopyMapper {
    private static final Log LOG = LogFactory.getLog(TestCopyMapper.class);
    private static List<Path> pathList = new ArrayList<Path>();
    private static int nFiles = 0;
    private static final int DEFAULT_FILE_SIZE = 1024;
    private static final long NON_DEFAULT_BLOCK_SIZE = 4096L;
    private static MiniDFSCluster cluster;
    private static final String SOURCE_PATH = "/tmp/source";
    private static final String TARGET_PATH = "/tmp/target";
    private static Configuration configuration;

    @BeforeClass
    public static void setup() throws Exception {
        configuration = TestCopyMapper.getConfigurationForCluster();
        cluster = new MiniDFSCluster.Builder(configuration).numDataNodes(1).format(true).build();
    }

    private static Configuration getConfigurationForCluster() throws IOException {
        Configuration configuration = new Configuration();
        System.setProperty("test.build.data", "target/tmp/build/TEST_COPY_MAPPER/data");
        configuration.set("hadoop.log.dir", "target/tmp");
        configuration.set("dfs.namenode.fs-limits.min-block-size", "0");
        LOG.debug((Object)("fs.default.name  == " + configuration.get("fs.default.name")));
        LOG.debug((Object)("dfs.http.address == " + configuration.get("dfs.http.address")));
        return configuration;
    }

    private static Configuration getConfiguration() throws IOException {
        Configuration configuration = TestCopyMapper.getConfigurationForCluster();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path workPath = new Path(TARGET_PATH).makeQualified(fs.getUri(), fs.getWorkingDirectory());
        configuration.set("distcp.target.work.path", workPath.toString());
        configuration.set("distcp.target.final.path", workPath.toString());
        configuration.setBoolean(DistCpOptionSwitch.OVERWRITE.getConfigLabel(), false);
        configuration.setBoolean(DistCpOptionSwitch.SKIP_CRC.getConfigLabel(), false);
        configuration.setBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), true);
        configuration.set(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel(), "br");
        return configuration;
    }

    private static void createSourceData() throws Exception {
        TestCopyMapper.mkdirs("/tmp/source/1");
        TestCopyMapper.mkdirs("/tmp/source/2");
        TestCopyMapper.mkdirs("/tmp/source/2/3/4");
        TestCopyMapper.mkdirs("/tmp/source/2/3");
        TestCopyMapper.mkdirs("/tmp/source/5");
        TestCopyMapper.touchFile("/tmp/source/5/6");
        TestCopyMapper.mkdirs("/tmp/source/7");
        TestCopyMapper.mkdirs("/tmp/source/7/8");
        TestCopyMapper.touchFile("/tmp/source/7/8/9");
    }

    private static void appendSourceData() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        for (Path source : pathList) {
            if (!fs.getFileStatus(source).isFile()) continue;
            TestCopyMapper.appendFile(source, 2048);
        }
    }

    private static void createSourceDataWithDifferentBlockSize() throws Exception {
        TestCopyMapper.mkdirs("/tmp/source/1");
        TestCopyMapper.mkdirs("/tmp/source/2");
        TestCopyMapper.mkdirs("/tmp/source/2/3/4");
        TestCopyMapper.mkdirs("/tmp/source/2/3");
        TestCopyMapper.mkdirs("/tmp/source/5");
        TestCopyMapper.touchFile("/tmp/source/5/6", true, null);
        TestCopyMapper.mkdirs("/tmp/source/7");
        TestCopyMapper.mkdirs("/tmp/source/7/8");
        TestCopyMapper.touchFile("/tmp/source/7/8/9");
    }

    private static void createSourceDataWithDifferentChecksumType() throws Exception {
        TestCopyMapper.mkdirs("/tmp/source/1");
        TestCopyMapper.mkdirs("/tmp/source/2");
        TestCopyMapper.mkdirs("/tmp/source/2/3/4");
        TestCopyMapper.mkdirs("/tmp/source/2/3");
        TestCopyMapper.mkdirs("/tmp/source/5");
        TestCopyMapper.touchFile("/tmp/source/5/6", new Options.ChecksumOpt(DataChecksum.Type.CRC32, 512));
        TestCopyMapper.mkdirs("/tmp/source/7");
        TestCopyMapper.mkdirs("/tmp/source/7/8");
        TestCopyMapper.touchFile("/tmp/source/7/8/9", new Options.ChecksumOpt(DataChecksum.Type.CRC32C, 512));
    }

    private static void mkdirs(String path) throws Exception {
        DistributedFileSystem fileSystem = cluster.getFileSystem();
        Path qualifiedPath = new Path(path).makeQualified(fileSystem.getUri(), fileSystem.getWorkingDirectory());
        pathList.add(qualifiedPath);
        fileSystem.mkdirs(qualifiedPath);
    }

    private static void touchFile(String path) throws Exception {
        TestCopyMapper.touchFile(path, false, null);
    }

    private static void touchFile(String path, Options.ChecksumOpt checksumOpt) throws Exception {
        TestCopyMapper.touchFile(path, true, checksumOpt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void touchFile(String path, boolean createMultipleBlocks, Options.ChecksumOpt checksumOpt) throws Exception {
        FSDataOutputStream outputStream = null;
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path qualifiedPath = new Path(path).makeQualified(fs.getUri(), fs.getWorkingDirectory());
            long blockSize = createMultipleBlocks ? 4096L : fs.getDefaultBlockSize(qualifiedPath) * 2L;
            FsPermission permission = FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)fs.getConf()));
            outputStream = fs.create(qualifiedPath, permission, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), 0, (short)(fs.getDefaultReplication(qualifiedPath) * 2), blockSize, null, checksumOpt);
            byte[] bytes = new byte[1024];
            outputStream.write(bytes);
            if (createMultipleBlocks) {
                for (long fileSize = 1024L; fileSize < 2L * blockSize; fileSize += 1024L) {
                    outputStream.write(bytes);
                    outputStream.flush();
                }
            }
            pathList.add(qualifiedPath);
            ++nFiles;
            FileStatus fileStatus = fs.getFileStatus(qualifiedPath);
            System.out.println(fileStatus.getBlockSize());
            System.out.println(fileStatus.getReplication());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{outputStream});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{outputStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendFile(Path p, int length) throws IOException {
        byte[] toAppend = new byte[length];
        Random random = new Random();
        random.nextBytes(toAppend);
        FSDataOutputStream out = cluster.getFileSystem().append(p);
        try {
            out.write(toAppend);
        }
        finally {
            IOUtils.closeStream((Closeable)out);
        }
    }

    @Test
    public void testCopyWithDifferentChecksumType() throws Exception {
        this.testCopy(true);
    }

    @Test(timeout=40000L)
    public void testRun() throws Exception {
        this.testCopy(false);
    }

    @Test
    public void testCopyWithAppend() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        this.testCopy(false);
        TestCopyMapper.appendSourceData();
        CopyMapper copyMapper = new CopyMapper();
        StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
        Mapper.Context context = stubContext.getContext();
        context.getConfiguration().setBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), true);
        copyMapper.setup(context);
        for (Path path : pathList) {
            copyMapper.map(new Text(DistCpUtils.getRelativePath((Path)new Path(SOURCE_PATH), (Path)path)), new CopyListingFileStatus(cluster.getFileSystem().getFileStatus(path)), context);
        }
        this.verifyCopy((FileSystem)fs, false);
        Assert.assertEquals((long)(nFiles * 1024 * 2), (long)stubContext.getReporter().getCounter((Enum)CopyMapper.Counter.BYTESCOPIED).getValue());
        Assert.assertEquals((long)pathList.size(), (long)stubContext.getReporter().getCounter((Enum)CopyMapper.Counter.COPY).getValue());
    }

    private void testCopy(boolean preserveChecksum) throws Exception {
        TestCopyMapper.deleteState();
        if (preserveChecksum) {
            TestCopyMapper.createSourceDataWithDifferentChecksumType();
        } else {
            TestCopyMapper.createSourceData();
        }
        DistributedFileSystem fs = cluster.getFileSystem();
        CopyMapper copyMapper = new CopyMapper();
        StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
        Mapper.Context context = stubContext.getContext();
        Configuration configuration = context.getConfiguration();
        EnumSet<DistCpOptions.FileAttribute> fileAttributes = EnumSet.of(DistCpOptions.FileAttribute.REPLICATION);
        if (preserveChecksum) {
            fileAttributes.add(DistCpOptions.FileAttribute.CHECKSUMTYPE);
        }
        configuration.set(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel(), DistCpUtils.packAttributes(fileAttributes));
        copyMapper.setup(context);
        for (Path path : pathList) {
            copyMapper.map(new Text(DistCpUtils.getRelativePath((Path)new Path(SOURCE_PATH), (Path)path)), new CopyListingFileStatus(fs.getFileStatus(path)), context);
        }
        this.verifyCopy((FileSystem)fs, preserveChecksum);
        Assert.assertEquals((long)pathList.size(), (long)stubContext.getReporter().getCounter((Enum)CopyMapper.Counter.COPY).getValue());
        if (!preserveChecksum) {
            Assert.assertEquals((long)(nFiles * 1024), (long)stubContext.getReporter().getCounter((Enum)CopyMapper.Counter.BYTESCOPIED).getValue());
        } else {
            Assert.assertEquals((long)((long)nFiles * 4096L * 2L), (long)stubContext.getReporter().getCounter((Enum)CopyMapper.Counter.BYTESCOPIED).getValue());
        }
        this.testCopyingExistingFiles((FileSystem)fs, copyMapper, context);
        for (Text value : stubContext.getWriter().values()) {
            Assert.assertTrue((String)(value.toString() + " is not skipped"), (boolean)value.toString().startsWith("SKIP:"));
        }
    }

    private void verifyCopy(FileSystem fs, boolean preserveChecksum) throws Exception {
        for (Path path : pathList) {
            Path targetPath = new Path(path.toString().replaceAll(SOURCE_PATH, TARGET_PATH));
            Assert.assertTrue((boolean)fs.exists(targetPath));
            Assert.assertTrue((fs.isFile(targetPath) == fs.isFile(path) ? 1 : 0) != 0);
            FileStatus sourceStatus = fs.getFileStatus(path);
            FileStatus targetStatus = fs.getFileStatus(targetPath);
            Assert.assertEquals((long)sourceStatus.getReplication(), (long)targetStatus.getReplication());
            if (preserveChecksum) {
                Assert.assertEquals((long)sourceStatus.getBlockSize(), (long)targetStatus.getBlockSize());
            }
            Assert.assertTrue((!fs.isFile(targetPath) || fs.getFileChecksum(targetPath).equals((Object)fs.getFileChecksum(path)) ? 1 : 0) != 0);
        }
    }

    private void testCopyingExistingFiles(FileSystem fs, CopyMapper copyMapper, Mapper.Context context) {
        try {
            for (Path path : pathList) {
                copyMapper.map(new Text(DistCpUtils.getRelativePath((Path)new Path(SOURCE_PATH), (Path)path)), new CopyListingFileStatus(fs.getFileStatus(path)), context);
            }
            Assert.assertEquals((long)nFiles, (long)context.getCounter((Enum)CopyMapper.Counter.SKIP).getValue());
        }
        catch (Exception exception) {
            Assert.assertTrue((String)("Caught unexpected exception:" + exception.getMessage()), (boolean)false);
        }
    }

    @Test(timeout=40000L)
    public void testMakeDirFailure() {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceData();
            DistributedFileSystem fs = cluster.getFileSystem();
            CopyMapper copyMapper = new CopyMapper();
            StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
            Mapper.Context context = stubContext.getContext();
            Configuration configuration = context.getConfiguration();
            String workPath = new Path("webhdfs://localhost:1234/*/*/*/?/").makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString();
            configuration.set("distcp.target.work.path", workPath);
            copyMapper.setup(context);
            copyMapper.map(new Text(DistCpUtils.getRelativePath((Path)new Path(SOURCE_PATH), (Path)pathList.get(0))), new CopyListingFileStatus(fs.getFileStatus(pathList.get(0))), context);
            Assert.assertTrue((String)"There should have been an exception.", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=40000L)
    public void testIgnoreFailures() {
        this.doTestIgnoreFailures(true);
        this.doTestIgnoreFailures(false);
        this.doTestIgnoreFailuresDoubleWrapped(true);
        this.doTestIgnoreFailuresDoubleWrapped(false);
    }

    @Test(timeout=40000L)
    public void testDirToFile() {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceData();
            DistributedFileSystem fs = cluster.getFileSystem();
            CopyMapper copyMapper = new CopyMapper();
            StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
            Mapper.Context context = stubContext.getContext();
            TestCopyMapper.mkdirs("/tmp/source/src/file");
            TestCopyMapper.touchFile("/tmp/target/src/file");
            try {
                copyMapper.setup(context);
                copyMapper.map(new Text("/src/file"), new CopyListingFileStatus(fs.getFileStatus(new Path("/tmp/source/src/file"))), context);
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Can't replace"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)("Test failed: " + e.getMessage()));
        }
    }

    @Test(timeout=40000L)
    public void testPreserve() {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceData();
            UserGroupInformation tmpUser = UserGroupInformation.createRemoteUser((String)"guest");
            final CopyMapper copyMapper = new CopyMapper();
            final Mapper.Context context = (Mapper.Context)tmpUser.doAs((PrivilegedAction)new PrivilegedAction<Mapper.Context>(){

                @Override
                public Mapper.Context run() {
                    try {
                        StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
                        return stubContext.getContext();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception encountered ", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            EnumSet<DistCpOptions.FileAttribute> preserveStatus = EnumSet.allOf(DistCpOptions.FileAttribute.class);
            preserveStatus.remove(DistCpOptions.FileAttribute.ACL);
            preserveStatus.remove(DistCpOptions.FileAttribute.XATTR);
            context.getConfiguration().set("distcp.preserve.status", DistCpUtils.packAttributes(preserveStatus));
            TestCopyMapper.touchFile("/tmp/source/src/file");
            TestCopyMapper.mkdirs(TARGET_PATH);
            cluster.getFileSystem().setPermission(new Path(TARGET_PATH), new FsPermission(511));
            final FileSystem tmpFS = (FileSystem)tmpUser.doAs((PrivilegedAction)new PrivilegedAction<FileSystem>(){

                @Override
                public FileSystem run() {
                    try {
                        return FileSystem.get((Configuration)configuration);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Exception encountered ", (Throwable)e);
                        Assert.fail((String)("Test failed: " + e.getMessage()));
                        throw new RuntimeException("Test ought to fail here");
                    }
                }
            });
            tmpUser.doAs((PrivilegedAction)new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        copyMapper.setup(context);
                        copyMapper.map(new Text("/src/file"), new CopyListingFileStatus(tmpFS.getFileStatus(new Path("/tmp/source/src/file"))), context);
                        Assert.fail((String)"Expected copy to fail");
                    }
                    catch (AccessControlException e) {
                        Assert.assertTrue((String)("Got exception: " + e.getMessage()), (boolean)true);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)("Test failed: " + e.getMessage()));
        }
    }

    @Test(timeout=40000L)
    public void testCopyReadableFiles() {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceData();
            UserGroupInformation tmpUser = UserGroupInformation.createRemoteUser((String)"guest");
            final CopyMapper copyMapper = new CopyMapper();
            final Mapper.Context context = (Mapper.Context)tmpUser.doAs((PrivilegedAction)new PrivilegedAction<Mapper.Context>(){

                @Override
                public Mapper.Context run() {
                    try {
                        StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
                        return stubContext.getContext();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception encountered ", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            TestCopyMapper.touchFile("/tmp/source/src/file");
            TestCopyMapper.mkdirs(TARGET_PATH);
            cluster.getFileSystem().setPermission(new Path("/tmp/source/src/file"), new FsPermission(FsAction.READ, FsAction.READ, FsAction.READ));
            cluster.getFileSystem().setPermission(new Path(TARGET_PATH), new FsPermission(511));
            final FileSystem tmpFS = (FileSystem)tmpUser.doAs((PrivilegedAction)new PrivilegedAction<FileSystem>(){

                @Override
                public FileSystem run() {
                    try {
                        return FileSystem.get((Configuration)configuration);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Exception encountered ", (Throwable)e);
                        Assert.fail((String)("Test failed: " + e.getMessage()));
                        throw new RuntimeException("Test ought to fail here");
                    }
                }
            });
            tmpUser.doAs((PrivilegedAction)new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        copyMapper.setup(context);
                        copyMapper.map(new Text("/src/file"), new CopyListingFileStatus(tmpFS.getFileStatus(new Path("/tmp/source/src/file"))), context);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)("Test failed: " + e.getMessage()));
        }
    }

    @Test(timeout=40000L)
    public void testSkipCopyNoPerms() {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceData();
            UserGroupInformation tmpUser = UserGroupInformation.createRemoteUser((String)"guest");
            final CopyMapper copyMapper = new CopyMapper();
            final StubContext stubContext = (StubContext)tmpUser.doAs((PrivilegedAction)new PrivilegedAction<StubContext>(){

                @Override
                public StubContext run() {
                    try {
                        return new StubContext(TestCopyMapper.getConfiguration(), null, 0);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception encountered ", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            final Mapper.Context context = stubContext.getContext();
            EnumSet<DistCpOptions.FileAttribute> preserveStatus = EnumSet.allOf(DistCpOptions.FileAttribute.class);
            preserveStatus.remove(DistCpOptions.FileAttribute.ACL);
            preserveStatus.remove(DistCpOptions.FileAttribute.XATTR);
            preserveStatus.remove(DistCpOptions.FileAttribute.TIMES);
            context.getConfiguration().set("distcp.preserve.status", DistCpUtils.packAttributes(preserveStatus));
            TestCopyMapper.touchFile("/tmp/source/src/file");
            TestCopyMapper.touchFile("/tmp/target/src/file");
            cluster.getFileSystem().setPermission(new Path("/tmp/source/src/file"), new FsPermission(FsAction.READ, FsAction.READ, FsAction.READ));
            cluster.getFileSystem().setPermission(new Path("/tmp/target/src/file"), new FsPermission(FsAction.READ, FsAction.READ, FsAction.READ));
            final FileSystem tmpFS = (FileSystem)tmpUser.doAs((PrivilegedAction)new PrivilegedAction<FileSystem>(){

                @Override
                public FileSystem run() {
                    try {
                        return FileSystem.get((Configuration)configuration);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Exception encountered ", (Throwable)e);
                        Assert.fail((String)("Test failed: " + e.getMessage()));
                        throw new RuntimeException("Test ought to fail here");
                    }
                }
            });
            tmpUser.doAs((PrivilegedAction)new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        copyMapper.setup(context);
                        copyMapper.map(new Text("/src/file"), new CopyListingFileStatus(tmpFS.getFileStatus(new Path("/tmp/source/src/file"))), context);
                        Assert.assertEquals((long)stubContext.getWriter().values().size(), (long)1L);
                        Assert.assertTrue((boolean)stubContext.getWriter().values().get(0).toString().startsWith("SKIP"));
                        Assert.assertTrue((boolean)stubContext.getWriter().values().get(0).toString().contains("/tmp/source/src/file"));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)("Test failed: " + e.getMessage()));
        }
    }

    @Test(timeout=40000L)
    public void testFailCopyWithAccessControlException() {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceData();
            UserGroupInformation tmpUser = UserGroupInformation.createRemoteUser((String)"guest");
            final CopyMapper copyMapper = new CopyMapper();
            StubContext stubContext = (StubContext)tmpUser.doAs((PrivilegedAction)new PrivilegedAction<StubContext>(){

                @Override
                public StubContext run() {
                    try {
                        return new StubContext(TestCopyMapper.getConfiguration(), null, 0);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception encountered ", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            EnumSet<DistCpOptions.FileAttribute> preserveStatus = EnumSet.allOf(DistCpOptions.FileAttribute.class);
            preserveStatus.remove(DistCpOptions.FileAttribute.ACL);
            preserveStatus.remove(DistCpOptions.FileAttribute.XATTR);
            final Mapper.Context context = stubContext.getContext();
            context.getConfiguration().set("distcp.preserve.status", DistCpUtils.packAttributes(preserveStatus));
            TestCopyMapper.touchFile("/tmp/source/src/file");
            FSDataOutputStream out = cluster.getFileSystem().create(new Path("/tmp/target/src/file"));
            out.write("hello world".getBytes());
            out.close();
            cluster.getFileSystem().setPermission(new Path("/tmp/source/src/file"), new FsPermission(FsAction.READ, FsAction.READ, FsAction.READ));
            cluster.getFileSystem().setPermission(new Path("/tmp/target/src/file"), new FsPermission(FsAction.READ, FsAction.READ, FsAction.READ));
            final FileSystem tmpFS = (FileSystem)tmpUser.doAs((PrivilegedAction)new PrivilegedAction<FileSystem>(){

                @Override
                public FileSystem run() {
                    try {
                        return FileSystem.get((Configuration)configuration);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Exception encountered ", (Throwable)e);
                        Assert.fail((String)("Test failed: " + e.getMessage()));
                        throw new RuntimeException("Test ought to fail here");
                    }
                }
            });
            tmpUser.doAs((PrivilegedAction)new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    block3: {
                        try {
                            copyMapper.setup(context);
                            copyMapper.map(new Text("/src/file"), new CopyListingFileStatus(tmpFS.getFileStatus(new Path("/tmp/source/src/file"))), context);
                            Assert.fail((String)"Didn't expect the file to be copied");
                        }
                        catch (AccessControlException accessControlException) {
                        }
                        catch (Exception e) {
                            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof AccessControlException) break block3;
                            throw new RuntimeException(e);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)("Test failed: " + e.getMessage()));
        }
    }

    @Test(timeout=40000L)
    public void testFileToDir() {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceData();
            DistributedFileSystem fs = cluster.getFileSystem();
            CopyMapper copyMapper = new CopyMapper();
            StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
            Mapper.Context context = stubContext.getContext();
            TestCopyMapper.touchFile("/tmp/source/src/file");
            TestCopyMapper.mkdirs("/tmp/target/src/file");
            try {
                copyMapper.setup(context);
                copyMapper.map(new Text("/src/file"), new CopyListingFileStatus(fs.getFileStatus(new Path("/tmp/source/src/file"))), context);
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Can't replace"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)("Test failed: " + e.getMessage()));
        }
    }

    private void doTestIgnoreFailures(boolean ignoreFailures) {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceData();
            DistributedFileSystem fs = cluster.getFileSystem();
            CopyMapper copyMapper = new CopyMapper();
            StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
            Mapper.Context context = stubContext.getContext();
            Configuration configuration = context.getConfiguration();
            configuration.setBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), ignoreFailures);
            configuration.setBoolean(DistCpOptionSwitch.OVERWRITE.getConfigLabel(), true);
            configuration.setBoolean(DistCpOptionSwitch.SKIP_CRC.getConfigLabel(), true);
            copyMapper.setup(context);
            for (Path path : pathList) {
                FileStatus fileStatus = fs.getFileStatus(path);
                if (fileStatus.isDirectory()) continue;
                fs.delete(path, true);
                copyMapper.map(new Text(DistCpUtils.getRelativePath((Path)new Path(SOURCE_PATH), (Path)path)), new CopyListingFileStatus(fileStatus), context);
            }
            if (ignoreFailures) {
                for (Text value : stubContext.getWriter().values()) {
                    Assert.assertTrue((String)(value.toString() + " is not skipped"), (boolean)value.toString().startsWith("FAIL:"));
                }
            }
            Assert.assertTrue((String)"There should have been an exception.", (boolean)ignoreFailures);
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Unexpected exception: " + e.getMessage()), (!ignoreFailures ? 1 : 0) != 0);
            e.printStackTrace();
        }
    }

    private void doTestIgnoreFailuresDoubleWrapped(final boolean ignoreFailures) {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceData();
            UserGroupInformation tmpUser = UserGroupInformation.createRemoteUser((String)"guest");
            final CopyMapper copyMapper = new CopyMapper();
            final Mapper.Context context = (Mapper.Context)tmpUser.doAs((PrivilegedAction)new PrivilegedAction<Mapper.Context>(){

                @Override
                public Mapper.Context run() {
                    try {
                        StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
                        return stubContext.getContext();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception encountered when get stub context", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            TestCopyMapper.touchFile("/tmp/source/src/file");
            TestCopyMapper.mkdirs(TARGET_PATH);
            cluster.getFileSystem().setPermission(new Path("/tmp/source/src/file"), new FsPermission(FsAction.NONE, FsAction.NONE, FsAction.NONE));
            cluster.getFileSystem().setPermission(new Path(TARGET_PATH), new FsPermission(511));
            context.getConfiguration().setBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), ignoreFailures);
            final FileSystem tmpFS = (FileSystem)tmpUser.doAs((PrivilegedAction)new PrivilegedAction<FileSystem>(){

                @Override
                public FileSystem run() {
                    try {
                        return FileSystem.get((Configuration)configuration);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Exception encountered when get FileSystem.", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            tmpUser.doAs((PrivilegedAction)new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        copyMapper.setup(context);
                        copyMapper.map(new Text("/src/file"), new CopyListingFileStatus(tmpFS.getFileStatus(new Path("/tmp/source/src/file"))), context);
                        Assert.assertTrue((String)"Should have thrown an IOException if not ignoring failures", (boolean)ignoreFailures);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Unexpected exception encountered. ", (Throwable)e);
                        Assert.assertFalse((String)"Should not have thrown an IOException if ignoring failures", (boolean)ignoreFailures);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception encountered when the mapper copies file.", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected exception encountered. ", (Throwable)e);
            Assert.fail((String)("Test failed: " + e.getMessage()));
        }
    }

    private static void deleteState() throws IOException {
        pathList.clear();
        nFiles = 0;
        cluster.getFileSystem().delete(new Path(SOURCE_PATH), true);
        cluster.getFileSystem().delete(new Path(TARGET_PATH), true);
    }

    @Test(timeout=40000L)
    public void testPreserveBlockSizeAndReplication() {
        this.testPreserveBlockSizeAndReplicationImpl(true);
        this.testPreserveBlockSizeAndReplicationImpl(false);
    }

    @Test(timeout=40000L)
    public void testCopyFailOnBlockSizeDifference() {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceDataWithDifferentBlockSize();
            DistributedFileSystem fs = cluster.getFileSystem();
            CopyMapper copyMapper = new CopyMapper();
            StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
            Mapper.Context context = stubContext.getContext();
            Configuration configuration = context.getConfiguration();
            EnumSet<DistCpOptions.FileAttribute> fileAttributes = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
            configuration.set(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel(), DistCpUtils.packAttributes(fileAttributes));
            copyMapper.setup(context);
            for (Path path : pathList) {
                FileStatus fileStatus = fs.getFileStatus(path);
                copyMapper.map(new Text(DistCpUtils.getRelativePath((Path)new Path(SOURCE_PATH), (Path)path)), new CopyListingFileStatus(fileStatus), context);
            }
            Assert.fail((String)"Copy should have failed because of block-size difference.");
        }
        catch (Exception exception) {
            Assert.assertTrue((String)"Failure exception should have suggested the use of -pb.", (boolean)exception.getCause().getCause().getMessage().contains("pb"));
            Assert.assertTrue((String)"Failure exception should have suggested the use of -skipCrc.", (boolean)exception.getCause().getCause().getMessage().contains("skipCrc"));
        }
    }

    private void testPreserveBlockSizeAndReplicationImpl(boolean preserve) {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceData();
            DistributedFileSystem fs = cluster.getFileSystem();
            CopyMapper copyMapper = new CopyMapper();
            StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
            Mapper.Context context = stubContext.getContext();
            Configuration configuration = context.getConfiguration();
            EnumSet<DistCpOptions.FileAttribute> fileAttributes = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
            if (preserve) {
                fileAttributes.add(DistCpOptions.FileAttribute.BLOCKSIZE);
                fileAttributes.add(DistCpOptions.FileAttribute.REPLICATION);
            }
            configuration.set(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel(), DistCpUtils.packAttributes(fileAttributes));
            copyMapper.setup(context);
            for (Path path : pathList) {
                FileStatus fileStatus = fs.getFileStatus(path);
                copyMapper.map(new Text(DistCpUtils.getRelativePath((Path)new Path(SOURCE_PATH), (Path)path)), new CopyListingFileStatus(fileStatus), context);
            }
            for (Path path : pathList) {
                Path targetPath = new Path(path.toString().replaceAll(SOURCE_PATH, TARGET_PATH));
                FileStatus source = fs.getFileStatus(path);
                FileStatus target = fs.getFileStatus(targetPath);
                if (source.isDirectory()) continue;
                Assert.assertTrue((preserve || source.getBlockSize() != target.getBlockSize() ? 1 : 0) != 0);
                Assert.assertTrue((preserve || source.getReplication() != target.getReplication() ? 1 : 0) != 0);
                Assert.assertTrue((!preserve || source.getBlockSize() == target.getBlockSize() ? 1 : 0) != 0);
                Assert.assertTrue((!preserve || source.getReplication() == target.getReplication() ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Unexpected exception: " + e.getMessage()), (boolean)false);
            e.printStackTrace();
        }
    }

    private static void changeUserGroup(String user, String group) throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        FsPermission changedPermission = new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL);
        for (Path path : pathList) {
            if (!fs.isFile(path)) continue;
            fs.setOwner(path, user, group);
            fs.setPermission(path, changedPermission);
        }
    }

    @Test(timeout=40000L)
    public void testSingleFileCopy() {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.touchFile("/tmp/source/1");
            Path sourceFilePath = pathList.get(0);
            Path targetFilePath = new Path(sourceFilePath.toString().replaceAll(SOURCE_PATH, TARGET_PATH));
            TestCopyMapper.touchFile(targetFilePath.toString());
            DistributedFileSystem fs = cluster.getFileSystem();
            CopyMapper copyMapper = new CopyMapper();
            StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
            Mapper.Context context = stubContext.getContext();
            context.getConfiguration().set("distcp.target.final.path", targetFilePath.getParent().toString());
            copyMapper.setup(context);
            CopyListingFileStatus sourceFileStatus = new CopyListingFileStatus(fs.getFileStatus(sourceFilePath));
            long before = fs.getFileStatus(targetFilePath).getModificationTime();
            copyMapper.map(new Text(DistCpUtils.getRelativePath((Path)new Path(SOURCE_PATH), (Path)sourceFilePath)), sourceFileStatus, context);
            long after = fs.getFileStatus(targetFilePath).getModificationTime();
            Assert.assertTrue((String)"File should have been skipped", (before == after ? 1 : 0) != 0);
            context.getConfiguration().set("distcp.target.final.path", targetFilePath.toString());
            copyMapper.setup(context);
            before = fs.getFileStatus(targetFilePath).getModificationTime();
            try {
                Thread.sleep(2L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            copyMapper.map(new Text(DistCpUtils.getRelativePath((Path)new Path(SOURCE_PATH), (Path)sourceFilePath)), sourceFileStatus, context);
            after = fs.getFileStatus(targetFilePath).getModificationTime();
            Assert.assertTrue((String)"File should have been overwritten.", (before < after ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unexpected exception: " + exception.getMessage()));
            exception.printStackTrace();
        }
    }

    @Test(timeout=40000L)
    public void testPreserveUserGroup() {
        this.testPreserveUserGroupImpl(true);
        this.testPreserveUserGroupImpl(false);
    }

    private void testPreserveUserGroupImpl(boolean preserve) {
        try {
            TestCopyMapper.deleteState();
            TestCopyMapper.createSourceData();
            TestCopyMapper.changeUserGroup("Michael", "Corleone");
            DistributedFileSystem fs = cluster.getFileSystem();
            CopyMapper copyMapper = new CopyMapper();
            StubContext stubContext = new StubContext(TestCopyMapper.getConfiguration(), null, 0);
            Mapper.Context context = stubContext.getContext();
            Configuration configuration = context.getConfiguration();
            EnumSet<DistCpOptions.FileAttribute> fileAttributes = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
            if (preserve) {
                fileAttributes.add(DistCpOptions.FileAttribute.USER);
                fileAttributes.add(DistCpOptions.FileAttribute.GROUP);
                fileAttributes.add(DistCpOptions.FileAttribute.PERMISSION);
            }
            configuration.set(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel(), DistCpUtils.packAttributes(fileAttributes));
            copyMapper.setup(context);
            for (Path path : pathList) {
                FileStatus fileStatus = fs.getFileStatus(path);
                copyMapper.map(new Text(DistCpUtils.getRelativePath((Path)new Path(SOURCE_PATH), (Path)path)), new CopyListingFileStatus(fileStatus), context);
            }
            for (Path path : pathList) {
                Path targetPath = new Path(path.toString().replaceAll(SOURCE_PATH, TARGET_PATH));
                FileStatus source = fs.getFileStatus(path);
                FileStatus target = fs.getFileStatus(targetPath);
                if (source.isDirectory()) continue;
                Assert.assertTrue((!preserve || source.getOwner().equals(target.getOwner()) ? 1 : 0) != 0);
                Assert.assertTrue((!preserve || source.getGroup().equals(target.getGroup()) ? 1 : 0) != 0);
                Assert.assertTrue((!preserve || source.getPermission().equals((Object)target.getPermission()) ? 1 : 0) != 0);
                Assert.assertTrue((preserve || !source.getOwner().equals(target.getOwner()) ? 1 : 0) != 0);
                Assert.assertTrue((preserve || !source.getGroup().equals(target.getGroup()) ? 1 : 0) != 0);
                Assert.assertTrue((preserve || !source.getPermission().equals((Object)target.getPermission()) ? 1 : 0) != 0);
                Assert.assertTrue((source.isDirectory() || source.getReplication() != target.getReplication() ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Unexpected exception: " + e.getMessage()), (boolean)false);
            e.printStackTrace();
        }
    }
}

