/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.OptionsParser;
import org.junit.Assert;
import org.junit.Test;

public class TestOptionsParser {
    private static final float DELTA = 0.001f;

    @Test
    public void testParseIgnoreFailure() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertFalse((boolean)options.shouldIgnoreFailures());
        options = OptionsParser.parse((String[])new String[]{"-i", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldIgnoreFailures());
    }

    @Test
    public void testParseOverwrite() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertFalse((boolean)options.shouldOverwrite());
        options = OptionsParser.parse((String[])new String[]{"-overwrite", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldOverwrite());
        try {
            OptionsParser.parse((String[])new String[]{"-update", "-overwrite", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)"Update and overwrite aren't allowed together");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLogPath() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertNull((Object)options.getLogPath());
        options = OptionsParser.parse((String[])new String[]{"-log", "hdfs://localhost:9820/logs", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((Object)options.getLogPath(), (Object)new Path("hdfs://localhost:9820/logs"));
    }

    @Test
    public void testParseBlokcing() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldBlock());
        options = OptionsParser.parse((String[])new String[]{"-async", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertFalse((boolean)options.shouldBlock());
    }

    @Test
    public void testParsebandwidth() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((float)options.getMapBandwidth(), (float)0.0f, (float)0.001f);
        options = OptionsParser.parse((String[])new String[]{"-bandwidth", "11.2", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((double)options.getMapBandwidth(), (double)11.2, (double)0.001f);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNonPositiveBandwidth() {
        OptionsParser.parse((String[])new String[]{"-bandwidth", "-11", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseZeroBandwidth() {
        OptionsParser.parse((String[])new String[]{"-bandwidth", "0", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
    }

    @Test
    public void testParseSkipCRC() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertFalse((boolean)options.shouldSkipCRC());
        options = OptionsParser.parse((String[])new String[]{"-update", "-skipcrccheck", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldSyncFolder());
        Assert.assertTrue((boolean)options.shouldSkipCRC());
    }

    @Test
    public void testParseAtomicCommit() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertFalse((boolean)options.shouldAtomicCommit());
        options = OptionsParser.parse((String[])new String[]{"-atomic", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldAtomicCommit());
        try {
            OptionsParser.parse((String[])new String[]{"-atomic", "-update", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)"Atomic and sync folders were allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseWorkPath() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertNull((Object)options.getAtomicWorkPath());
        options = OptionsParser.parse((String[])new String[]{"-atomic", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertNull((Object)options.getAtomicWorkPath());
        options = OptionsParser.parse((String[])new String[]{"-atomic", "-tmp", "hdfs://localhost:9820/work", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((Object)options.getAtomicWorkPath(), (Object)new Path("hdfs://localhost:9820/work"));
        try {
            OptionsParser.parse((String[])new String[]{"-tmp", "hdfs://localhost:9820/work", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)"work path was allowed without -atomic switch");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseSyncFolders() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertFalse((boolean)options.shouldSyncFolder());
        options = OptionsParser.parse((String[])new String[]{"-update", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldSyncFolder());
    }

    @Test
    public void testParseDeleteMissing() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertFalse((boolean)options.shouldDeleteMissing());
        options = OptionsParser.parse((String[])new String[]{"-update", "-delete", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldSyncFolder());
        Assert.assertTrue((boolean)options.shouldDeleteMissing());
        options = OptionsParser.parse((String[])new String[]{"-overwrite", "-delete", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldOverwrite());
        Assert.assertTrue((boolean)options.shouldDeleteMissing());
        try {
            OptionsParser.parse((String[])new String[]{"-atomic", "-delete", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)"Atomic and delete folders were allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseMaps() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((long)options.getMaxMaps(), (long)20L);
        options = OptionsParser.parse((String[])new String[]{"-m", "1", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((long)options.getMaxMaps(), (long)1L);
        options = OptionsParser.parse((String[])new String[]{"-m", "0", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((long)options.getMaxMaps(), (long)1L);
        try {
            OptionsParser.parse((String[])new String[]{"-m", "hello", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)"Non numberic map parsed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            OptionsParser.parse((String[])new String[]{"-mapredXslConf", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)"Non numberic map parsed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseNumListstatusThreads() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((long)0L, (long)options.getNumListstatusThreads());
        options = OptionsParser.parse((String[])new String[]{"--numListstatusThreads", "12", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((long)12L, (long)options.getNumListstatusThreads());
        options = OptionsParser.parse((String[])new String[]{"--numListstatusThreads", "0", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((long)0L, (long)options.getNumListstatusThreads());
        try {
            OptionsParser.parse((String[])new String[]{"--numListstatusThreads", "hello", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)"Non numberic numListstatusThreads parsed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        options = OptionsParser.parse((String[])new String[]{"--numListstatusThreads", "100", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((long)40L, (long)options.getNumListstatusThreads());
    }

    @Test
    public void testSourceListing() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((Object)options.getSourceFileListing(), (Object)new Path("hdfs://localhost:9820/source/first"));
    }

    @Test
    public void testSourceListingAndSourcePath() {
        try {
            OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)"Both source listing & source paths allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingSourceInfo() {
        try {
            OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/target/"});
            Assert.fail((String)"Neither source listing not source paths present");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingTarget() {
        try {
            OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:9820/source"});
            Assert.fail((String)"Missing target allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidArgs() {
        try {
            OptionsParser.parse((String[])new String[]{"-m", "-f", "hdfs://localhost:9820/source"});
            Assert.fail((String)"Missing map value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        DistCpOptions option = new DistCpOptions(new Path("abc"), new Path("xyz"));
        String val = "DistCpOptions{atomicCommit=false, syncFolder=false, deleteMissing=false, ignoreFailures=false, overwrite=false, append=false, useDiff=false, useRdiff=false, fromSnapshot=null, toSnapshot=null, skipCRC=false, blocking=true, numListstatusThreads=0, maxMaps=20, mapBandwidth=0.0, copyStrategy='uniformsize', preserveStatus=[], preserveRawXattrs=false, atomicWorkPath=null, logPath=null, sourceFileListing=abc, sourcePaths=null, targetPath=xyz, targetPathExists=true, filtersFile='null'}";
        String optionString = option.toString();
        Assert.assertEquals((Object)val, (Object)optionString);
        Assert.assertNotSame((Object)DistCpOptionSwitch.ATOMIC_COMMIT.toString(), (Object)DistCpOptionSwitch.ATOMIC_COMMIT.name());
    }

    @Test
    public void testCopyStrategy() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-strategy", "dynamic", "-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((Object)options.getCopyStrategy(), (Object)"dynamic");
        options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((Object)options.getCopyStrategy(), (Object)"uniformsize");
    }

    @Test
    public void testTargetPath() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((Object)options.getTargetPath(), (Object)new Path("hdfs://localhost:9820/target/"));
    }

    @Test
    public void testPreserve() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        options = OptionsParser.parse((String[])new String[]{"-p", "-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-p", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-pbr", "-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-pbrgup", "-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-pbrgupcaxt", "-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.TIMES));
        options = OptionsParser.parse((String[])new String[]{"-pc", "-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-p", "-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        int i = 0;
        Iterator attribIterator = options.preserveAttributes();
        while (attribIterator.hasNext()) {
            attribIterator.next();
            ++i;
        }
        Assert.assertEquals((long)i, (long)("-prbugpct".length() - 2));
        try {
            OptionsParser.parse((String[])new String[]{"-pabcd", "-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target"});
            Assert.fail((String)"Invalid preserve attribute");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        options.preserve(DistCpOptions.FileAttribute.PERMISSION);
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        options.preserve(DistCpOptions.FileAttribute.PERMISSION);
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
    }

    @Test
    public void testOptionsSwitchAddToConf() {
        Configuration conf = new Configuration();
        Assert.assertNull((Object)conf.get(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel()));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.ATOMIC_COMMIT);
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel(), false));
    }

    @Test
    public void testOptionsAppendToConf() {
        Configuration conf = new Configuration();
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), false));
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel(), false));
        Assert.assertEquals((Object)conf.getRaw(DistCpOptionSwitch.BANDWIDTH.getConfigLabel()), null);
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-atomic", "-i", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        options.appendToConf(conf);
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), false));
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel(), false));
        Assert.assertEquals((double)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f), (double)-1.0, (double)0.001f);
        conf = new Configuration();
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.DELETE_MISSING.getConfigLabel(), false));
        Assert.assertEquals((Object)conf.get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel()), null);
        options = OptionsParser.parse((String[])new String[]{"-update", "-delete", "-pu", "-bandwidth", "11.2", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        options.appendToConf(conf);
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.DELETE_MISSING.getConfigLabel(), false));
        Assert.assertEquals((Object)conf.get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel()), (Object)"U");
        Assert.assertEquals((double)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f), (double)11.2, (double)0.001f);
    }

    @Test
    public void testOptionsAppendToConfDoesntOverwriteBandwidth() {
        Configuration conf = new Configuration();
        Assert.assertEquals((Object)conf.getRaw(DistCpOptionSwitch.BANDWIDTH.getConfigLabel()), null);
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        Assert.assertEquals((double)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f), (double)-1.0, (double)0.001f);
        conf = new Configuration();
        Assert.assertEquals((Object)conf.getRaw(DistCpOptionSwitch.BANDWIDTH.getConfigLabel()), null);
        options = OptionsParser.parse((String[])new String[]{"-update", "-delete", "-pu", "-bandwidth", "77", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        Assert.assertEquals((double)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f), (double)77.0, (double)0.001f);
        conf = new Configuration();
        conf.set(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), "88");
        Assert.assertEquals((Object)conf.getRaw(DistCpOptionSwitch.BANDWIDTH.getConfigLabel()), (Object)"88");
        options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        Assert.assertEquals((double)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f), (double)88.0, (double)0.001f);
        conf = new Configuration();
        conf.set(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), "88.0");
        Assert.assertEquals((Object)conf.getRaw(DistCpOptionSwitch.BANDWIDTH.getConfigLabel()), (Object)"88.0");
        options = OptionsParser.parse((String[])new String[]{"-bandwidth", "99", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        Assert.assertEquals((double)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f), (double)99.0, (double)0.001f);
    }

    @Test
    public void testAppendOption() {
        Configuration conf = new Configuration();
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), false));
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-update", "-append", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        options.appendToConf(conf);
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), false));
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        try {
            OptionsParser.parse((String[])new String[]{"-append", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)"Append should fail if update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is valid only with update options", (Throwable)e);
        }
        try {
            OptionsParser.parse((String[])new String[]{"-append", "-update", "-skipcrccheck", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)"Append should fail if skipCrc option is specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is disallowed when skipping CRC", (Throwable)e);
        }
    }

    private void testSnapshotDiffOption(boolean isDiff) {
        String optionStr = isDiff ? "-diff" : "-rdiff";
        String optionLabel = isDiff ? DistCpOptionSwitch.DIFF.getConfigLabel() : DistCpOptionSwitch.RDIFF.getConfigLabel();
        Configuration conf = new Configuration();
        Assert.assertFalse((boolean)conf.getBoolean(optionLabel, false));
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-update", optionStr, "s1", "s2", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        options.appendToConf(conf);
        Assert.assertTrue((boolean)conf.getBoolean(optionLabel, false));
        Assert.assertTrue((boolean)(isDiff ? options.shouldUseDiff() : options.shouldUseRdiff()));
        Assert.assertEquals((Object)"s1", (Object)options.getFromSnapshot());
        Assert.assertEquals((Object)"s2", (Object)options.getToSnapshot());
        options = OptionsParser.parse((String[])new String[]{optionStr, "s1", ".", "-update", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        options.appendToConf(conf);
        Assert.assertTrue((boolean)conf.getBoolean(optionLabel, false));
        Assert.assertTrue((boolean)(isDiff ? options.shouldUseDiff() : options.shouldUseRdiff()));
        Assert.assertEquals((Object)"s1", (Object)options.getFromSnapshot());
        Assert.assertEquals((Object)".", (Object)options.getToSnapshot());
        try {
            OptionsParser.parse((String[])new String[]{optionStr, "s1", "-update", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)(optionStr + " should fail with only one snapshot name"));
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Must provide both the starting and ending snapshot names", (Throwable)e);
        }
        try {
            OptionsParser.parse((String[])new String[]{optionStr, "s1", "s2", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)(optionStr + " should fail if -update option is not specified"));
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-diff/-rdiff is valid only with -update option", (Throwable)e);
        }
        try {
            options = OptionsParser.parse((String[])new String[]{optionStr, "s1", "s2", "-update", "-delete", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.assertFalse((String)("-delete should be ignored when " + optionStr + " is specified"), (boolean)options.shouldDeleteMissing());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Got unexpected IllegalArgumentException: " + e.getMessage()));
        }
        try {
            options = OptionsParser.parse((String[])new String[]{optionStr, "s1", "s2", "-delete", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)(optionStr + " should fail if -update option is not specified"));
        }
        catch (IllegalArgumentException e) {
            Assert.assertFalse((String)"-delete should be ignored when -diff is specified", (boolean)options.shouldDeleteMissing());
            GenericTestUtils.assertExceptionContains((String)"-diff/-rdiff is valid only with -update option", (Throwable)e);
        }
        try {
            OptionsParser.parse((String[])new String[]{optionStr, "s1", "s2", "-delete", "-overwrite", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)(optionStr + " should fail if -update option is not specified"));
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-diff/-rdiff is valid only with -update option", (Throwable)e);
        }
        String optionStrOther = isDiff ? "-rdiff" : "-diff";
        try {
            OptionsParser.parse((String[])new String[]{optionStr, "s1", "s2", optionStrOther, "s2", "s1", "-update", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
            Assert.fail((String)(optionStr + " should fail if " + optionStrOther + " is also specified"));
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-diff and -rdiff are mutually exclusive", (Throwable)e);
        }
    }

    @Test
    public void testDiffOption() {
        this.testSnapshotDiffOption(true);
    }

    @Test
    public void testRdiffOption() {
        this.testSnapshotDiffOption(false);
    }

    @Test
    public void testExclusionsOption() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertNull((Object)options.getFiltersFile());
        options = OptionsParser.parse((String[])new String[]{"-filters", "/tmp/filters.txt", "hdfs://localhost:9820/source/first", "hdfs://localhost:9820/target/"});
        Assert.assertEquals((Object)options.getFiltersFile(), (Object)"/tmp/filters.txt");
    }
}

