/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.DistCpSync;
import org.apache.hadoop.tools.SimpleCopyListing;
import org.apache.hadoop.tools.StubContext;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TestDistCpSyncReverseBase {
    private MiniDFSCluster cluster;
    private final Configuration conf = new HdfsConfiguration();
    private DistributedFileSystem dfs;
    private DistCpOptions options;
    private Path source;
    private boolean isSrcNotSameAsTgt = true;
    private final Path target = new Path("/target");
    private final long blockSize = 1024L;
    private final short dataNum = 1;

    abstract void initSourcePath();

    private static List<String> lsr(String prefix, FsShell shell, Path rootDir) throws Exception {
        return TestDistCpSyncReverseBase.lsr(prefix, shell, rootDir.toString(), null);
    }

    private List<String> lsrSource(String prefix, FsShell shell, Path rootDir) throws Exception {
        Path spath = this.isSrcNotSameAsTgt ? rootDir : new Path(rootDir.toString(), ".snapshot/s1");
        return TestDistCpSyncReverseBase.lsr(prefix, shell, spath.toString(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> lsr(String prefix, FsShell shell, String rootDir, String glob) throws Exception {
        String results;
        String dir = glob == null ? rootDir : glob;
        System.out.println(prefix + " lsr root=" + rootDir);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        System.setOut(out);
        System.setErr(out);
        try {
            Assert.assertEquals((long)0L, (long)shell.run(new String[]{"-lsr", dir}));
            results = bytes.toString();
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        System.out.println("lsr results:\n" + results);
        String dirname = rootDir;
        if (rootDir.lastIndexOf("/") != -1) {
            dirname = rootDir.substring(rootDir.lastIndexOf("/"));
        }
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(results, "\n");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            int i = s.indexOf(dirname);
            if (i < 0) continue;
            paths.add(s.substring(i + dirname.length()));
        }
        Collections.sort(paths);
        System.out.println("lsr paths = " + ((Object)paths).toString().replace(", ", ",\n  "));
        return paths;
    }

    public void setSource(Path src) {
        this.source = src;
    }

    public void setSrcNotSameAsTgt(boolean srcNotSameAsTgt) {
        this.isSrcNotSameAsTgt = srcNotSameAsTgt;
    }

    @Before
    public void setUp() throws Exception {
        this.initSourcePath();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
        if (this.isSrcNotSameAsTgt) {
            this.dfs.mkdirs(this.source);
        }
        this.dfs.mkdirs(this.target);
        this.options = new DistCpOptions(Arrays.asList(this.source), this.target);
        this.options.setSyncFolder(true);
        this.options.setUseRdiff("s2", "s1");
        this.options.appendToConf(this.conf);
        this.conf.set("distcp.target.work.path", this.target.toString());
        this.conf.set("distcp.target.final.path", this.target.toString());
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.dfs});
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testFallback() throws Exception {
        Assert.assertFalse((boolean)this.sync());
        Path spath = new Path(this.source, ".snapshot/s1");
        Assert.assertEquals((Object)spath, this.options.getSourcePaths().get(0));
        this.options.setSourcePaths(Arrays.asList(this.source));
        this.dfs.allowSnapshot(this.source);
        this.dfs.allowSnapshot(this.target);
        Assert.assertFalse((boolean)this.sync());
        Assert.assertEquals((Object)spath, this.options.getSourcePaths().get(0));
        this.options.setSourcePaths(Arrays.asList(this.source));
        this.enableAndCreateFirstSnapshot();
        this.dfs.createSnapshot(this.target, "s2");
        Assert.assertTrue((boolean)this.sync());
        this.options.setSourcePaths(Arrays.asList(this.source));
        Path subTarget = new Path(this.target, "sub");
        this.dfs.mkdirs(subTarget);
        Assert.assertFalse((boolean)this.sync());
        Assert.assertEquals((Object)spath, this.options.getSourcePaths().get(0));
        this.options.setSourcePaths(Arrays.asList(this.source));
        this.dfs.delete(subTarget, true);
        Assert.assertTrue((boolean)this.sync());
    }

    private void syncAndVerify() throws Exception {
        FsShell shell = new FsShell(this.conf);
        this.lsrSource("Before sync source: ", shell, this.source);
        TestDistCpSyncReverseBase.lsr("Before sync target: ", shell, this.target);
        Assert.assertTrue((boolean)this.sync());
        this.lsrSource("After sync source: ", shell, this.source);
        TestDistCpSyncReverseBase.lsr("After sync target: ", shell, this.target);
        this.verifyCopy(this.dfs.getFileStatus(this.source), this.dfs.getFileStatus(this.target), false);
    }

    private boolean sync() throws Exception {
        DistCpSync distCpSync = new DistCpSync(this.options, this.conf);
        return distCpSync.sync();
    }

    private void enableAndCreateFirstSnapshot() throws Exception {
        if (this.isSrcNotSameAsTgt) {
            this.dfs.allowSnapshot(this.source);
            this.dfs.createSnapshot(this.source, "s1");
        }
        this.dfs.allowSnapshot(this.target);
        this.dfs.createSnapshot(this.target, "s1");
    }

    private void createSecondSnapshotAtTarget() throws Exception {
        this.dfs.createSnapshot(this.target, "s2");
    }

    private void createMiddleSnapshotAtTarget() throws Exception {
        this.dfs.createSnapshot(this.target, "s1.5");
    }

    private void initData(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path d1 = new Path(foo, "d1");
        Path f1 = new Path(foo, "f1");
        Path d2 = new Path(bar, "d2");
        Path f2 = new Path(bar, "f2");
        Path f3 = new Path(d1, "f3");
        Path f4 = new Path(d2, "f4");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f2, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f3, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f4, (long)1024L, (short)1, (long)0L);
    }

    private int changeData(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path d1 = new Path(foo, "d1");
        Path f2 = new Path(bar, "f2");
        Path bar_d1 = new Path(bar, "d1");
        int numDeletedModified = 0;
        this.dfs.rename(d1, bar_d1);
        ++numDeletedModified;
        ++numDeletedModified;
        Path f3 = new Path(bar_d1, "f3");
        this.dfs.delete(f3, true);
        ++numDeletedModified;
        Path newfoo = new Path(bar_d1, "foo");
        this.dfs.rename(foo, newfoo);
        ++numDeletedModified;
        Path f1 = new Path(newfoo, "f1");
        this.dfs.delete(f1, true);
        ++numDeletedModified;
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)2048L, (short)1, (long)0L);
        DFSTestUtil.appendFile((FileSystem)this.dfs, (Path)f2, (int)1024);
        this.dfs.rename(bar, new Path(dir, "foo"));
        return ++numDeletedModified;
    }

    @Test
    public void testSync() throws Exception {
        if (this.isSrcNotSameAsTgt) {
            this.initData(this.source);
        }
        this.initData(this.target);
        this.enableAndCreateFirstSnapshot();
        FsShell shell = new FsShell(this.conf);
        this.lsrSource("Before source: ", shell, this.source);
        TestDistCpSyncReverseBase.lsr("Before target: ", shell, this.target);
        int numDeletedModified = this.changeData(this.target);
        this.createSecondSnapshotAtTarget();
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.target, "s2", "s1");
        System.out.println(report);
        DistCpSync distCpSync = new DistCpSync(this.options, this.conf);
        TestDistCpSyncReverseBase.lsr("Before sync target: ", shell, this.target);
        Assert.assertTrue((boolean)distCpSync.sync());
        TestDistCpSyncReverseBase.lsr("After sync target: ", shell, this.target);
        Path spath = new Path(this.source, ".snapshot/s1");
        Assert.assertEquals((Object)spath, this.options.getSourcePaths().get(0));
        Path listingPath = new Path("/tmp/META/fileList.seq");
        SimpleCopyListing listing = new SimpleCopyListing(this.conf, new Credentials(), distCpSync);
        listing.buildListing(listingPath, this.options);
        Map<Text, CopyListingFileStatus> copyListing = this.getListing(listingPath);
        CopyMapper copyMapper = new CopyMapper();
        StubContext stubContext = new StubContext(this.conf, null, 0);
        Mapper.Context context = stubContext.getContext();
        context.getConfiguration().setBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), true);
        copyMapper.setup(context);
        for (Map.Entry<Text, CopyListingFileStatus> entry : copyListing.entrySet()) {
            copyMapper.map(entry.getKey(), entry.getValue(), context);
        }
        this.lsrSource("After mapper source: ", shell, this.source);
        TestDistCpSyncReverseBase.lsr("After mapper target: ", shell, this.target);
        Assert.assertEquals((long)numDeletedModified, (long)copyListing.size());
        Assert.assertEquals((long)3072L, (long)stubContext.getReporter().getCounter((Enum)CopyMapper.Counter.BYTESCOPIED).getValue());
        this.verifyCopy(this.dfs.getFileStatus(spath), this.dfs.getFileStatus(this.target), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Text, CopyListingFileStatus> getListing(Path listingPath) throws Exception {
        HashMap<Text, CopyListingFileStatus> values = new HashMap<Text, CopyListingFileStatus>();
        try (SequenceFile.Reader reader = null;){
            reader = new SequenceFile.Reader(this.conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)listingPath)});
            Text key = new Text();
            CopyListingFileStatus value = new CopyListingFileStatus();
            while (reader.next((Writable)key, (Writable)value)) {
                values.put(key, value);
                key = new Text();
                value = new CopyListingFileStatus();
            }
        }
        return values;
    }

    private void verifyCopy(FileStatus s, FileStatus t, boolean compareName) throws Exception {
        Assert.assertEquals((Object)s.isDirectory(), (Object)t.isDirectory());
        if (compareName) {
            Assert.assertEquals((Object)s.getPath().getName(), (Object)t.getPath().getName());
        }
        if (!s.isDirectory()) {
            byte[] sbytes = DFSTestUtil.readFileBuffer((FileSystem)this.dfs, (Path)s.getPath());
            byte[] tbytes = DFSTestUtil.readFileBuffer((FileSystem)this.dfs, (Path)t.getPath());
            Assert.assertArrayEquals((byte[])sbytes, (byte[])tbytes);
        } else {
            FileStatus[] slist = this.dfs.listStatus(s.getPath());
            FileStatus[] tlist = this.dfs.listStatus(t.getPath());
            Assert.assertEquals((long)slist.length, (long)tlist.length);
            for (int i = 0; i < slist.length; ++i) {
                this.verifyCopy(slist[i], tlist[i], true);
            }
        }
    }

    @Test
    public void testSyncWithCurrent() throws Exception {
        this.options.setUseRdiff(".", "s1");
        if (this.isSrcNotSameAsTgt) {
            this.initData(this.source);
        }
        this.initData(this.target);
        this.enableAndCreateFirstSnapshot();
        this.changeData(this.target);
        Assert.assertTrue((boolean)this.sync());
        Path spath = new Path(this.source, ".snapshot/s1");
        Assert.assertEquals((Object)spath, this.options.getSourcePaths().get(0));
    }

    private void initData2(Path dir) throws Exception {
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path f1 = new Path(test, "f1");
        Path f2 = new Path(foo, "f2");
        Path f3 = new Path(bar, "f3");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f2, (long)1024L, (short)1, (long)1L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f3, (long)1024L, (short)1, (long)2L);
    }

    private void changeData2(Path dir) throws Exception {
        Path tmpFoo = new Path(dir, "tmpFoo");
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        this.dfs.rename(test, tmpFoo);
        this.dfs.rename(foo, test);
        this.dfs.rename(bar, foo);
        this.dfs.rename(tmpFoo, bar);
    }

    @Test
    public void testSync2() throws Exception {
        if (this.isSrcNotSameAsTgt) {
            this.initData2(this.source);
        }
        this.initData2(this.target);
        this.enableAndCreateFirstSnapshot();
        this.changeData2(this.target);
        this.createSecondSnapshotAtTarget();
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.target, "s2", "s1");
        System.out.println(report);
        this.syncAndVerify();
    }

    private void initData3(Path dir) throws Exception {
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path f1 = new Path(test, "file");
        Path f2 = new Path(foo, "file");
        Path f3 = new Path(bar, "file");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f2, (long)2048L, (short)1, (long)1L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f3, (long)3072L, (short)1, (long)2L);
    }

    private void changeData3(Path dir) throws Exception {
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path f1 = new Path(test, "file");
        Path f2 = new Path(foo, "file");
        Path f3 = new Path(bar, "file");
        Path newf1 = new Path(test, "newfile");
        Path newf2 = new Path(foo, "newfile");
        Path newf3 = new Path(bar, "newfile");
        this.dfs.rename(f1, newf1);
        this.dfs.rename(f2, newf2);
        this.dfs.rename(f3, newf3);
    }

    @Test
    public void testSync3() throws Exception {
        if (this.isSrcNotSameAsTgt) {
            this.initData3(this.source);
        }
        this.initData3(this.target);
        this.enableAndCreateFirstSnapshot();
        this.changeData3(this.target);
        this.createSecondSnapshotAtTarget();
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.target, "s2", "s1");
        System.out.println(report);
        this.syncAndVerify();
    }

    private void initData4(Path dir) throws Exception {
        Path d1 = new Path(dir, "d1");
        Path d2 = new Path(d1, "d2");
        Path f1 = new Path(d2, "f1");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
    }

    private int changeData4(Path dir) throws Exception {
        Path d1 = new Path(dir, "d1");
        Path d11 = new Path(dir, "d11");
        Path d2 = new Path(d1, "d2");
        Path d21 = new Path(d1, "d21");
        Path f1 = new Path(d2, "f1");
        int numDeletedAndModified = 0;
        this.dfs.delete(f1, false);
        ++numDeletedAndModified;
        this.dfs.rename(d2, d21);
        ++numDeletedAndModified;
        this.dfs.rename(d1, d11);
        return ++numDeletedAndModified;
    }

    @Test
    public void testSync4() throws Exception {
        if (this.isSrcNotSameAsTgt) {
            this.initData4(this.source);
        }
        this.initData4(this.target);
        this.enableAndCreateFirstSnapshot();
        FsShell shell = new FsShell(this.conf);
        TestDistCpSyncReverseBase.lsr("Before change target: ", shell, this.target);
        int numDeletedAndModified = this.changeData4(this.target);
        this.createSecondSnapshotAtTarget();
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.target, "s2", "s1");
        System.out.println(report);
        this.testAndVerify(numDeletedAndModified);
    }

    private void initData5(Path dir) throws Exception {
        Path d1 = new Path(dir, "d1");
        Path d2 = new Path(dir, "d2");
        Path f1 = new Path(d1, "f1");
        Path f2 = new Path(d2, "f2");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f2, (long)1024L, (short)1, (long)0L);
    }

    private int changeData5(Path dir) throws Exception {
        Path d1 = new Path(dir, "d1");
        Path d2 = new Path(dir, "d2");
        Path f1 = new Path(d1, "f1");
        Path tmp = new Path(dir, "tmp");
        int numDeletedAndModified = 0;
        this.dfs.delete(f1, false);
        ++numDeletedAndModified;
        this.dfs.rename(d1, tmp);
        ++numDeletedAndModified;
        this.dfs.rename(d2, d1);
        ++numDeletedAndModified;
        Path f2 = new Path(d1, "f2");
        this.dfs.delete(f2, false);
        return ++numDeletedAndModified;
    }

    @Test
    public void testSync5() throws Exception {
        if (this.isSrcNotSameAsTgt) {
            this.initData5(this.source);
        }
        this.initData5(this.target);
        this.enableAndCreateFirstSnapshot();
        int numDeletedAndModified = this.changeData5(this.target);
        this.createSecondSnapshotAtTarget();
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.target, "s2", "s1");
        System.out.println(report);
        this.testAndVerify(numDeletedAndModified);
    }

    private void testAndVerify(int numDeletedAndModified) throws Exception {
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.target, "s2", "s1");
        System.out.println(report);
        FsShell shell = new FsShell(this.conf);
        this.lsrSource("Before sync source: ", shell, this.source);
        TestDistCpSyncReverseBase.lsr("Before sync target: ", shell, this.target);
        DistCpSync distCpSync = new DistCpSync(this.options, this.conf);
        distCpSync.sync();
        TestDistCpSyncReverseBase.lsr("After sync target: ", shell, this.target);
        Path spath = new Path(this.source, ".snapshot/s1");
        Assert.assertEquals((Object)spath, this.options.getSourcePaths().get(0));
        Path listingPath = new Path("/tmp/META/fileList.seq");
        SimpleCopyListing listing = new SimpleCopyListing(this.conf, new Credentials(), distCpSync);
        listing.buildListing(listingPath, this.options);
        Map<Text, CopyListingFileStatus> copyListing = this.getListing(listingPath);
        CopyMapper copyMapper = new CopyMapper();
        StubContext stubContext = new StubContext(this.conf, null, 0);
        Mapper.Context context = stubContext.getContext();
        context.getConfiguration().setBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), true);
        copyMapper.setup(context);
        for (Map.Entry<Text, CopyListingFileStatus> entry : copyListing.entrySet()) {
            copyMapper.map(entry.getKey(), entry.getValue(), context);
        }
        Assert.assertEquals((long)numDeletedAndModified, (long)copyListing.size());
        TestDistCpSyncReverseBase.lsr("After Copy target: ", shell, this.target);
        this.verifyCopy(this.dfs.getFileStatus(spath), this.dfs.getFileStatus(this.target), false);
    }

    private void initData6(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path foo_f1 = new Path(foo, "f1");
        Path bar_f1 = new Path(bar, "f1");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)bar_f1, (long)1024L, (short)1, (long)0L);
    }

    private int changeData6(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path foo2 = new Path(dir, "foo2");
        Path foo_f1 = new Path(foo, "f1");
        int numDeletedModified = 0;
        this.dfs.rename(foo, foo2);
        this.dfs.rename(bar, foo);
        this.dfs.rename(foo2, bar);
        DFSTestUtil.appendFile((FileSystem)this.dfs, (Path)foo_f1, (int)1024);
        return ++numDeletedModified;
    }

    @Test
    public void testSync6() throws Exception {
        if (this.isSrcNotSameAsTgt) {
            this.initData6(this.source);
        }
        this.initData6(this.target);
        this.enableAndCreateFirstSnapshot();
        int numDeletedModified = this.changeData6(this.target);
        this.createSecondSnapshotAtTarget();
        this.testAndVerify(numDeletedModified);
    }

    private void initData7(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path foo_f1 = new Path(foo, "f1");
        Path bar_f1 = new Path(bar, "f1");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)bar_f1, (long)1024L, (short)1, (long)0L);
    }

    private int changeData7(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path foo2 = new Path(dir, "foo2");
        Path foo_f1 = new Path(foo, "f1");
        Path foo2_f2 = new Path(foo2, "f2");
        Path foo_d1 = new Path(foo, "d1");
        Path foo_d1_f3 = new Path(foo_d1, "f3");
        int numDeletedAndModified = 0;
        this.dfs.rename(foo, foo2);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.appendFile((FileSystem)this.dfs, (Path)foo_f1, (int)1024);
        this.dfs.rename(foo_f1, foo2_f2);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_d1_f3, (long)1024L, (short)1, (long)0L);
        return ++numDeletedAndModified;
    }

    @Test
    public void testSync7() throws Exception {
        if (this.isSrcNotSameAsTgt) {
            this.initData7(this.source);
        }
        this.initData7(this.target);
        this.enableAndCreateFirstSnapshot();
        int numDeletedAndModified = this.changeData7(this.target);
        this.createSecondSnapshotAtTarget();
        this.testAndVerify(numDeletedAndModified);
    }

    private void initData8(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path d1 = new Path(dir, "d1");
        Path foo_f1 = new Path(foo, "f1");
        Path bar_f1 = new Path(bar, "f1");
        Path d1_f1 = new Path(d1, "f1");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)bar_f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)d1_f1, (long)1024L, (short)1, (long)0L);
    }

    private int changeData8(Path dir, boolean createMiddleSnapshot) throws Exception {
        Path foo = new Path(dir, "foo");
        Path createdDir = new Path(dir, "c");
        Path d1 = new Path(dir, "d1");
        Path d1_f1 = new Path(d1, "f1");
        Path createdDir_f1 = new Path(createdDir, "f1");
        Path foo_f3 = new Path(foo, "f3");
        Path new_foo = new Path(createdDir, "foo");
        Path foo_f4 = new Path(foo, "f4");
        Path foo_d1 = new Path(foo, "d1");
        Path bar = new Path(dir, "bar");
        Path bar1 = new Path(dir, "bar1");
        int numDeletedAndModified = 0;
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f3, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)createdDir_f1, (long)1024L, (short)1, (long)0L);
        this.dfs.rename(createdDir_f1, foo_f4);
        this.dfs.rename(d1_f1, createdDir_f1);
        ++numDeletedAndModified;
        if (createMiddleSnapshot) {
            this.createMiddleSnapshotAtTarget();
        }
        this.dfs.rename(d1, foo_d1);
        this.dfs.rename(foo, new_foo);
        this.dfs.rename(bar, bar1);
        return ++numDeletedAndModified;
    }

    @Test
    public void testSync8() throws Exception {
        if (this.isSrcNotSameAsTgt) {
            this.initData8(this.source);
        }
        this.initData8(this.target);
        this.enableAndCreateFirstSnapshot();
        int numDeletedModified = this.changeData8(this.target, false);
        this.createSecondSnapshotAtTarget();
        this.testAndVerify(numDeletedModified);
    }

    @Test
    public void testSync9() throws Exception {
        if (this.isSrcNotSameAsTgt) {
            this.initData8(this.source);
        }
        this.initData8(this.target);
        this.enableAndCreateFirstSnapshot();
        int numDeletedModified = this.changeData8(this.target, true);
        this.createSecondSnapshotAtTarget();
        this.testAndVerify(numDeletedModified);
    }
}

