/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.map.WrappedMapper;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.hadoop.tools.CopyListingFileStatus;

public class StubContext {
    private StubStatusReporter reporter = new StubStatusReporter();
    private RecordReader<Text, CopyListingFileStatus> reader;
    private StubInMemoryWriter writer = new StubInMemoryWriter();
    private Mapper.Context mapperContext;

    public StubContext(Configuration conf, RecordReader<Text, CopyListingFileStatus> reader, int taskId) throws IOException, InterruptedException {
        WrappedMapper wrappedMapper = new WrappedMapper();
        MapContextImpl contextImpl = new MapContextImpl(conf, StubContext.getTaskAttemptID(taskId), reader, (RecordWriter)this.writer, null, (StatusReporter)this.reporter, null);
        this.reader = reader;
        this.mapperContext = wrappedMapper.getMapContext((MapContext)contextImpl);
    }

    public Mapper.Context getContext() {
        return this.mapperContext;
    }

    public StatusReporter getReporter() {
        return this.reporter;
    }

    public RecordReader<Text, CopyListingFileStatus> getReader() {
        return this.reader;
    }

    public void setReader(RecordReader<Text, CopyListingFileStatus> reader) {
        this.reader = reader;
    }

    public StubInMemoryWriter getWriter() {
        return this.writer;
    }

    public static TaskAttemptID getTaskAttemptID(int taskId) {
        return new TaskAttemptID("", 0, TaskType.MAP, taskId, 0);
    }

    public static class StubInMemoryWriter
    extends RecordWriter<Text, Text> {
        List<Text> keys = new ArrayList<Text>();
        List<Text> values = new ArrayList<Text>();

        public void write(Text key, Text value) throws IOException, InterruptedException {
            this.keys.add(key);
            this.values.add(value);
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public List<Text> keys() {
            return this.keys;
        }

        public List<Text> values() {
            return this.values;
        }
    }

    public static class StubStatusReporter
    extends StatusReporter {
        private Counters counters = new Counters();

        public Counter getCounter(Enum<?> name) {
            return this.counters.findCounter(name);
        }

        public Counter getCounter(String group, String name) {
            return this.counters.findCounter(group, name);
        }

        public void progress() {
        }

        public float getProgress() {
            return 0.0f;
        }

        public void setStatus(String status) {
        }
    }
}

