/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.apache.hadoop.tools.mapred.RetriableDirectoryCreateCommand;
import org.apache.hadoop.tools.mapred.RetriableFileCopyCommand;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CopyMapper
extends Mapper<Text, CopyListingFileStatus, Text, Text> {
    private static Log LOG = LogFactory.getLog(CopyMapper.class);
    private Configuration conf;
    private boolean syncFolders = false;
    private boolean ignoreFailures = false;
    private boolean skipCrc = false;
    private boolean overWrite = false;
    private boolean append = false;
    private boolean verboseLog = false;
    private EnumSet<DistCpOptions.FileAttribute> preserve = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
    private FileSystem targetFS = null;
    private Path targetWorkPath = null;

    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.conf = context.getConfiguration();
        this.syncFolders = this.conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false);
        this.ignoreFailures = this.conf.getBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), false);
        this.skipCrc = this.conf.getBoolean(DistCpOptionSwitch.SKIP_CRC.getConfigLabel(), false);
        this.overWrite = this.conf.getBoolean(DistCpOptionSwitch.OVERWRITE.getConfigLabel(), false);
        this.append = this.conf.getBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), false);
        this.verboseLog = this.conf.getBoolean(DistCpOptionSwitch.VERBOSE_LOG.getConfigLabel(), false);
        this.preserve = DistCpUtils.unpackAttributes((String)this.conf.get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel()));
        this.targetWorkPath = new Path(this.conf.get("distcp.target.work.path"));
        Path targetFinalPath = new Path(this.conf.get("distcp.target.final.path"));
        this.targetFS = targetFinalPath.getFileSystem(this.conf);
        try {
            this.overWrite = this.overWrite || this.targetFS.getFileStatus(targetFinalPath).isFile();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (this.conf.get("distcp.keystore.resource") != null) {
            this.initializeSSLConf(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSSLConf(Mapper.Context context) throws IOException {
        LOG.info((Object)"Initializing SSL configuration");
        String workDir = this.conf.get("mapreduce.job.local.dir") + "/work";
        Object[] cacheFiles = context.getLocalCacheFiles();
        Configuration sslConfig = new Configuration(false);
        String sslConfFileName = this.conf.get("distcp.keystore.resource");
        Path sslClient = this.findCacheFile((Path[])cacheFiles, sslConfFileName);
        if (sslClient == null) {
            LOG.warn((Object)("SSL Client config file not found. Was looking for " + sslConfFileName + " in " + Arrays.toString(cacheFiles)));
            return;
        }
        sslConfig.addResource(sslClient);
        String trustStoreFile = this.conf.get("ssl.client.truststore.location");
        Path trustStorePath = this.findCacheFile((Path[])cacheFiles, trustStoreFile);
        sslConfig.set("ssl.client.truststore.location", trustStorePath.toString());
        String keyStoreFile = this.conf.get("ssl.client.keystore.location");
        Path keyStorePath = this.findCacheFile((Path[])cacheFiles, keyStoreFile);
        sslConfig.set("ssl.client.keystore.location", keyStorePath.toString());
        try {
            try (FileOutputStream out = new FileOutputStream(workDir + "/" + sslConfFileName);){
                sslConfig.writeXml((OutputStream)out);
            }
            this.conf.set("dfs.https.client.keystore.resource", sslConfFileName);
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to write out the ssl configuration. Will fall back to default ssl-client.xml in class path, if there is one", (Throwable)e);
        }
    }

    private Path findCacheFile(Path[] cacheFiles, String fileName) {
        if (cacheFiles != null && cacheFiles.length > 0) {
            for (Path file : cacheFiles) {
                if (!file.getName().equals(fileName)) continue;
                return file;
            }
        }
        return null;
    }

    public void map(Text relPath, CopyListingFileStatus sourceFileStatus, Mapper.Context context) throws IOException, InterruptedException {
        Path sourcePath = sourceFileStatus.getPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DistCpMapper::map(): Received " + sourcePath + ", " + relPath));
        }
        Path target = new Path(this.targetWorkPath.makeQualified(this.targetFS.getUri(), this.targetFS.getWorkingDirectory()) + relPath.toString());
        EnumSet fileAttributes = CopyMapper.getFileAttributeSettings((Mapper.Context)context);
        boolean preserveRawXattrs = context.getConfiguration().getBoolean("distcp.preserve.rawxattrs", false);
        String description = "Copying " + sourcePath + " to " + target;
        context.setStatus(description);
        LOG.info((Object)description);
        try {
            FileStatus targetStatus;
            CopyListingFileStatus sourceCurrStatus;
            FileSystem sourceFS;
            block14: {
                try {
                    sourceFS = sourcePath.getFileSystem(this.conf);
                    boolean preserveXAttrs = fileAttributes.contains(DistCpOptions.FileAttribute.XATTR);
                    sourceCurrStatus = DistCpUtils.toCopyListingFileStatusHelper((FileSystem)sourceFS, (FileStatus)sourceFS.getFileStatus(sourcePath), (boolean)fileAttributes.contains(DistCpOptions.FileAttribute.ACL), (boolean)preserveXAttrs, (boolean)preserveRawXattrs, (long)sourceFileStatus.getChunkOffset(), (long)sourceFileStatus.getChunkLength());
                }
                catch (FileNotFoundException e) {
                    throw new IOException((Throwable)new RetriableFileCopyCommand.CopyReadException((Throwable)e));
                }
                targetStatus = null;
                try {
                    targetStatus = this.targetFS.getFileStatus(target);
                }
                catch (FileNotFoundException ignore) {
                    if (!LOG.isDebugEnabled()) break block14;
                    LOG.debug((Object)("Path could not be found: " + target), (Throwable)ignore);
                }
            }
            if (targetStatus != null && targetStatus.isDirectory() != sourceCurrStatus.isDirectory()) {
                throw new IOException("Can't replace " + target + ". Target is " + this.getFileType(targetStatus) + ", Source is " + this.getFileType(sourceCurrStatus));
            }
            if (sourceCurrStatus.isDirectory()) {
                this.createTargetDirsWithRetry(description, target, context);
                return;
            }
            FileAction action = this.checkUpdate(sourceFS, sourceCurrStatus, target, targetStatus);
            Path tmpTarget = target;
            if (action == FileAction.SKIP) {
                LOG.info((Object)("Skipping copy of " + sourceCurrStatus.getPath() + " to " + target));
                CopyMapper.updateSkipCounters((Mapper.Context)context, (CopyListingFileStatus)sourceCurrStatus);
                context.write(null, (Object)new Text("SKIP: " + sourceCurrStatus.getPath()));
                if (this.verboseLog) {
                    context.write(null, (Object)new Text("FILE_SKIPPED: source=" + sourceFileStatus.getPath() + ", size=" + sourceFileStatus.getLen() + " --> " + "target=" + target + ", size=" + (targetStatus == null ? 0L : targetStatus.getLen())));
                }
            } else {
                if (sourceCurrStatus.isSplit()) {
                    tmpTarget = DistCpUtils.getSplitChunkPath((Path)target, (CopyListingFileStatus)sourceCurrStatus);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("copying " + sourceCurrStatus + " " + tmpTarget));
                }
                this.copyFileWithRetry(description, sourceCurrStatus, tmpTarget, targetStatus, context, action, fileAttributes);
            }
            DistCpUtils.preserve((FileSystem)target.getFileSystem(this.conf), (Path)tmpTarget, (CopyListingFileStatus)sourceCurrStatus, (EnumSet)fileAttributes, (boolean)preserveRawXattrs);
        }
        catch (IOException exception) {
            this.handleFailures(exception, sourceFileStatus, target, context);
        }
    }

    private String getFileType(CopyListingFileStatus fileStatus) {
        if (null == fileStatus) {
            return "N/A";
        }
        return fileStatus.isDirectory() ? "dir" : "file";
    }

    private String getFileType(FileStatus fileStatus) {
        if (null == fileStatus) {
            return "N/A";
        }
        return fileStatus.isDirectory() ? "dir" : "file";
    }

    private static EnumSet<DistCpOptions.FileAttribute> getFileAttributeSettings(Mapper.Context context) {
        String attributeString = context.getConfiguration().get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel());
        return DistCpUtils.unpackAttributes((String)attributeString);
    }

    private void copyFileWithRetry(String description, CopyListingFileStatus sourceFileStatus, Path target, FileStatus targrtFileStatus, Mapper.Context context, FileAction action, EnumSet<DistCpOptions.FileAttribute> fileAttributes) throws IOException, InterruptedException {
        long bytesCopied;
        try {
            bytesCopied = (Long)new RetriableFileCopyCommand(this.skipCrc, description, action).execute(new Object[]{sourceFileStatus, target, context, fileAttributes});
        }
        catch (Exception e) {
            context.setStatus("Copy Failure: " + sourceFileStatus.getPath());
            throw new IOException("File copy failed: " + sourceFileStatus.getPath() + " --> " + target, e);
        }
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.BYTESEXPECTED, (long)sourceFileStatus.getLen());
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.BYTESCOPIED, (long)bytesCopied);
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.COPY, (long)1L);
        if (this.verboseLog) {
            context.write(null, (Object)new Text("FILE_COPIED: source=" + sourceFileStatus.getPath() + "," + " size=" + sourceFileStatus.getLen() + " --> " + "target=" + target + ", size=" + (targrtFileStatus == null ? 0L : targrtFileStatus.getLen())));
        }
    }

    private void createTargetDirsWithRetry(String description, Path target, Mapper.Context context) throws IOException {
        try {
            new RetriableDirectoryCreateCommand(description).execute(new Object[]{target, context});
        }
        catch (Exception e) {
            throw new IOException("mkdir failed for " + target, e);
        }
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.DIR_COPY, (long)1L);
    }

    private static void updateSkipCounters(Mapper.Context context, CopyListingFileStatus sourceFile) {
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.SKIP, (long)1L);
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.BYTESSKIPPED, (long)sourceFile.getLen());
    }

    private void handleFailures(IOException exception, CopyListingFileStatus sourceFileStatus, Path target, Mapper.Context context) throws IOException, InterruptedException {
        LOG.error((Object)("Failure in copying " + sourceFileStatus.getPath() + (sourceFileStatus.isSplit() ? ", offset=" + sourceFileStatus.getChunkOffset() + " chunkLength=" + sourceFileStatus.getChunkLength() : "") + " to " + target), (Throwable)exception);
        if (!this.ignoreFailures || ExceptionUtils.indexOfType((Throwable)exception, RetriableFileCopyCommand.CopyReadException.class) == -1) {
            throw exception;
        }
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.FAIL, (long)1L);
        CopyMapper.incrementCounter((Mapper.Context)context, (Counter)Counter.BYTESFAILED, (long)sourceFileStatus.getLen());
        context.write(null, (Object)new Text("FAIL: " + sourceFileStatus.getPath() + " - " + StringUtils.stringifyException((Throwable)exception)));
    }

    private static void incrementCounter(Mapper.Context context, Counter counter, long value) {
        context.getCounter((Enum)counter).increment(value);
    }

    private FileAction checkUpdate(FileSystem sourceFS, CopyListingFileStatus source, Path target, FileStatus targetFileStatus) throws IOException {
        if (targetFileStatus != null && !this.overWrite) {
            FileChecksum sourceChecksum;
            long targetLen;
            if (this.canSkip(sourceFS, source, targetFileStatus)) {
                return FileAction.SKIP;
            }
            if (this.append && (targetLen = targetFileStatus.getLen()) < source.getLen() && (sourceChecksum = sourceFS.getFileChecksum(source.getPath(), targetLen)) != null && sourceChecksum.equals((Object)this.targetFS.getFileChecksum(target))) {
                return FileAction.APPEND;
            }
        }
        return FileAction.OVERWRITE;
    }

    private boolean canSkip(FileSystem sourceFS, CopyListingFileStatus source, FileStatus target) throws IOException {
        boolean sameBlockSize;
        if (!this.syncFolders) {
            return true;
        }
        boolean sameLength = target.getLen() == source.getLen();
        boolean bl = sameBlockSize = source.getBlockSize() == target.getBlockSize() || !this.preserve.contains(DistCpOptions.FileAttribute.BLOCKSIZE);
        if (sameLength && sameBlockSize) {
            return this.skipCrc || DistCpUtils.checksumsAreEqual((FileSystem)sourceFS, (Path)source.getPath(), null, (FileSystem)this.targetFS, (Path)target.getPath());
        }
        return false;
    }
}

